package com.mx.dla.dda.contrato.condicionesLicense.constants;

import com.mx.dla.dda.catalogos.dtos.Catalogable;


public enum TipoCondicion implements Catalogable {
	
	SUSCRIPTORES("SUSCRIPTOR","Suscriptores"),
	POR_ANIO("ANNIO","Por Ao"),
;
	
	private String type;
	
	private String desc;
	
	TipoCondicion(String type , String desc)
	{
		this.type = type;
		this.desc = desc;
	}
	
	public String getDesc() {
		return desc;
	}
	public String getType() {
		return type;
	}
	
	@Override
	public String getValue() {
		return type;
	}
	
	public static TipoCondicion parse(String tipo)
	{
		TipoCondicion [] values = TipoCondicion.values();
		TipoCondicion target = null;
		for(TipoCondicion t : values)
		{
			if(t.getType().equals(tipo))
			{
				target = t;
				break;
			}
		}
		return target;
		
	}
	
	
}
