package com.mx.dla.dda.carga.transaccion.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.carga.transaccion.bos.CargaTransaccionesBO;
import com.mx.dla.dda.carga.transaccion.dtos.CargaTransaccionesDTO;
import com.mx.dla.dda.carga.transaccion.dtos.RowRepErrAsocTitulosDTO;
import com.mx.dla.dda.carga.transaccion.dtos.RowRepErrResumenCargaDTO;
import com.mx.dla.dda.carga.transaccion.dtos.RowReporteCargaDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.listado.dtos.ContentType;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

public class DescargaArchivosTransaccionesAction extends BaseContratoAction {

	private static final long serialVersionUID = 281552368437405368L;
	private String error;
	private Long idCarga;
	private String mes;
	private List<CargaTransaccionesDTO> cargaTransacciones;
	private List<RowReporteCargaDTO> vistaPrevia;
	private List<RowRepErrResumenCargaDTO> detalleErroresCarga;
	private List<RowRepErrAsocTitulosDTO> listadoErrAsociaTitulos;

	private InputStream fileInputStream;
	private String fileFileName;

	@Autowired
	private CargaTransaccionesBO cargaTransaccionesBO;

	public String descargaArchivo() {
		logger.info("se : [{}]", error);

		String nombre;
		byte[] vistaPrevia;

		try {
			System.out.println("si sirve..." + cargaTransacciones);

			vistaPrevia = cargaTransaccionesBO.descargarArchivoTransacciones(cargaTransacciones);
			nombre = "reporteCargaTransacciones";

			HttpServletResponse response = ServletActionContext.getResponse();
			response.setContentLength(vistaPrevia.length);
			response.setContentType(ContentType.EXCELX.name());
			response.setHeader("Content-Disposition", "attachment;filename=" + nombre + ".xlsx");

			ServletOutputStream out = response.getOutputStream();
			out.write(vistaPrevia);
			out.flush();
			out.close();

		} catch (ResultMapException e) {
			error = e.getMessage();
		} catch (PersistenceException e) {
			error = e.getMessage();
		} catch (TransaccionException e) {
			error = e.getMessage();
		} catch (SQLException e) {
			error = e.getMessage();
		} catch (IOException e) {
			error = e.getMessage();
		}
		return SUCCESS;
	}

	// funcion para descarga excel en vista previa
	public String descargaArchivoVistaPrevia() {
		logger.info("se vista previa : [{}]", error);
		String nombre;
		byte[] vistaPreviac;
		try {

			vistaPreviac = cargaTransaccionesBO.descargaArchivoVistaPrevia(vistaPrevia);

			nombre = "reporteVistaPreviaCargaTransacciones";

			HttpServletResponse response = ServletActionContext.getResponse();
			response.setContentLength(vistaPreviac.length);
			response.setContentType(ContentType.EXCELX.name());
			response.setHeader("Content-Disposition", "attachment;filename=" + nombre + ".xlsx");

			ServletOutputStream out = response.getOutputStream();
			out.write(vistaPreviac);
			out.flush();
			out.close();
		} catch (ResultMapException e) {
			error = e.getMessage();
		} catch (PersistenceException e) {
			error = e.getMessage();
		} catch (TransaccionException e) {
			error = e.getMessage();
		} catch (SQLException e) {
			error = e.getMessage();
		} catch (IOException e) {
			error = e.getMessage();
		}

		return SUCCESS;

	}

	// may-17 action para descarga resumen error carga transacciones
	/*
	 * public String descargaReporteErrorResumenCarga(){ String nombre; try { byte
	 * [] repDetalleError =
	 * cargaTransaccionesBO.descargaArchivoResumenErroresCarga(detalleErroresCarga);
	 * 
	 * fileInputStream = new ByteArrayInputStream(repDetalleError); nombre =
	 * "reporteDetalleErrorCargaTransacciones"; fileFileName = nombre;
	 * 
	 * return SUCCESS; } catch(Exception e) { logger.error("Error ",e);
	 * error="Ocurrio un error al descargar el documento"; return ERROR; } }
	 */
	public String descargaReporteErrorResumenCarga() {
		logger.info("se resumen carga : [{}]", error);
		String nombre;
		byte[] repDetalleError;
		try {
			nombre = "reporteDetalleErrorCargaTransacciones.xlsx";
			repDetalleError = cargaTransaccionesBO.obtenerDetalleErroresCarga(mes);
			fileInputStream = new ByteArrayInputStream(repDetalleError);
			fileFileName = nombre;
		} catch (ResultMapException e) {
			error = e.getMessage();
			logger.error("DescargaExcelDetalleErrorCargaT: Error al procesar el archivo Excel..." + e + "  ___ " + error);
		} catch (PersistenceException e) {
			error = e.getMessage();
			logger.error("DescargaExcelDetalleErrorCargaT: Error al procesar el archivo Excel..." + e + "  ___ " + error);
		} catch (TransaccionException e) {
			error = e.getMessage();
			logger.error("DescargaExcelDetalleErrorCargaT: Error al procesar el archivo Excel..." + e + "  ___ " + error);
		} catch (SQLException e) {
			error = e.getMessage();
			logger.error("DescargaExcelDetalleErrorCargaT: Error al procesar el archivo Excel..." + e + "  ___ " + error);
		}

		return SUCCESS;

	}

	// action para descarga de archivo excel dentro de asociacion de titulos
	public String descargaReporteErrAsocTitulos() {
		logger.info("error en resumen carga : [{}]", error);
		String nombre;
		byte[] repAsocTitulos;

		try {
			repAsocTitulos = cargaTransaccionesBO.obtenerListaErrAsocTitulos(idCarga);
			logger.info("descargaArchivoErrAsocTitulos..." + repAsocTitulos);
			logger.info("idCarga..." + idCarga);
			nombre = "reporteErroresAsociacionTitulos.xlsx";
			fileInputStream = new ByteArrayInputStream(repAsocTitulos);
			fileFileName = nombre;
		} catch (ResultMapException e) {
			error = e.getMessage();
			logger.error("descargaArchivoErrAsocTitulos: Error al procesar el archivo Excel..." + e + "  ___ " + error);
		} catch (PersistenceException e) {
			error = e.getMessage();
			logger.error("descargaArchivoErrAsocTitulos: Error al procesar el archivo Excel..." + e + "  ___ " + error);
		} catch (TransaccionException e) {
			error = e.getMessage();
			logger.error("descargaArchivoErrAsocTitulos: Error al procesar el archivo Excel..." + e + "  ___ " + error);
		} catch (SQLException e) {
			error = e.getMessage();
			logger.error("descargaArchivoErrAsocTitulos: Error al procesar el archivo Excel..." + e + "  ___ " + error);
		}

		return SUCCESS;

	}

	public void setError(String error) {
		this.error = error;
	}

	public String getError() {
		return error;
	}

	public void setCargaTransacciones(List<CargaTransaccionesDTO> cargaTransacciones) {
		this.cargaTransacciones = cargaTransacciones;
	}

	public List<CargaTransaccionesDTO> getCargaTransacciones() {
		return cargaTransacciones;
	}

	public void setVistaPrevia(List<RowReporteCargaDTO> vistaPrevia) {
		this.vistaPrevia = vistaPrevia;
	}

	public List<RowReporteCargaDTO> getVistaPrevia() {
		return vistaPrevia;
	}

	public List<RowRepErrResumenCargaDTO> getDetalleErroresCarga() {
		return detalleErroresCarga;
	}

	public void setDetalleErroresCarga(List<RowRepErrResumenCargaDTO> detalleErroresCarga) {
		this.detalleErroresCarga = detalleErroresCarga;
	}

	public List<RowRepErrAsocTitulosDTO> getListadoErrAsociaTitulos() {
		return listadoErrAsociaTitulos;
	}

	public void setListadoErrAsociaTitulos(List<RowRepErrAsocTitulosDTO> listadoErrAsociaTitulos) {
		this.listadoErrAsociaTitulos = listadoErrAsociaTitulos;
	}

	public void setFileInputStream(InputStream fileInputStream) {
		this.fileInputStream = fileInputStream;
	}

	public void setFileFileName(String fileFileName) {
		this.fileFileName = fileFileName;
	}

	public String getFileFileName() {
		return fileFileName;
	}

	public InputStream getFileInputStream() {
		return fileInputStream;
	}

	public Long getIdCarga() {
		return idCarga;
	}

	public void setIdCarga(Long idCarga) {
		this.idCarga = idCarga;
	}

	public String getMes() {
		return mes;
	}

	public void setMes(String mes) {
		this.mes = mes;
	}

}
