function limpiarElementos() {
	$("#maOrigen").val("");
	$("#maDestino").val("");
	$("#mcOrigen").val("");
	$("#mcDestino").val("");
	$("#mRedistribur").val("");
	$("#apOrigen").empty().append('<option value="-1">Selecciona Apartado</option>');
	$("#apDestino").empty().append('<option value="-1">Selecciona Apartado</option>');
}

function registrarApartadoRedistribucion(presupuesto, anio) {
	onChangeSelectApartadoRedis(presupuesto, anio);
}

function onChangeSelectApartadoRedis(presupuesto, anio) {
	var apartados = presupuesto.apartados;


	for (var j = 0; j < apartados.length; j++) {
		if (tipoPresupuesto == "Amortizable") {
			if (apartados[j].fechaSAP != null && apartados[j].montoAsignado != null && apartados[j].montoAsignado > 0)
				addOptionSelect("apOrigen", '<option idAp="' + apartados[j].idPreApart + '" value="' + apartados[j].id + '"  >' + apartados[j].nombre + '</option>');

			addOptionSelect("apDestino", '<option idAp="' + apartados[j].idPreApart + '" value="' + apartados[j].id + '"  >' + apartados[j].nombre + '</option>');
		}
		else {
			if (apartados[j].montoAsignado != null && apartados[j].montoAsignado > 0)
				addOptionSelect("apOrigen", '<option idAp="' + apartados[j].idPreApart + '" value="' + apartados[j].id + '"  >' + apartados[j].nombre + '</option>');

			var idpre = apartados[j].idPreApart == null ? -1 : apartados[j].idPreApart;
			addOptionSelect("apDestino", '<option idAp="' + idpre + '" value="' + apartados[j].id + '"  >' + apartados[j].nombre + '</option>');
		}
	}
}


function llenarApartado(tipo) {

	var maLabel = tipo == "origen" ? "maOrigen" : "maDestino";
	var mcLabel = tipo == "origen" ? "mcOrigen" : "mcDestino";
	var maHidLabel = tipo == "origen" ? "maOrigenHid" : "maDestinHid";
	var sourceLabel = tipo == "origen" ? "apOrigen" : "apDestino";
	var targetLabel = tipo == "origen" ? "apDestino" : "apOrigen";
	var selectedVal = null;

	selectedVal = $("#" + sourceLabel + " option:selected").attr('value');

	//Se necesita esto para que IExplorer tambien muestre el mismo option de un select
	$("#" + targetLabel).find('option').map(function() {
		return $(this).parent('span').length !== 0 ? this : null;
	}).unwrap().show();

	if (selectedVal != -1) {

		var presupuesto = getPresupuestosAnio(tipoPresupuesto, $("#anio").val());
		var apartado = service.getApartadoPresupuesto(presupuesto,
			parseInt(selectedVal));
		var asignado = apartado.montoAsignado == null ? 0.0
			: apartado.montoAsignado;
		var comprometido = apartado.montoComprometido == null ? 0.0
			: apartado.montoComprometido;

		//Se necesita esto para que IExplorer tambien oculte el mismo option de un select
		$("#" + targetLabel).children("option[value^=" + selectedVal + "]").wrap('<span>')
			.hide();

		$("#" + maHidLabel).val(asignado);
		$("#" + maLabel).val("$" + parseFloat(asignado).formatDLA());
		$("#" + mcLabel).val("$" + parseFloat(comprometido).formatDLA());

	} else {
		$("#" + maLabel).val("");
		$("#" + mcLabel).val("");
	}

}


function onChangeMonto() {
	$("#redLabel").hide();

	if (!validarMontoRedistribuir()) {
		if ($("#chmontoDisponible").prop("checked"))
			$("#redLabel").text("El monto a distribuir no dede ser mayor al monto disponible.").show();
		else
			$("#redLabel").text("El monto a distribuir no dede ser mayor al monto asignado - monto comprometido.").show();

	}
	else {
		if ($("#chmontoDisponible").prop("checked")) {
			var montoActualDis = parseFloat(deformatDLA($("#redismontoDisponible").val())) - parseFloat(deformatDLA($("#mRedistribur").val()));
			var montoActualDes = parseFloat($("#maDestinHid").val()) + parseFloat(deformatDLA($("#mRedistribur").val()));
			$("#redismontoDisponible").val("$" + montoActualDis.formatDLA());
			$("#maDestino").val("$" + montoActualDes.formatDLA());
			$("#mRedistribur").val(parseFloat($("#mRedistribur").val()).formatDLA())

			if (montoActualDis < $("#mcOrigen").val())
				$("#redLabel").text("La redistribuci&oacute;n no se puede aplicar, el monto comprometido no se cumple.").show();
			else if ($("#redismontoDisponible").val() === $("#apDestino").val())
				$("#redLabel").text("El monto disponible y el apartado destino deben ser diferentes.").show();

		}
		else {
			var montoActualOri = parseFloat($("#maOrigenHid").val()) - parseFloat(deformatDLA($("#mRedistribur").val()));
			var montoActualDes = parseFloat($("#maDestinHid").val()) + parseFloat(deformatDLA($("#mRedistribur").val()));

			$("#maOrigen").val("$" + montoActualOri.formatDLA());
			$("#maDestino").val("$" + montoActualDes.formatDLA());
			$("#mRedistribur").val(parseFloat($("#mRedistribur").val()).formatDLA())

			if (montoActualOri < $("#mcOrigen").val())
				$("#redLabel").text("La redistribución no se puede aplicar, el monto comprometido no se cumple.").show();
			else if ($("#apOrigen").val() === $("#apDestino").val())
				$("#redLabel").text("Los apartado origen y destino deben ser diferentes.").show();
		}
	}
}

function validarMontoRedistribuir() {
	var montoAsignado = parseFloat(deformatDLA($("#maOrigen").val()));
	var montoComprometido = parseFloat(deformatDLA($("#mcOrigen").val()));
	var montoRedistribuir = parseFloat(deformatDLA($("#mRedistribur").val()));
	var montoDisponible = parseFloat(deformatDLA($("#redismontoDisponible").val()));

	if ($("#chmontoDisponible").prop("checked")) {
		if (montoRedistribuir <= montoDisponible)
			return true;
		else
			return false;
	}
	else {
		if (montoRedistribuir <= (montoAsignado - montoComprometido))
			return true;
		else
			return false;
	}
}

function guardarRedistribucion() {

	var apartadosAct = [];

	//Se verifica que los apartados y origen no sean los mismos
	$("#redLabel").hide();

	if ($("#mRedistribur").val() == "")
		$("#redLabel").text("No se ha registrado ningun monto para distribuir.").show();

	if ($("#chmontoDisponible").prop("checked")) {
		$("#btnGudDis").prop("disabled", true);
		$("#labelProcesandoDis").show();

		//Se obtienen los valores actuales y anteriores del apartados destino
		var apartadoDestNuevo = new Apartado('');
		apartadoDestNuevo.id = parseInt($("#apDestino option:selected").val());
		apartadoDestNuevo.idPreApart = parseInt($("#apDestino option:selected").attr('idAp'));
		apartadoDestNuevo.montoAsignado = parseFloat(deformatDLA($("#mRedistribur").val()));
		apartadoDestNuevo.type = tipoPresupuesto;

		var presupuesto = getPresupuestosAnio(tipoPresupuesto, $("#anio").val());
		var apartadoDestActual = service.getApartadoPresupuesto(presupuesto, parseInt($("#apDestino option:selected").val()));

		apartadoDestNuevo.idSap = apartadoDestActual.idSap == null ? null : apartadoDestActual.idSap;

		apartadoDestActual.idPreApart == null ? -1 : apartadoDestActual.idPreApart;

		apartadosAct.push(apartadoDestNuevo);
		apartadosAct.push(apartadoDestActual);

		service.guardarRedistribucionMontoDisp(apartadosAct, tipoPresupuesto, $("#anio").val());

	}
	else {
		if ($("#apOrigen").val() === $("#apDestino").val())
			$("#redLabel").text("Los apartado origen y destino deben ser diferentes.").show();
		else {
			$("#btnGudDis").prop("disabled", true);
			$("#labelProcesandoDis").show();

			//Se obtienen los valores actuales y anteriores de los apartados origen y destino
			var apartadoOriNuevo = new Apartado('');
			apartadoOriNuevo.id = parseInt($("#apOrigen option:selected").val());
			apartadoOriNuevo.idPreApart = parseInt($("#apOrigen option:selected").attr('idAp'));
			apartadoOriNuevo.montoAsignado = parseFloat(deformatDLA($("#mRedistribur").val()));
			apartadoOriNuevo.type = tipoPresupuesto;

			var apartadoDestNuevo = new Apartado('');
			apartadoDestNuevo.id = parseInt($("#apDestino option:selected").val());
			apartadoDestNuevo.idPreApart = parseInt($("#apDestino option:selected").attr('idAp'));
			apartadoDestNuevo.montoAsignado = parseFloat(deformatDLA($("#mRedistribur").val()));
			apartadoDestNuevo.type = tipoPresupuesto;

			var presupuesto = getPresupuestosAnio(tipoPresupuesto, $("#anio").val());
			var apartadoOriActual = service.getApartadoPresupuesto(presupuesto, parseInt($("#apOrigen option:selected").val()));
			var apartadoDestActual = service.getApartadoPresupuesto(presupuesto, parseInt($("#apDestino option:selected").val()));

			apartadoOriNuevo.idSap = apartadoOriActual.idSap == null ? null : apartadoOriActual.idSap;
			apartadoDestNuevo.idSap = apartadoDestActual.idSap == null ? null : apartadoDestActual.idSap;

			apartadoDestActual.idPreApart == null ? -1 : apartadoDestActual.idPreApart;

			apartadosAct.push(apartadoOriNuevo);
			apartadosAct.push(apartadoOriActual);
			apartadosAct.push(apartadoDestNuevo);
			apartadosAct.push(apartadoDestActual);
			modificados.push(apartadoOriNuevo.idPreApart);
			service.guardarRedistribucion(apartadosAct, tipoPresupuesto, $("#anio").val());
		}

	}
}