package com.mx.dla.dda.contrato.ws.validapresupuesto;

import java.io.Serializable;
import java.util.List;

/**
 * Representa la respuesta que sera enviada al ejecutar el proceso de validar Presupuesto por Contrato
 * Incluye una lista de mensajes y resultado de la transaccion.
 * Ajustado 17 Ago 2017 Sos
 * La validacion ahora incluye una validacion de uno o varios aos, por eso el mensaje cambia a una lista
 */
public class ResponseValidaPresupuestoCntDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;	
	private boolean resultado;
	private List<String> mensaje;
	
	public boolean getResultado() {
		return resultado;
	}
	public void setResultado(boolean resultado) {
		this.resultado = resultado;
	}
	
	public List<String> getMensaje() {
		return this.mensaje;
	}
	public void setMensaje(List<String> mensaje) {
		this.mensaje = mensaje;
	}
	
	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);		
		result.append(" resultado: _" + this.getResultado() + "_" + NEW_LINE);	
		result.append(" mensaje: _" + this.getMensaje().size() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}
	
}
