package com.mx.dla.dda.contrato.amortizacion.actions;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.amortizacion.bos.AmortizacionBO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.common.constants.ContratoConstats;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.titulo.dtos.Lista;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;
import com.mx.dla.dda.contrato.titulo.exception.TituloException;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

public class AmortizacionAction extends BaseContratoAction {

	private static final long serialVersionUID = -1880333104009351799L;

	@Autowired
	private AmortizacionBO amortizacionBO;

	@Autowired
	private GeneralesBO generalesBO;

	private Lista lista;

	private List<Titulo> titulos;

	private Titulo titulo;

	private String error;

	@Override
	public String execute() throws TransaccionException {
		Long idC = (Long) getSession().get(ContratoConstats.ID_CONTRATO_SESSION);
		ContratoDTO ct;
		try {
			ct = generalesBO.obtenContrato(idC);
			getSession().put(ContratoConstats.CONTRATO_SESSION, ct);
			lista = amortizacionBO.buscarListaActual(ct);
			getSession().put(ContratoConstats.LISTA_SESSION, lista);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		return SUCCESS;
	}

	public String busqueda() {
		ContratoDTO ct = (ContratoDTO) getSession().get(ContratoConstats.CONTRATO_SESSION);
		Lista li = (Lista) getSession().get(ContratoConstats.LISTA_SESSION);
		try {
			titulos = amortizacionBO.busqueda(ct, li, titulo);
		} catch (TituloException e) {
			setError(e.getMessage());
		} catch (SocketTimeoutException e) {
			setError(e.getMessage());
		} catch (IOException e) {
			setError(e.getMessage());
		} catch (TransaccionException e) {
			setError(e.getMessage());
		}
		return SUCCESS;
	}

	public String busquedaDetalle() {
		try {
			titulos = amortizacionBO.busquedaDetalle(titulo);
		} catch (TituloException e) {
			setError(e.getMessage());
		}
		return SUCCESS;
	}

	public String find() {
		return SUCCESS;
	}

	public Lista getLista() {
		return lista;
	}

	public void setLista(Lista lista) {
		this.lista = lista;
	}

	public Titulo getTitulo() {
		return titulo;
	}

	public void setTitulo(Titulo titulo) {
		this.titulo = titulo;
	}

	public List<Titulo> getTitulos() {
		return titulos;
	}

	public void setTitulos(List<Titulo> titulos) {
		this.titulos = titulos;
	}

	public String getError() {
		return error;
	}

	public void setError(String error) {
		this.error = error;
	}
}
