package com.mx.dla.dda.contrato.fees.actions;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.fees.bos.FeesArchivoBO;
import com.mx.dla.dda.contrato.listado.dtos.ContentType;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.global.bos.CustomResourceLoader;
import com.mx.dla.global.dtos.FilaExcelDTO;

public class FeesArchivoAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private String request;
	private String msgError;
	private String msgExito;
	private String fileContentType;
	private String fileFileName;
	private File file;
	private InputStream fileInputStream;
	private List<FilaExcelDTO> datosExcel;

	@Autowired
	private FeesArchivoBO feesArchivoBO;

	@Autowired
	private CustomResourceLoader customResourceLoader;

	public String cargaArchivo() {
		try {
			logger.debug("Type [{}] name [{}]", fileContentType, fileFileName);
			UsuarioDTO usuario = (UsuarioDTO) getSession().get("usuario");
			datosExcel = feesArchivoBO.obtenerDatosExcel(file, fileFileName, usuario.getExpediente(),
					(Long) this.getSession().get("idContrato"));
			logger.debug("Se termina de cargar los datos de excel.");
		} catch (ExcelMapperException e) {
			logger.error("Error Al procesar Excel. {}", e);
			this.msgError = "Ocurri un error al cargar los datos.";
		} catch (IOException e) {
			logger.error("Error {}", e);
			this.msgError = "Ocurri un error al cargar los datos.";
		}
		return SUCCESS;
	}

	public String descargarTemplate() {
		try {
			logger.debug("llega descarga.");
			if (request != null) {
				String name = request.compareTo("s") == 0 ? "dda_plantillaFeesSuscrip" : "dda_plantillaFeesFlat";
				byte[] result = customResourceLoader.getFile2ByteArray("classpath:templateFees/" + name + ".xlsx");

				fileInputStream = new ByteArrayInputStream(result);

				HttpServletResponse response = ServletActionContext.getResponse();
				response.setContentLength(result.length);
				response.setContentType(ContentType.EXCEL.name());
				response.setHeader("Content-Disposition", "attachment;filename=" + name + ".xlsx");

				ServletOutputStream out = response.getOutputStream();

				out.write(result);
				out.flush();
				out.close();

			} else
				this.msgError = "Error al descargar template.";

		} catch (IOException ex) {
			this.msgError = "Error al descargar template.";
			logger.error("Error {}.", ex);
		} catch (InvalidFormatException ex) {
			this.msgError = "Error al descargar template.";
			logger.error("Error {}.", ex);
		}

		return null;
	}

	public String getFileContentType() {
		return fileContentType;
	}

	public String getFileFileName() {
		return fileFileName;
	}

	public File getFile() {
		return file;
	}

	public String getRequest() {
		return request;
	}

	public String getMsgError() {
		return msgError;
	}

	public List<FilaExcelDTO> getDatosExcel() {
		return datosExcel;
	}

	public String getMsgExito() {
		return msgExito;
	}

	public InputStream getFileInputStream() {
		return fileInputStream;
	}

	public void setFileContentType(String fileContentType) {
		this.fileContentType = fileContentType;
	}

	public void setFileFileName(String fileFileName) {
		this.fileFileName = fileFileName;
	}

	public void setRequest(String request) {
		this.request = request;
	}

	public void setMsgError(String msgError) {
		this.msgError = msgError;
	}

	public void setMsgExito(String msgExito) {
		this.msgExito = msgExito;
	}

	public void setFile(File file) {
		this.file = file;
	}

	public void setDatosExcel(List<FilaExcelDTO> datosExcel) {
		this.datosExcel = datosExcel;
	}

	public void setFileInputStream(InputStream fileInputStream) {
		this.fileInputStream = fileInputStream;
	}

}
