package com.mx.dla.dda.contrato.generales.actions;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

import com.dla.dda.domain.constants.OrigenCodes;
import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.contrato.amortizacion.constants.TipoAmortizacion;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.common.bos.JustificacionBO;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;
import com.mx.dla.dda.contrato.generales.bos.OpcionesContratoBO;
import com.mx.dla.dda.contrato.generales.bos.ValidacionGeneralesBO;
import com.mx.dla.dda.contrato.generales.dtos.BundleReturn;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.generales.enums.CatalogoTipo;
import com.mx.dla.dda.contrato.generales.enums.Estatus;
import com.mx.dla.dda.contrato.generales.enums.MensajeTexto;
import com.mx.dla.dda.contrato.generales.enums.TipoMensaje;
import com.mx.dla.dda.contrato.titulo.bos.TituloBO;
import com.mx.dla.dda.contrato.titulo.bos.TitulosBussinesBO;
import com.mx.dla.dda.contrato.titulo.dtos.Lista;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.contrato.ws.cargaTitulos.ResponseTitulosBroadViewDTO;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;

@Controller
@Scope("request")
public class OpcionesContratoAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private Long campoEstudio;
	private Long estatus;
	private Long tipoOperacion;
	private Long tipoContrato;
	private Date campoFechaInicio;
	private Date campoFechaFin;
	private Date campoFechaAutorizacion;
	private Date fechaInicioOrg; // para cuando la fecha inicio cuando la real ya esta oculta
	private Date fechaCancelacion;
	private Long idContrato;

	private List<Long> lbCategoriasSeleccionadas;
	private List<Long> lbServiciosSeleccionados;
	private List<Long> lbTerritoriosSeleccionados;
	private List<Long> lbAtributosSeleccionados;
	private List<Long> lbFilialesSeleccionados;
	private List<Long> lbTypesSeleccionados;

	private String justificacion;
	private Long campoAutorizan;
	private Long autorizacionPrincipal;
	private String expedienteUsuario;
	private Long areaUsuario;
	private boolean pintaBoton;

	private String campoContrato;
	private String campoOperacion;
	private Integer campoPeriodo;
	private String descripcionEstatus;
	private String annios;
	private String meses;

	private Integer tipoMensajeR;
	private String mensajesR;
	private Long apartado;
	private Long campoEstudioOficial;
	private boolean eliminaVirtual;
	private String tipoAmortizacion;

	private Integer numeroAreas;

	private String motivo;

	private Integer ordenWF;
	private Integer titContratados;

	private String indicador;

	@Autowired
	private GeneralesBO generalesBO;

	@Autowired
	private JustificacionBO justificacionBO;

	@Autowired
	private OpcionesContratoBO opcionesContratoBO;

	@Autowired
	private ValidacionGeneralesBO validacionGeneralesBO;

	@Autowired
	private TituloBO tituloBO;

	@Autowired
	private TitulosBussinesBO titulosBussinesBO;

	@Autowired
	private DLARestClientFactory dlaRestClientFactory;

	@Override
	public String execute() {
		return SUCCESS;
	}

	public String _regCon() throws TransaccionException {

		try {
			ContratoDTO contrato;

			contrato = generalesBO.registraContrato(campoEstudio, estatus, tipoOperacion, tipoContrato,
					campoFechaInicio, campoFechaFin, apartado, annios, meses, tipoAmortizacion, campoFechaAutorizacion,
					indicador);

			if (lbCategoriasSeleccionadas != null) {
				opcionesContratoBO.insertaComponentesContrato(contrato.getIdContrato(), lbCategoriasSeleccionadas,
						CatalogoTipo.CATEGORIA);
			}
			if (lbServiciosSeleccionados != null) {
				opcionesContratoBO.insertaComponentesContrato(contrato.getIdContrato(), lbServiciosSeleccionados,
						CatalogoTipo.SERVICIO);
			}
			if (lbTerritoriosSeleccionados != null) {
				opcionesContratoBO.insertaComponentesContrato(contrato.getIdContrato(), lbTerritoriosSeleccionados,
						CatalogoTipo.TERRITORIO);
			}

			if (lbAtributosSeleccionados != null) {
				opcionesContratoBO.insertaComponentesContrato(contrato.getIdContrato(), lbAtributosSeleccionados,
						CatalogoTipo.MEDIO);
			}

			if (lbFilialesSeleccionados != null) {
				opcionesContratoBO.insertaComponentesContrato(contrato.getIdContrato(), lbFilialesSeleccionados,
						CatalogoTipo.FILIAL);
			}

			if (lbTypesSeleccionados != null) {
				opcionesContratoBO.insertaComponentesContrato(contrato.getIdContrato(), lbTypesSeleccionados,
						CatalogoTipo.TYPE);
			}

			if (tipoContrato == 2 && titContratados != null) {
				logger.info("titContratados : [{}]", titContratados);
				opcionesContratoBO.insertaTotalTitulos(contrato.getIdContrato(), titContratados);
			}

			boolean seEnvio = validacionGeneralesBO.mandaCorreoNotificacionCreacionContrato(contrato.getIdContrato(),
					contrato.getNumeroContrato(), contrato.getIdEstudio(), contrato.getFechaInicio(),
					contrato.getFechaFin());

			logger.info("Se envo correo de notificacin de contrato [{}] : ", seEnvio);
			getSession().put("pmn", getPmn());
			getSession().put("idContrato", contrato.getIdContrato());

			setTipoMensajeR(TipoMensaje.EXITO.getValor());
			setMensajesR(MensajeTexto.CONTRATO_REGISTRADO.getTexto());

			logger.info("[{}]", MensajeTexto.CONTRATO_REGISTRADO.getTexto());

			generalesBO.registraContratoProceso(contrato.getIdContrato());

			if (tipoContrato == 2) {
				generalesBO.crearListaNuevaTransaccion(contrato.getIdContrato(), campoFechaInicio);
			} else {
				tituloBO.crearListaNueva(contrato.getIdContrato(), campoFechaInicio, Lista.REAL);
			}
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		return "irGenerales";
	}

	public void factualiza() throws TransaccionException {
		try {
			generalesBO.actualizaContrato(idContrato, campoEstudio, campoFechaInicio, campoFechaFin, apartado, annios,
					meses, campoFechaAutorizacion, indicador);

			if (lbCategoriasSeleccionadas != null) {
				opcionesContratoBO.eliminaComponentes(idContrato, CatalogoTipo.CATEGORIA);
				opcionesContratoBO.insertaComponentesContrato(idContrato, lbCategoriasSeleccionadas,
						CatalogoTipo.CATEGORIA);
			}

			if (lbServiciosSeleccionados != null) {
				opcionesContratoBO.eliminaComponentes(idContrato, CatalogoTipo.SERVICIO);
				opcionesContratoBO.insertaComponentesContrato(idContrato, lbServiciosSeleccionados,
						CatalogoTipo.SERVICIO);
			}

			if (lbTerritoriosSeleccionados != null) {
				opcionesContratoBO.eliminaComponentes(idContrato, CatalogoTipo.TERRITORIO);
				opcionesContratoBO.insertaComponentesContrato(idContrato, lbTerritoriosSeleccionados,
						CatalogoTipo.TERRITORIO);
			}

			if (lbAtributosSeleccionados != null) {
				opcionesContratoBO.eliminaComponentes(idContrato, CatalogoTipo.MEDIO);
				opcionesContratoBO.insertaComponentesContrato(idContrato, lbAtributosSeleccionados, CatalogoTipo.MEDIO);
			}

			if (lbFilialesSeleccionados != null) {
				opcionesContratoBO.eliminaComponentes(idContrato, CatalogoTipo.FILIAL);
				opcionesContratoBO.insertaComponentesContrato(idContrato, lbFilialesSeleccionados, CatalogoTipo.FILIAL);
			}

			if (lbTypesSeleccionados != null) {
				opcionesContratoBO.eliminaComponentes(idContrato, CatalogoTipo.TYPE);
				opcionesContratoBO.insertaComponentesContrato(idContrato, lbTypesSeleccionados, CatalogoTipo.TYPE);
			}

			if (justificacion != null) {
				UsuarioDTO usuario = (UsuarioDTO) getSession().get("usuario");
				justificacionBO.insertarJustificacion(justificacion, idContrato, usuario);
			}

			if (tipoContrato == 1) {
				if (tipoAmortizacion != null) {
					opcionesContratoBO.actualizaTipoAmortizacion(idContrato, TipoAmortizacion.EXCLUSIVIDAD.name());
				} else {
					opcionesContratoBO.actualizaTipoAmortizacion(idContrato, TipoAmortizacion.LINEAL.name());
					opcionesContratoBO.ponEnNullMesesPjeExclusivo(idContrato);
					logger.info("Se puso en null Meses y Pje exclusivos.");
				}
			}

			validacionGeneralesBO.esContratoSuscripcion(campoFechaInicio, idContrato);

			logger.info("tipoOperacion:" + tipoOperacion);

			// --- Se actualiza la fecha de la lista
			if (tipoContrato == 1 && tipoOperacion == 1) // --- Es Suscripcin y es contrato original
			{
				logger.info("se actualiza la fecha inicio de la lista:" + idContrato + "|" + campoFechaInicio);
				generalesBO.actualizaFechaInicioLista(idContrato, campoFechaInicio);
			}

			if (tipoContrato == 2 && titContratados != null) {

				if (opcionesContratoBO.validaTotalTitulos(idContrato)) {
					logger.info("Actualizar total de titulos");
					opcionesContratoBO.actualizaTotalTitulos(idContrato, titContratados);
				} else {
					logger.info("Insertar total de titulos");
					opcionesContratoBO.insertaTotalTitulos(idContrato, titContratados);
				}
			}
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		getSession().put("pmn", getPmn());
		getSession().put("idContrato", idContrato);
		logger.info("Termino Actualizacin.");
	}

	public String _actCon() throws TransaccionException {

		factualiza();
		titulosBussinesBO.procesoActualizacionTitulosEnmienda(idContrato);
		setTipoMensajeR(TipoMensaje.EXITO.getValor());
		setMensajesR(MensajeTexto.CONTRATO_ACTUALIZADO.getTexto());
		logger.info("[{}]", MensajeTexto.CONTRATO_ACTUALIZADO.getTexto());
		getSession().put("pmn", getPmn());
		getSession().put("idContrato", idContrato);
		return "irGenerales";
	}

	public String _finCon() throws TransaccionException {

		BundleReturn respuesta = null;

		logger.info("Antes de validaciones de Finalizar Registro:" + getIdContrato());
		try {
			respuesta = validacionGeneralesBO.validacionesParaFinalizarRegistro(getIdContrato(), tipoContrato,
					getCampoFechaInicio(), OrigenCodes.REAL.name(), expedienteUsuario);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SocketTimeoutException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (IOException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		logger.info("DESPUES ************* de validaciones de Finalizar Registro:" + getIdContrato());

		logger.info("Respuesta:" + respuesta);

		setTipoMensajeR(respuesta.getNumero());
		setMensajesR(respuesta.getCadena());

		getSession().put("pmn", getPmn());
		getSession().put("idContrato", idContrato);

		return "irGenerales";
	}

	public String _reiCon() throws TransaccionException {

		try {
			opcionesContratoBO.actulizaEstatus(Estatus.Registro.getValor(), idContrato, expedienteUsuario);
			opcionesContratoBO.eliminaComponentes(idContrato, CatalogoTipo.AREA);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		getSession().put("pmn", getPmn());
		getSession().put("idContrato", idContrato);
		setTipoMensajeR(TipoMensaje.EXITO.getValor());
		setMensajesR(MensajeTexto.CONTRATO_REINICIADO.getTexto());
		logger.info("[{}]", MensajeTexto.CONTRATO_REINICIADO.getTexto());

		return "irGenerales";
	}

	public String _suspende() throws TransaccionException {

		try {
			opcionesContratoBO.actulizaEstatus(Estatus.Suspendido.getValor(), idContrato, expedienteUsuario);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		getSession().put("pmn", getPmn());
		getSession().put("idContrato", idContrato);
		setTipoMensajeR(TipoMensaje.EXITO.getValor());
		setMensajesR(MensajeTexto.CONTRATO_SUSPENDIDO.getTexto());
		logger.info("[{}]", MensajeTexto.CONTRATO_SUSPENDIDO.getTexto());

		return "irGenerales";
	}

	public String _activa() throws TransaccionException {

		try {
			opcionesContratoBO.actulizaEstatus(Estatus.Vigente.getValor(), idContrato, expedienteUsuario);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		getSession().put("pmn", getPmn());
		getSession().put("idContrato", idContrato);
		setTipoMensajeR(TipoMensaje.EXITO.getValor());
		setMensajesR(MensajeTexto.CONTRATO_ACTIVADO.getTexto());
		logger.info("[{}]", MensajeTexto.CONTRATO_ACTIVADO.getTexto());

		return "irGenerales";
	}

	public String _cancela() throws TransaccionException {

		BundleReturn respuesta = null;
		try {
			respuesta = opcionesContratoBO.cancelarContrato(fechaCancelacion, idContrato, expedienteUsuario,
					tipoContrato);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		setTipoMensajeR(respuesta.getNumero());
		setMensajesR(respuesta.getCadena());
		logger.info("[{}]", respuesta.getCadena());

		getSession().put("pmn", getPmn());
		getSession().put("idContrato", idContrato);

		return "irGenerales";
	}

	public String _rechaza() throws TransaccionException {

		logger.info("en rechaza -> Motivo : [{}]", motivo);
		justificacionBO.insertarJustificacion(motivo, idContrato, (UsuarioDTO) getSession().get("usuario"));
		try {
			opcionesContratoBO.actulizaEstatus(Estatus.Rechazado.getValor(), idContrato, expedienteUsuario);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		getSession().put("pmn", getPmn());
		getSession().put("idContrato", idContrato);
		setTipoMensajeR(TipoMensaje.EXITO.getValor());
		setMensajesR(MensajeTexto.CONTRATO_RECHAZADO.getTexto());
		logger.info("[{}]", MensajeTexto.CONTRATO_RECHAZADO.getTexto());
		return "irGenerales";
	}

	public String _elimina() {

		getSession().put("pmn", getPmn());
		this.setPmn(this.getPmn());// Se establece el pmn para listado

		return "elimina";
	}

	public String _llamada() throws TransaccionException {// notificacion a sap

		try {
			BundleReturn respuesta = null;
			respuesta = validacionGeneralesBO.notificacionSAP(generalesBO.obtenContrato(idContrato), expedienteUsuario);
			setTipoMensajeR(respuesta.getNumero());
			setMensajesR(respuesta.getCadena());

			getSession().put("pmn", getPmn());
			getSession().put("idContrato", idContrato);
			if (respuesta.getNumero() == 1) {
				if (generalesBO.obtenContrato(idContrato).getIdTipoMovimiento() == 1) { // Contrato Original o Addendum
					DLARestClient c = dlaRestClientFactory.getClient(DLARestServices.CRN_EXHIBICION);
					try {
						c.getJson("?lista=[\"" + idContrato + "\"]", ResponseTitulosBroadViewDTO.class);
					} catch (Exception e) {
						logger.info("Error: {}", e);
						tituloBO.actualizaEstatusTitulo("ERROR DE CONEXION CON SERVICIO DDA", idContrato);
					}
				} else { // Enmienda
					DLARestClient c = dlaRestClientFactory.getClient(DLARestServices.CRN_CLIENTE_SAP);
					try {
						c.getJson("?lista=[\"" + idContrato + "\"]", ResponseTitulosBroadViewDTO.class);
					} catch (Exception e) {
						logger.info("Error: {}", e);
						tituloBO.actualizaEstatusTitulo("ERROR DE CONEXION CON SERVICIO DDA", idContrato);
					}
				}
			} else {
				tituloBO.actualizaEstatusTitulo("ERROR LA DAR DE ALTA LA ORDEN DE COMPRA", idContrato);
			}
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		return "irGenerales";
	}

	public String _modEstudio() throws TransaccionException {

		try {
			generalesBO.cambiaEstudioVirtualContrato(idContrato, campoEstudioOficial, campoEstudio, eliminaVirtual);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		setTipoMensajeR(TipoMensaje.EXITO.getValor());
		setMensajesR(MensajeTexto.ESTUDIO_MODIFICADO.getTexto());
		logger.info("[{}]", MensajeTexto.ESTUDIO_MODIFICADO.getTexto());

		getSession().put("pmn", getPmn());
		getSession().put("idContrato", idContrato);

		return "irGenerales";
	}

	public String _autoriza() throws TransaccionException {

		BundleReturn respuesta = null;

		if (campoAutorizan != null) {

			logger.info("campoAutorizan : [{}]", getCampoAutorizan());
			logger.info("expedienteUsuario : [{}]", getExpedienteUsuario());
			logger.info("numeroAreas : [{}]", getNumeroAreas());

			try {
				respuesta = validacionGeneralesBO.validaWorkFlow(idContrato, expedienteUsuario,
						campoAutorizan.intValue(), numeroAreas, fechaInicioOrg, generalesBO.obtenerFechaSAP(),
						tipoContrato);
			} catch (ResultMapException e) {
				logger.error("Error. {}", e);
				throw new TransaccionException("Ocurrio un error", e);
			} catch (PersistenceException e) {
				logger.error("Error. {}", e);
				throw new TransaccionException("Ocurrio un error", e);
			} catch (TransaccionException e) {
				logger.error("Error. {}", e);
				throw new TransaccionException("Ocurrio un error", e);
			} catch (SQLException e) {
				logger.error("Error. {}", e);
				throw new TransaccionException("Ocurrio un error", e);
			}

			setTipoMensajeR(respuesta.getNumero());
			setMensajesR(respuesta.getCadena());

		}

		getSession().put("pmn", getPmn());
		getSession().put("idContrato", idContrato);

		return "irGenerales";
	}

	public String _noAutoriza() {
		BundleReturn respuesta = null;
		logger.info("Se rechazo la autorizacin - Motivo : [{}], idContrato : [{}]", motivo, idContrato);
		logger.info("ordenWF : [{}]", ordenWF);
		UsuarioDTO usuario = (UsuarioDTO) getSession().get("usuario");
		respuesta = validacionGeneralesBO.noAceptarAutorizacion(idContrato, motivo, ordenWF, usuario);

		setTipoMensajeR(respuesta.getNumero());
		setMensajesR(respuesta.getCadena());
		return "irGenerales";
	}

	public String _completaWorkflow() throws TransaccionException {
		UsuarioDTO usuario = (UsuarioDTO) getSession().get("usuario");
		try {
			opcionesContratoBO.actualizaEstadosBypassWorkflow(idContrato, usuario.getExpediente());
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		return "irGenerales";
	}

	public Long getCampoEstudio() {
		return campoEstudio;
	}

	public void setCampoEstudio(Long campoEstudio) {
		this.campoEstudio = campoEstudio;
	}

	public Long getEstatus() {
		return estatus;
	}

	public void setEstatus(Long estatus) {
		this.estatus = estatus;
	}

	public Long getTipoOperacion() {
		return tipoOperacion;
	}

	public void setTipoOperacion(Long tipoOperacion) {
		this.tipoOperacion = tipoOperacion;
	}

	public Long getTipoContrato() {
		return tipoContrato;
	}

	public void setTipoContrato(Long tipoContrato) {
		this.tipoContrato = tipoContrato;
	}

	public Date getCampoFechaInicio() {
		return campoFechaInicio;
	}

	public void setCampoFechaInicio(Date campoFechaInicio) {
		this.campoFechaInicio = campoFechaInicio;
	}

	public Date getCampoFechaFin() {
		return campoFechaFin;
	}

	public void setCampoFechaFin(Date campoFechaFin) {
		this.campoFechaFin = campoFechaFin;
	}

	public List<Long> getLbCategoriasSeleccionadas() {
		return lbCategoriasSeleccionadas;
	}

	public void setLbCategoriasSeleccionadas(List<Long> lbCategoriasSeleccionadas) {
		this.lbCategoriasSeleccionadas = lbCategoriasSeleccionadas;
	}

	public List<Long> getLbServiciosSeleccionados() {
		return lbServiciosSeleccionados;
	}

	public void setLbServiciosSeleccionados(List<Long> lbServiciosSeleccionados) {
		this.lbServiciosSeleccionados = lbServiciosSeleccionados;
	}

	public List<Long> getLbTerritoriosSeleccionados() {
		return lbTerritoriosSeleccionados;
	}

	public void setLbTerritoriosSeleccionados(List<Long> lbTerritoriosSeleccionados) {
		this.lbTerritoriosSeleccionados = lbTerritoriosSeleccionados;
	}

	public List<Long> getLbAtributosSeleccionados() {
		return lbAtributosSeleccionados;
	}

	public void setLbAtributosSeleccionados(List<Long> lbAtributosSeleccionados) {
		this.lbAtributosSeleccionados = lbAtributosSeleccionados;
	}

	public void setCampoFechaAutorizacion(Date campoFechaAutorizacion) {
		this.campoFechaAutorizacion = campoFechaAutorizacion;
	}

	public Date getCampoFechaAutorizacion() {
		return campoFechaAutorizacion;
	}

	public void setFechaCancelacion(Date fechaCancelacion) {
		this.fechaCancelacion = fechaCancelacion;
	}

	public Date getFechaCancelacion() {
		return fechaCancelacion;
	}

	public Long getIdContrato() {
		return idContrato;
	}

	public void setIdContrato(Long idContrato) {
		this.idContrato = idContrato;
	}

	public String getCampoContrato() {
		return campoContrato;
	}

	public void setCampoContrato(String campoContrato) {
		this.campoContrato = campoContrato;
	}

	public String getJustificacion() {
		return justificacion;
	}

	public void setJustificacion(String justificacion) {
		this.justificacion = justificacion;
	}

	public Long getCampoAutorizan() {
		return campoAutorizan;
	}

	public void setCampoAutorizan(Long campoAutorizan) {
		this.campoAutorizan = campoAutorizan;
	}

	public Long getAutorizacionPrincipal() {
		return autorizacionPrincipal;
	}

	public void setAutorizacionPrincipal(Long autorizacionPrincipal) {
		this.autorizacionPrincipal = autorizacionPrincipal;
	}

	public String getExpedienteUsuario() {
		return expedienteUsuario;
	}

	public void setExpedienteUsuario(String expedienteUsuario) {
		this.expedienteUsuario = expedienteUsuario;
	}

	public GeneralesBO getGeneralesBO() {
		return generalesBO;
	}

	public void setGeneralesBO(GeneralesBO generalesBO) {
		this.generalesBO = generalesBO;
	}

	public JustificacionBO getJustificacionBO() {
		return justificacionBO;
	}

	public void setJustificacionBO(JustificacionBO justificacionBO) {
		this.justificacionBO = justificacionBO;
	}

	public Long getAreaUsuario() {
		return areaUsuario;
	}

	public void setAreaUsuario(Long areaUsuario) {
		this.areaUsuario = areaUsuario;
	}

	public boolean isPintaBoton() {
		return pintaBoton;
	}

	public void setPintaBoton(boolean pintaBoton) {
		this.pintaBoton = pintaBoton;
	}

	public String getCampoOperacion() {
		return campoOperacion;
	}

	public void setCampoOperacion(String campoOperacion) {
		this.campoOperacion = campoOperacion;
	}

	public Integer getCampoPeriodo() {
		return campoPeriodo;
	}

	public void setCampoPeriodo(Integer campoPeriodo) {
		this.campoPeriodo = campoPeriodo;
	}

	public String getDescripcionEstatus() {
		return descripcionEstatus;
	}

	public void setDescripcionEstatus(String descripcionEstatus) {
		this.descripcionEstatus = descripcionEstatus;
	}

	public void setTipoMensajeR(Integer tipoMensajeR) {
		this.tipoMensajeR = tipoMensajeR;
	}

	public Integer getTipoMensajeR() {
		return tipoMensajeR;
	}

	public void setMensajesR(String mensajesR) {
		this.mensajesR = mensajesR;
	}

	public String getMensajesR() {
		return mensajesR;
	}

	public Long getApartado() {
		return apartado;
	}

	public void setApartado(Long apartado) {
		this.apartado = apartado;
	}

	public String getAnnios() {
		return annios;
	}

	public void setAnnios(String annios) {
		this.annios = annios;
	}

	public String getMeses() {
		return meses;
	}

	public void setMeses(String meses) {
		this.meses = meses;
	}

	public Long getCampoEstudioOficial() {
		return campoEstudioOficial;
	}

	public void setCampoEstudioOficial(Long campoEstudioOficial) {
		this.campoEstudioOficial = campoEstudioOficial;
	}

	public boolean getEliminaVirtual() {
		return eliminaVirtual;
	}

	public void setEliminaVirtual(boolean eliminaVirtual) {
		this.eliminaVirtual = eliminaVirtual;
	}

	public void setLbFilialesSeleccionados(List<Long> lbFilialesSeleccionados) {
		this.lbFilialesSeleccionados = lbFilialesSeleccionados;
	}

	public List<Long> getLbFilialesSeleccionados() {
		return lbFilialesSeleccionados;
	}

	public void setLbTypesSeleccionados(List<Long> lbTypesSeleccionados) {
		this.lbTypesSeleccionados = lbTypesSeleccionados;
	}

	public List<Long> getLbTypesSeleccionados() {
		return lbTypesSeleccionados;
	}

	public void setTipoAmortizacion(String tipoAmortizacion) {
		this.tipoAmortizacion = tipoAmortizacion;
	}

	public String getTipoAmortizacion() {
		return tipoAmortizacion;
	}

	public void setNumeroAreas(Integer numeroAreas) {
		this.numeroAreas = numeroAreas;
	}

	public Integer getNumeroAreas() {
		return numeroAreas;
	}

	public void setFechaInicioOrg(Date fechaInicioOrg) {
		this.fechaInicioOrg = fechaInicioOrg;
	}

	public Date getFechaInicioOrg() {
		return fechaInicioOrg;
	}

	public void setMotivo(String motivo) {
		this.motivo = motivo;
	}

	public String getMotivo() {
		return motivo;
	}

	public void setOrdenWF(Integer ordenWF) {
		this.ordenWF = ordenWF;
	}

	public Integer getOrdenWF() {
		return ordenWF;
	}

	public void setIndicador(String indicador) {
		this.indicador = indicador;
	}

	public String getIndicador() {
		return indicador;
	}

	public Integer getTitContratados() {
		return titContratados;
	}

	public void setTitContratados(Integer titContratados) {
		this.titContratados = titContratados;
	}

}
