package com.mx.dla.dda.reporte.acumulateBuys.actions;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;

import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.reporte.acumulateBuys.bos.ReporteAcumulateBuysBO;
import com.mx.dla.dda.reporte.acumulateBuys.dto.acumulateBuysEstudiosDTO;
import com.mx.dla.dda.reporte.general.dtos.CeldaBaseDTO;

public class ReporteAcumulateBuysAction extends BaseContratoAction {

	private static final long serialVersionUID = -6159275023094659946L;

	private List<acumulateBuysEstudiosDTO> estudios;
	private List<LinkedHashMap<String, String>> repporteacumulatebuys;
	private ArrayList<CeldaBaseDTO> header;
	private String fileFileName;
	private Long id_estudio;
	private String origen;
	private String typeAbono;
	private String fechaInicio;
	private String fechaFin;

	private InputStream fileInputStream;

	@Autowired
	private ReporteAcumulateBuysBO reporteacumulatebuyBO;

	@Override
	public String execute() {

		return SUCCESS;
	}

	public String reporteAcumulateBuys() throws TransaccionException {

		try {
			header = reporteacumulatebuyBO.obtenerHeader(fechaInicio, fechaFin, id_estudio);

			repporteacumulatebuys = reporteacumulatebuyBO.reporteAcumulateBuys(origen, id_estudio, typeAbono,
					fechaInicio, fechaFin);
		} catch (ParseException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (IllegalArgumentException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (IllegalAccessException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (Exception e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		return SUCCESS;

	}

	public String generaExcelAcumulateBuys() {

		UsuarioDTO usuario = (UsuarioDTO) getSession().get("usuario");

		java.util.Date date = new Date();

		SimpleDateFormat formatoMes = new SimpleDateFormat("MM");
		Long mes = Long.parseLong(formatoMes.format(date));

		SimpleDateFormat formatoAnio = new SimpleDateFormat("yyyy");
		Long annio = Long.parseLong(formatoAnio.format(date));

		fileFileName = usuario.getExpediente() + "-" + mes + annio + "-acumulateBuys";

		try {
			fileInputStream = reporteacumulatebuyBO.generaExcelAcumumlateBuys(fileFileName, origen, id_estudio,
					typeAbono, fechaInicio, fechaFin);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (IllegalArgumentException e) {
			logger.error("Error. {}", e);
		} catch (IllegalAccessException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		} catch (ParseException e) {
			logger.error("Error. {}", e);
		} catch (IOException e) {
			logger.error("Error. {}", e);
		}

		return SUCCESS;
	}

	public String obtenEstudios() {

		try {
			estudios = reporteacumulatebuyBO.obtenEstudios();
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		}

		return SUCCESS;

	}

	public String obtenEstudiosConfigurados() {

		UsuarioDTO usuario = (UsuarioDTO) getSession().get("usuario");
		fileFileName = usuario.getExpediente();

		try {
			estudios = reporteacumulatebuyBO.obtenEstudiosConfig(fileFileName);
		} catch (ResultMapException e) {
			logger.error("ERROR : ReporteAcumulateBuysAction-obtenEstudiosConfigurados [{}]" + e);
		} catch (SQLException e) {
			logger.error("ERROR : ReporteAcumulateBuysAction-obtenEstudiosConfigurados [{}]" + e);
		} catch (TransaccionException e) {
			logger.error("ERROR : ReporteAcumulateBuysAction-obtenEstudiosConfigurados [{}]" + e);
		}

		return SUCCESS;

	}

	public String getOrigen() {
		return origen;
	}

	public void setOrigen(String origen) {
		this.origen = origen;
	}

	public InputStream getFileInputStream() {
		return fileInputStream;
	}

	public void setFileInputStream(InputStream fileInputStream) {
		this.fileInputStream = fileInputStream;
	}

	public List<acumulateBuysEstudiosDTO> getEstudios() {
		return estudios;
	}

	public void setEstudios(List<acumulateBuysEstudiosDTO> estudios) {
		this.estudios = estudios;
	}

	public String getFileFileName() {
		return fileFileName;
	}

	public void setFileFileName(String fileFileName) {
		this.fileFileName = fileFileName;
	}

	public Long getId_estudio() {
		return id_estudio;
	}

	public void setId_estudio(Long id_estudio) {
		this.id_estudio = id_estudio;
	}

	public String getTypeAbono() {
		return typeAbono;
	}

	public void setTypeAbono(String typeAbono) {
		this.typeAbono = typeAbono;
	}

	public List<LinkedHashMap<String, String>> getRepporteacumulatebuys() {
		return repporteacumulatebuys;
	}

	public void setRepporteacumulatebuys(List<LinkedHashMap<String, String>> repporteacumulatebuys) {
		this.repporteacumulatebuys = repporteacumulatebuys;
	}

	public String getFechaInicio() {
		return fechaInicio;
	}

	public void setFechaInicio(String fechaInicio) {
		this.fechaInicio = fechaInicio;
	}

	public String getFechaFin() {
		return fechaFin;
	}

	public void setFechaFin(String fechaFin) {
		this.fechaFin = fechaFin;
	}

	public ArrayList<CeldaBaseDTO> getHeader() {
		return header;
	}

	public void setHeader(ArrayList<CeldaBaseDTO> header) {
		this.header = header;
	}

}
