package com.mx.dla.dda.reporte.datosContrato.actions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.List;

import org.apache.ibatis.executor.result.ResultMapException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.catalogos.bos.CatalogosBO;
import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.dda.reporte.DatosContrato.bos.ReporteDatosContratosBO;
import com.mx.dla.dda.reporte.cpview.dtos.ReporteCostPerViewVistaDTO;
import com.mx.dla.dda.reporte.cpview.dtos.VisualizacionesCostPerViewVistaDTO;
import com.mx.dla.dda.reporte.cpview.exception.ReportCostPerViewException;

public class ReporteDatosContratoAction extends BaseContratoAction {

    private static final long serialVersionUID = -8363640992586901052L;
    private String fecha;
    private ReporteCostPerViewVistaDTO reporteVista;
    private VisualizacionesCostPerViewVistaDTO visualizacionesVista;
    private InputStream fileInputStream;
    private String fileName;
    private String tipoReporte;
    private File file;
    private String fileFileName;
    private String errorMensaje;
    private Long idEstudio;
    private Long contrato;
    private Long nombreUnico;
    private Long temporada;
    private List<CatalogoDTO> estudios;
    private List<CatalogoDTO> contratos;
    private List<CatalogoDTO> peliculas_series;
    private List<CatalogoDTO> temporadas;
    
    /** RFD **/
    private String titulos;
    private String amortizacion;
    private String dgenerales;
    private String tcomerciales;

    @Autowired
    private ReporteDatosContratosBO reporteDatosContratosBO;

    @Autowired
    private CatalogosBO catalogosBO;

    public String execute() {
        return SUCCESS;
    }

    public String obtenerDatosReporte() {
        try {
            logger.info("fecha: {}", fecha, idEstudio);
            logger.info("nombreUnico", nombreUnico);
            logger.info("temporada", temporada);
            logger.info("contrato",contrato);
            logger.info("titulos", titulos);
            logger.info("amortizacion", amortizacion);
            logger.info("dgenerales", dgenerales);
            logger.info("tcomerciales", tcomerciales);
            reporteVista = reporteDatosContratosBO.obtenerReporteMensualVista(fecha, idEstudio, contrato, nombreUnico,temporada, true, titulos,amortizacion,dgenerales,tcomerciales);
            logger.info("getTabla: {}", reporteVista.getTabla());
            logger.info("getPheader: {}", reporteVista.getPheader());
            logger.info("getRheader: {}", reporteVista.getRheader());
        } catch (ParseException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalAccessException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
        return SUCCESS;
    }

    public String obtenerDatosReporteAnual() {
        try {
            logger.info("fecha: {} idEstudio: {}", fecha, idEstudio);
            logger.info("nombreUnico", nombreUnico);
            logger.info("temporada", temporada);
            reporteVista = reporteDatosContratosBO.obtenerReporteAnualVista(fecha, idEstudio, nombreUnico,temporada, true);
            logger.info("getTabla: {}", reporteVista.getTabla());
            logger.info("getPheader: {}", reporteVista.getPheader());
            logger.info("getRheader: {}", reporteVista.getRheader());
        } catch (ParseException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalAccessException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
        return SUCCESS;
    }

    public String exportarReporte() {
        try {
            logger.info("{} {}", tipoReporte, fecha);
            logger.info("{}", idEstudio);
            fileInputStream = reporteDatosContratosBO.obtenerStreamReporte(tipoReporte, fecha, idEstudio,contrato, nombreUnico,temporada,titulos,amortizacion,dgenerales,tcomerciales);
        } catch (ParseException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalAccessException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (ExcelMapperException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IOException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (ReportCostPerViewException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
        return SUCCESS;
    }

    public String procesarArchivoVisualizacionesCarga() {
        logger.info("{} {}", file, fileFileName);
        logger.info("{}", fileName);
        UsuarioDTO usuario = (UsuarioDTO) getSession().get("usuario");
        try {
            logger.info("{}", usuario);
            reporteDatosContratosBO.procesarStreamArchivoCarga(file, fileFileName, fecha, usuario.getExpediente());
        } catch (ParseException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IOException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (ReportCostPerViewException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
        return SUCCESS;
    }

    public String obtenerDatosCargaVisualizacionesMensual() {
        try {
            logger.info("fecha: {}", fecha);
            visualizacionesVista = reporteDatosContratosBO.obtenerCargaVisualizacionesMensualVista(fecha);
            logger.info("getTabla: {}", visualizacionesVista.getTabla());
            logger.info("getCorrectos: {}, getErroneos: {}", visualizacionesVista.getCorrectos(), visualizacionesVista.getErroneos());
            logger.info("getLeidos: {}", visualizacionesVista.getLeidos());
        } catch (ParseException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalAccessException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (ReportCostPerViewException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
        return SUCCESS;
    }

    public String obtenerDatosCargaVisualizacionesPrincipal() {
        try {
            logger.info("fecha: {}", fecha);
            visualizacionesVista = reporteDatosContratosBO.obtenCargaVisualizacionesPrincipalTabla(fecha);
            logger.info("getTabla: {}", visualizacionesVista.getTabla());
            logger.info("getCorrectos: {}, getErroneos: {}", visualizacionesVista.getCorrectos(), visualizacionesVista.getErroneos());
            logger.info("getLeidos: {}", visualizacionesVista.getLeidos());
        } catch (ParseException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalAccessException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (ReportCostPerViewException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
        return SUCCESS;
    }

    public String descargarVisualizaciones() {
        try {
            logger.info("{} {}", tipoReporte, fecha);
            fileInputStream = reporteDatosContratosBO.obtenerStreamVisualizaciones(fecha);
        } catch (ParseException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalAccessException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (ExcelMapperException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IOException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
        return SUCCESS;
    }

    public String descargarPlantilla() {
        try {
            logger.info("{} {}", tipoReporte, fecha);
            fileInputStream = reporteDatosContratosBO.obtenerStreamPlantilla();
        } catch (ParseException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalAccessException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (InvalidFormatException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (ExcelMapperException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IOException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
        return SUCCESS;
    }

    public String inicializaCatalogos() {
        try {
            logger.info("{}", getEstudios());
            setEstudios(catalogosBO.obtenCatalogoEstudios(null, null, null, null, null, null, null, null, null, null));
        } catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (ResultMapException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (TransaccionException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
        return SUCCESS;
    }

    public String exportarZip() {
        try {
            logger.info("{} {}", tipoReporte, fecha);
            logger.info("{}", idEstudio);
            fileInputStream = reporteDatosContratosBO.obtenerStreamZipReporte(tipoReporte, fecha);
        } catch (ParseException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (InvalidFormatException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IOException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
        return SUCCESS;
    }
    
    
    public String obtenerContratos(){
    	try {
               logger.info("{}", getEstudios());
               setContratos(catalogosBO.obtenContratos(idEstudio));
        } catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (ResultMapException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (TransaccionException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
      	return SUCCESS;
    }
    
    public String obtenerSeriesyPeliculas(){
    	 try {
             logger.info("{}", getContrato());
             setPeliculas_series(catalogosBO.obtenCatalogoPeliculasSeriesDC(contrato));
         } catch (IllegalArgumentException e) {
 			errorMensaje = e.getMessage();
 			logger.error("Error. {}", e);
 		} catch (ResultMapException e) {
 			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (TransaccionException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
    	return SUCCESS;
    }
        
    public String obtenerTemporada(){
   	 try {
            logger.info("{}", getEstudios());
            setTemporadas(catalogosBO.obtenCatalogoTemporadasDC(idEstudio,nombreUnico));
        }  catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (ResultMapException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (TransaccionException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
   	return "TEMPORADAS";
   }

    public String getFecha() {
        return fecha;
    }

    public void setFecha(String fecha) {
        this.fecha = fecha;
    }

    public InputStream getFileInputStream() {
        return fileInputStream;
    }

    public void setFileInputStream(InputStream fileInputStream) {
        this.fileInputStream = fileInputStream;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getTipoReporte() {
        return tipoReporte;
    }

    public void setTipoReporte(String tipoReporte) {
        this.tipoReporte = tipoReporte;
    }

    public ReporteCostPerViewVistaDTO getReporteVista() {
        return reporteVista;
    }

    public void setReporteVista(ReporteCostPerViewVistaDTO reporteVista) {
        this.reporteVista = reporteVista;
    }

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getFileFileName() {
        return fileFileName;
    }

    public void setFileFileName(String fileFileName) {
        this.fileFileName = fileFileName;
    }

    public VisualizacionesCostPerViewVistaDTO getVisualizacionesVista() {
        return visualizacionesVista;
    }

    public void setVisualizacionesVista(VisualizacionesCostPerViewVistaDTO visualizacionesVista) {
        this.visualizacionesVista = visualizacionesVista;
    }

    public String getErrorMensaje() {
        return errorMensaje;
    }

    public void setErrorMensaje(String errorMensaje) {
        this.errorMensaje = errorMensaje;
    }

    public Long getIdEstudio() {
        return idEstudio;
    }

    public void setIdEstudio(Long idEstudio) {
        this.idEstudio = idEstudio;
    }

    public List<CatalogoDTO> getEstudios() {
        return estudios;
    }

    public void setEstudios(List<CatalogoDTO> estudios) {
        this.estudios = estudios;
    }

public List<CatalogoDTO> getPeliculas_series() {
		return peliculas_series;
	}

	public void setPeliculas_series(List<CatalogoDTO> peliculas_series) {
		this.peliculas_series = peliculas_series;
	}

	public List<CatalogoDTO> getTemporadas() {
		return temporadas;
	}

	public void setTemporadas(List<CatalogoDTO> temporadas) {
		this.temporadas = temporadas;
	}

	public Long getNombreUnico() {
		return nombreUnico;
	}

	public void setNombreUnico(Long nombreUnico) {
		this.nombreUnico = nombreUnico;
	}

	public Long getTemporada() {
		return temporada;
	}

	public void setTemporada(Long temporada) {
		this.temporada = temporada;
	}

	public List<CatalogoDTO> getContratos() {
		return contratos;
	}

	public void setContratos(List<CatalogoDTO> contratos) {
		this.contratos = contratos;
	}

	public Long getContrato() {
		return contrato;
	}

	public void setContrato(Long contrato) {
		this.contrato = contrato;
	}

	public String getTitulos() {
		return titulos;
	}

	public void setTitulos(String titulos) {
		this.titulos = titulos;
	}

	public String getAmortizacion() {
		return amortizacion;
	}

	public void setAmortizacion(String amortizacion) {
		this.amortizacion = amortizacion;
	}

	public String getDgenerales() {
		return dgenerales;
	}

	public void setDgenerales(String dgenerales) {
		this.dgenerales = dgenerales;
	}

	public String getTcomerciales() {
		return tcomerciales;
	}

	public void setTcomerciales(String tcomerciales) {
		this.tcomerciales = tcomerciales;
	}

	

}