package com.mx.dla.dda.reporte.movimientos.actions;

import java.io.InputStream;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.reporte.movimientos.bos.ReporteMovimientosBO;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public class ReporteMovimientosExcelAction extends BaseContratoAction {
	
	private static final long serialVersionUID = 1L;
	private InputStream fileInputStream;
	private String fileName;
	private String contrato;
	private String estudio;
	private String mes;
	
	@Autowired
	private ReporteMovimientosBO reporteMovimientos;
	
	public String execute() {
		if (mes.isEmpty()){
			mes = null;
		} else{
			mes = mes.substring(0,3) + mes.substring(6);
		}
		if(contrato.isEmpty()){
			contrato = null;
		}
		fileInputStream = reporteMovimientos.obtenerReporteEnExcel(contrato, estudio, mes);
		setFileName( contrato != null ? estudio + "_" + contrato : estudio + "");
		return SUCCESS;
	}

}
