var idEstudio;

$(document).ready(
	function() {
		inicial();
	}
);

function inicial(){
	limpiarTabla();
	realizaConsulta();
	inicializarBotones();
	$("table thead tr").addClass("encabezado");
}

function limpiarTabla(){	
	$('#divTablaIn').remove();
	var div = '<div id="divTablaIn"></div>';
	$('#divTablaExt').append(div);
	var tabla = $("<table class='table table-striped'/>").attr('id',"cataEstudio");       
	$("#divTablaIn").append(tabla);	
}

function realizaConsulta(){				
	// Obtener numero de menu
	var menu        = $("#pmn").val();
	var menuRegreso = $("#pmnReturn").val();
	var namespace = "/catalogos/estudios/";
    var rowId=null;
    var oTable=null;
	oTable = $('#cataEstudio').DataTable({
	    "autoWidth": false,
	    "language": {
	        "processing": "Procesando...",
	        "lengthMenu": "Mostrar _MENU_ registros",
	        "zeroRecords": "Sin eventos encontrados",
	        "emptyTable": "Sin eventos encontrados",
	        "info": "Mostrando _START_ al _END_ de _TOTAL_",
	        "infoEmpty": "0 registros",
	        "infoFiltered": "(filtrado de un total de _MAX_ registros)",
	        "search": "Buscar:",
	        "thousands": ",",
	        "loadingRecords": "Cargando...",
	        "paginate": {
	            "first": "Primero",
	            "last": "&Uacute;ltimo",
	            "next": "Siguiente",
	            "previous": "Anterior"
	        }
	    },
	    "pageLength": 10,
	    "info": false,
	    "filter": true,
	    "ordering": false,
	    "paging": true,
	    "pagingType": "full_numbers",
	    "order": [],
	    "ajax": {
	        "url": "listadoEstudios",
	        "dataSrc": ""
	    },
	    "columns": [
	        {"title": "C&oacute;digo SAP", "data": "idSap", "searchable": true, "width": "40px"},
	        {"title": "Nombre", "data": "descripcionEstudio", "searchable": true, "width": "50px"},
	        {"title": "Siglas", "data": "siglaDda", "searchable": true, "width": "40px"},
	        {"title": "Grupo", "data": "descripcionGrupo", "searchable": true, "width": "50px"},
	        {"title": "Moneda", "data": "moneda", "searchable": true, "width": "40px"},
	        {"title": "C\u00F3digo Pa\u00EDs", "data": "codigoPais", "searchable": true, "width": "40px"},
	        {"title": "Nombre Pa\u00EDs", "data": "nombrePais", "searchable": true, "width": "40px"},
	        {"title": "Sociedad", "data": "sociedad", "searchable": true, "width": "40px"}
	    ],
	    "rowCallback": function(row, data, index) {
	        var link = '<a onClick="guardaIdEstudio(' + data["idEstudio"] + ')" data-bs-toggle="modal" data-bs-target="#modalAgregaActualiza">' + data["descripcionEstudio"] + '</a>';
	        $(row).attr("id", data["idEstudio"]);
	        $('td:eq(0)', row).html(data["idSap"]);
	        $('td:eq(1)', row).html(link);
	        $('td:eq(2)', row).html(data["siglaDda"]);
	        $('td:eq(3)', row).html(data["descripcionGrupo"]);
	        $('td:eq(4)', row).html(data["moneda"]);
	        $('td:eq(5)', row).html(data["codigoPais"]);
	        $('td:eq(6)', row).html(data["nombrePais"]);
	        $('td:eq(7)', row).html(data["sociedad"]);
	    }
	});
     
}

function validarAgregar(){
	
	$("#forma").validate(
		      {
		        rules: 
		        {
		        	nombreEstudio: 
		          {
		            required: true,
		            maxlength: 50,
		            regex:"^[a-zA-Z0-9 ]+$"
		          }
		        },
		        messages: 
		        {
		        	nombreEstudio: 
		          {
		            required: "Nombre del Estudio es obligatorio.",
		            maxlength: "Nombre no debe exceder 50 caracteres",
		            regex: "Nombre debe ser con caracteres alfanum\u00E9ricos"
		          }
		        }
	});
	
	$.validator.addMethod("regex",function(value,element,regexp){
	      var re= new RegExp(regexp);
	      return this.optional(element) || re.test(value);
	},"Only Characters from A-z");
}

function inicializarBotones(){
	$("#nuevo").click(function()  
	{		
		window.location.href = contextPath + "/catalogos/estudios/dirigirAgregarEstudio.action?pmn=42&pmnReturn=42";				
	});
}

function regreso(){	
	var menu = $("#pmn").val();
	if(menu == '' || menu == null || menu == undefined)
		menu = 42;
	window.location.href = contextPath + "/catalogos/estudios/index.action?pmn=" + menu;
}

function guardaIdEstudio(idEstud) {	
	idEstudio = idEstud;
	llamaObtenEstudio(idEstud);
}

function llamaObtenEstudio(idEstudio) {
	var jsonString = '{"idEstudio" : "'+ idEstudio +'"}';
	var stringJson = JSON.parse(jsonString);
	callActionAjax( "/catalogos/estudios/llamaObtenEstudio", stringJson, procesaRespuestaObtenEstudio);
}

function procesaRespuestaObtenEstudio(jsonData) {
	var est = jsonData.estudio;
	var grups = jsonData.grupos;
	var grup;
	//debugger
	$('#inpNombreEstudio').val(est.descripcionEstudio);
	$('#inpMoneda')       .val(est.moneda);
	$('#inpNombrePais')   .val(est.nombrePais);
	$('#inpCodigoPais')   .val(est.codigoPais);
	$('#inpSociedad')     .val(est.sociedad);
	$('#inpIdSap')        .val(est.idSap);
	$('#inpSiglaDDA')     .val(est.siglaDda);
	
	$('#inpNombreAddon').val(est.addOn);
	
	var cb = document.querySelector('#checkAddOn');
	est.esAddOn == "1" ? cb.checked=true : cb.checked=false;
	
	$('#campoGrupo').children().remove();
	
	var option;
	for(var i = 0; i < grups.length; i++){
		grup = grups[i];
					
		if(est.idGrupo == grup.idGrupo) {
			$('#campoGrupo').append('<option value="'+ grup.idGrupo +'" selected> '+ grup.descripcionGrupo +' </option>');
		}else {
			$('#campoGrupo').append('<option value="'+ grup.idGrupo +'"> '+ grup.descripcionGrupo +' </option>');
		}						
	}
	
	if(est.idSap == '' || est.idSap == null || est.idSap == undefined){
		$("#inpSiglaDDA").prop( "disabled", true );
		$("#campoGrupo") .prop( "disabled", true );
	}	
	else
	{
		$("#inpSiglaDDA").prop( "disabled", false);
		$("#campoGrupo") .prop( "disabled", false);
	}
	if(est.tieneContratos == true)
	{
		$("#inpSiglaDDA").prop( "disabled", true );		
	}
}

function llamaActualizaEstudio() {
	var esAddOnVal = 0;
	
	if(checkAddOn.checked){
		esAddOnVal = 1;
	}
	
	var sigla = $('#inpSiglaDDA').val();
	var jsonString = '{"idEstudio" : "'+ idEstudio + '", "sigla" : "' + sigla + '", "campoGrupo" : "' + $('#campoGrupo').val() + '", "esAddOn" : "' + esAddOnVal+ '", "nombreAddOn" : "' + $('#inpNombreAddon').val()  +'"}';	
	var patron = /^[A-z\d_]{2,3}$/;
	if(patron.test(sigla)) {
		var stringJson = JSON.parse(jsonString);
		callActionAjax( "/catalogos/estudios/llamaActualizaEstudio", stringJson, procesaRespuestaActualiza);
	}else {
		$('#modalAgregaActualiza').modal('hide');
		showError("La sigla debe ser alfanum\u00E9rica y su longitud de 2 o 3.");
	}

}

function procesaRespuestaActualiza(jsonData) {
	
	var seRepite = jsonData.seRepiteSigla;
	
	$('#modalAgregaActualiza').modal('hide');
	
	if(!seRepite) {
		showMessage("Actualizado con \u00E9xito");
	}else {
		showError("La sigla se repite en otro Estudio.");
	}
	
	inicial();	
}

function callActionAjax(actionRoute, jsonActionParameter, functionProcessor){
	
	 $.ajax({
	     url: contextPath + actionRoute,
	     type: 'POST',
	     data:  jsonActionParameter, 
		 dataType: "json",
	     success:function(response){ 
	    	 functionProcessor(response);    
	     },
	     error:function(jqXhr, textStatus, errorThrown){
	         showError("Problemas al enviar los datos.");
	     }
	 });	
}