function tablaDinamica(value) {

	this.nuevaFila = 0;	
		
	if (value) {
		if (window === this) 
			return new tablaDinamica(value);		
		this.e = document.getElementById(value);
		return this;
	} 
	else {			
		return null;
	}
}

tablaDinamica.prototype = {
	crearTabla:	function (id, clase) {				   
				   var tabla     = $("<table/>").attr("id",id).addClass(clase);			
				   tabla.append($("<thead/>")).append($("<tbody/>"));				   				   
				   return tabla;										
			 },
			 
	envolverTabla : function(id, tabla){
				   var divTabla  = $("<div/>").attr("id",id).addClass("row divtabla");
			       divTabla.append("<br>").append(tabla);
				   return divTabla;
	},

	agregarFilaEncabezado:	function (tabla, encabezados, clase) {					
					var fila  = $("<tr/>").addClass(clase);
					for(var i = 0; i < encabezados.length; i++)
					{
						var th = $("<th/>").attr("colspan", encabezados[i].colspan).attr("id", encabezados[i].id).text(encabezados[i].texto).append(encabezados[i].html).addClass(encabezados[i].clase);
						
						if(typeof encabezados[i].atributos != 'undefined')
						{
							for(var j = 0; j < encabezados[i].atributos.length; j++)
							{
								th.attr(encabezados[i].atributos[j].nombre, encabezados[i].atributos[j].valor);
							}
						}
						fila.append(th);
					}						
					tabla.find("thead").append(fila);												
			},

	agregarFilaThTd: function (tabla, id, datos) {									
				var fila = $("<tr/>").attr("id", id);
				
				for(var i=0; i < datos.length; i++)
				    fila.append(datos[i]);
																	
				tabla.find("tbody").append(fila);
				return tabla;
	},
		
	crearFila: function(clase, datos, atributos){
			 var fila  = $("<tr/>").addClass(clase);
			 
			 for(var i=0; i < atributos.length; i++)		 
			     fila.attr(atributos[i][0],atributos[i][1]);			 		 
			
			 for(var i=0; i < datos.length; i++)		 
			     fila.append(datos[i]);
			 
			 return fila;
	},
	
	crearFilaEliminarCol: function(clase, numCol, numIndex, datos){
		 var fila  = $("<tr/>").addClass(clase);
		 fila.append("<td/>")
		 var j = 0;
		 for(var i=1; i <= numCol; i++)
		 {
			 if(numIndex != 0)
			 {
				 if(i >= numIndex)
					fila.append(datos[j++]);
				 else
				    fila.append("<td/>"); 
			 }		
			 else
				fila.append("<td/>");
		 }			 
		 fila.append("<td/>")
		 return fila;
	}	 
};