function callActionAjax(actionRoute, jsonActionParameter, functionProcessor){
	
	 $.ajax({
	     url: contextPath + actionRoute,
	     type: 'POST',
	     data:  jsonActionParameter, 
		 dataType: "json",
	     success:function(response){ 
	    	 functionProcessor(response);    
	     },
	     error:function(jqXhr, textStatus, errorThrown){
	         console.error("Error: " + textStatus + " ::: " + errorThrown + " ::: " + jqXhr);
	     }
	 });
	
}

//-----
function llamaImprimeMensaje(jsonData) {
	$('#mensaje').val(jsonData.mensajeRespuesta);
	showMessage(jsonData.mensajeRespuesta);
}

function sobreInputs(id) {
	
	if($('#tipoPago').val() == "FLAT"){
		var valores = $('#campoAnnio').val().split(" - ");
		idContratoPago = valores[0];
		annio = valores[1];
	}else {
		idContratoPago = $('#campoPeriodo').val();
		annio = "0";
	}
	
	var associativeArray = '{"idContrato":"' + $('#idContrato').val() + '","justificacion":"'+$('#justificacion').val()+'","tipoPago":"'+$('#tipoPago').val()+'", "annio":"'+annio+'","minimoMonto":"'+$('#campoMontoMinimo').val()+'", "idContratoPago":"'+ idContratoPago +'","categoriasMod":{';
	
	$("input[id$='_"+id+"']").each(function(){
        var id = $(this).attr("id");
        var value = $(this).val();
        var iddividido = id.split("_");
        var idMinimoidCategoria = iddividido[0].split("x");
        associativeArray += '"'+ idMinimoidCategoria[0] + '":"' + value + '",';
    });
	
	associativeArray = associativeArray.substring(0,associativeArray.length - 1) + "}}";
	
	return associativeArray;
}


function llamarModificaCategoriasAction() {
	var jsonString = sobreInputs(1);
	console.info(jsonString);
	var stringJson = JSON.parse(jsonString);
    callActionAjax( "/contrato/minimoSeleccion/modificaCategorias", stringJson, llamaImprimeMensaje);
}

//-----

function colocaPrecioAnualyMinimo(jsonData) {
	console.info(JSON.stringify(jsonData));
	$('#'+ jsonData.idMinimoSeleccion + '_pa').val(jsonData.precioAnual);
	$('#'+ jsonData.idMinimoSeleccion + '_ma').val(jsonData.minimo);
}

function propiedaesCampo(campo){
	
	
	var idstring = String(campo.attr("id"));
	var iddividido = idstring.split("_");
	var idMinimoidCategoria = iddividido[0].split("x");
	var idContratoPago = "0";
	var annio = "0";
	
	if($('#tipoPago').val() == "FLAT"){
		var valores = $('#campoAnnio').val().split(" - ");
		idContratoPago = valores[0];
		annio = valores[1];
	}else {
		idContratoPago = $('#campoPeriodo').val();
	}
	
	var jsonString = '{"idContrato" : "' + $('#idContrato').val() + '", "tipoPago" : "' + $('#tipoPago').val() + '", "idContratoPago" : "'+ idContratoPago +'", "annio" : "'+ annio +'", "idPagoCategoria":"'+ idMinimoidCategoria[1] +'", "idMinimoSeleccion":"'+idMinimoidCategoria[0]+'", "noTitulos":"'+campo.val()+'"}';
    console.info(jsonString);
	var stringJson = JSON.parse(jsonString);
    callActionAjax( "/contrato/minimoSeleccion/precioAnualMinimo", stringJson, colocaPrecioAnualyMinimo);
}

//----- 
function buildTableAnnioPeriodo(idNombreTablaPosicion, idNombreTablaContenedor, idNombreTabla, annioPeriodo) {
	
	var categorias = annioPeriodo.categorias;
	
	$('#campoMontoMinimo').val(annioPeriodo.minimoMonto);
	$('#idCampoMontoMinimo').val(annioPeriodo.idContratoPago);
	
	var habilitar = "";
	var idEstatus = $('#idEstatus').val();
	
	if(idEstatus > 1) {
		habilitar = "disabled";
	}
	
	
	$('#' + idNombreTablaContenedor).remove();
	
	var tabla =  '<div id="'+ idNombreTablaContenedor +'" >'+  
	    '<table id="'+idNombreTabla +'" class="table table-striped table-hover ">'+
		   '<thead class="TitulosTabla">'+
		      '<tr  class="encabezado">'+
		         '<th style="width: 150px;">Categor&iacutea</th>'+
		         '<th style="width: 120px;">T&iacutetulos</th>'+
		         '<th style="width: 120px;">Precio Anual</th>'+
			     '<th style="width: 120px;">M&iacutenimo</th>'+
		      '</tr>'+
	       '</thead>'+
	      
	       '<tbody class="ContenidoTabla">'+
	       '</tbody>'+
	    '</table>'+
	 '</div>';
	
	$('#' + idNombreTablaPosicion).append(tabla);
	
	for(var i = 0; i < categorias.length; i++) {
		categoria = categorias[i];
		
		var categoriaRow =
			'<tr>'+
				'<td>' + categoria.descripcionCategoria + '</td>'+
				'<td> <input type="number" name="'+ categoria.idMinimoSeleccion + 'x' + categoria.idPagoCategoria + '_'+ 1 +'"  id = "' + categoria.idMinimoSeleccion + 'x' + categoria.idPagoCategoria + '_'+ 1 +'" onchange="propiedaesCampo($(this))" class="form-control digit" min="0" '+habilitar+' value= "' + categoria.minimoTitulos + '"/></td>'+
				'<td> <input type="number" name="'+ categoria.idMinimoSeleccion +'_pa"  id = "' + categoria.idMinimoSeleccion + '_pa" onchange="propiedaesCampo($(this))" class="form-control digit" disabled value="'+ categoria.precioAnual +'" /></td>'+
				'<td> <input type="number" name="'+ categoria.idMinimoSeleccion +'_ma"  id = "' + categoria.idMinimoSeleccion + '_ma" onchange="propiedaesCampo($(this))" class="form-control digit" disabled value="'+ categoria.minimo +'" /></td>'+
			'</tr>';
			 
		$('#' + idNombreTabla + ' > tbody:last').append(categoriaRow);
		
	}	
}

function callBuildTableAnnioPeriodo(jsonData) {
	console.info(JSON.stringify(jsonData));
	buildTableAnnioPeriodo("tablaCategoriasPosicion", "ddaTablaCategorias", "tablaCategorias", jsonData.annioPeriodo);
	$('#campoMontoPosicion').show();
	$('#divButtons').show();
}

function llamaAnnioPeriodoAction(){
	
	var idContratoPago = "0";
	var annio = "0";
	
	if($('#tipoPago').val() == "FLAT"){
		var valores = $('#campoAnnio').val().split(" - ");
		idContratoPago = valores[0];
		annio = valores[1];
	}else {
		idContratoPago = $('#campoPeriodo').val();
	}
	
	var jsonString = '{"idContrato" : "' + $('#idContrato').val() + '", "tipoPago" : "' + $('#tipoPago').val() + '", "idContratoPago" : "'+ idContratoPago +'", "annio" : "'+ annio +'"}';
    console.info(jsonString);
	var stringJson = JSON.parse(jsonString);
    callActionAjax( "/contrato/minimoSeleccion/anniosPeriodos", stringJson, callBuildTableAnnioPeriodo);
	
}

$().ready(function() {
	
	$('#campoMontoPosicion').hide();
	$('#divButtons').hide();
	llamaAnnioPeriodoAction();
	
});