$(document)
	.ready(
		function() {
			getReportes();
			getEstudios();

		}
	);

var columnasSeleccionadas = null;
var meses = new Array("Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic");
var fecha = new Date();

gayColumnasROP = new Array();
gayColumnasROP['NAME'] = 'Asset Name';
gayColumnasROP['MG'] = 'MG';
gayColumnasROP['CLASE'] = 'Class';
gayColumnasROP['MES'] = meses[fecha.getMonth()] + "-" + fecha.getFullYear();
gayColumnasROP['SPLIT'] = 'SPLIT';
gayColumnasROP['MAX'] = 'MAX';
gayColumnasROP['OVERAGE'] = 'Overage';

gayColumnasRRS = new Array();
gayColumnasRRS['SERVICE'] = 'Service';
gayColumnasRRS['REGION'] = 'Region';
gayColumnasRRS['NAME'] = 'Standard Asset Name';
gayColumnasRRS['COUNTRY'] = 'Country';
gayColumnasRRS['REVENUE'] = 'Revenue Share';
gayColumnasRRS['VAT'] = 'Client Retail (VAT)';
gayColumnasRRS['MES'] = meses[fecha.getMonth()] + "-" + fecha.getFullYear();
gayColumnasRRS['TOTAL'] = 'Total Revenue';


gayColumnasRAB = new Array();
gayColumnasRAB['NAME'] = 'Asset Name';
gayColumnasRAB['MES'] = meses[fecha.getMonth()] + "-" + fecha.getFullYear();
gayColumnasRAB['TOTAL'] = 'Total General';


gayReportes = new Array();
gayReportes['ROP'] = 'Overages &amp; Payments';
gayReportes['RRS'] = 'Revenues &amp; Splits';
gayReportes['RAB'] = 'Acumulate Buys';


function getReportes() {

	$('#reportes').append('<option value="0"> Seleccione</option>');
	$('#reportes').append('<option value="ROP">Overages & Payments</option>');
	$('#reportes').append('<option value="RRS">Revenues & Splits</option>');
	$('#reportes').append('<option value="RAB">Acumulate Buys</option>');


}

function getEstudios() {
	$.ajax({
		url: contextPath + "/reporte/configuracionReportes/getCatalogos",
		type: 'POST',
		dataType: 'json',
		success: function(response) {
			if (response.msgError != null)
				showError(response.msgError);
			else {
				$('#estudios').append('<option value="0"> Seleccione</option>');
				for (var i = 0; i < response.catalogos.estudios.length; i++) {
					var opcion = '<option value="' + response.catalogos.estudios[i].idEstudio + '">' + response.catalogos.estudios[i].descripcionEstudio + '</option>';
					$('#estudios').append(opcion);
				}
				$("#estudios").val("0");
			}
		}
	});
}

function fConsultaConfiguracion() {

	if ($('#estudios').val() != "0" && $('#reporte').val() != "0") {
		var jsonString = '{"claveReporte": "' + $("#reportes").val() + '", "idEstudio": "' + $("#estudios").val() + '"}';
		var stringJson = JSON.parse(jsonString);

		$.ajax({
			url: contextPath + "/reporte/configuracionReportes/consultaConfiguracion",
			type: 'POST',
			data: stringJson,
			dataType: "json",
			success: function(response) {
				if (response.msgError != null)
					showError(response.msgError);
				else {
					columnasSeleccionadas = response.clavesSeleccionadas;
					fCargarColumnas();
				}
			}
		});
	}
}


function fCargarColumnas() {

	var pstClave = $("#reportes").val();

	$("#dvColumnas").empty();
	$("#dvGuardar").empty();
	$('#idVistaPrevia').remove();
	$("#divTabla").empty();

	if (pstClave == "ROP") {
		$("#dvColumnas").append('<table align="left" width="70%" cellpadding="4" cellspacing="0" border="0"> ' +
			'<tr>' +
			'<td width="15%"><label><input type="checkbox" name="chCol_MG" id="chCol_MG" value="MG" onclick="fCargarVistaPrevia()"> MG </label></td>' +
			'<td width="15%"><label><input type="checkbox" name="chCol_CLASE" id="chCol_CLASE" value="CLASS" onclick="fCargarVistaPrevia()"> Class </label></td>' +
			'<td width="15%"><label><input type="checkbox" name="chCol_MES" id="chCol_MES" value="MES" onclick="fCargarVistaPrevia()"> Mes </label></td>' +
			'<td width="15%"><label><input type="checkbox" name="chCol_SPLIT" id="chCol_SPLIT" value="SPLIT" onclick="fCargarVistaPrevia()"> SPLIT </label></td>' +
			'<td width="15%"><label><input type="checkbox" name="chCol_MAX" id="chCol_MAX" value="MAX" onclick="fCargarVistaPrevia()"> MAX </label></td>' +
			'<td width="15%"><label><input type="checkbox" name="chCol_OVERAGE" id="chCol_OVERAGE" value="OVERAGE" onclick="fCargarVistaPrevia()"> Overage </label></td>' +
			'</tr>' +
			'</table>');

	}//Termina if( pstClave == "ROP" )

	if (pstClave == "RRS") {
		$("#dvColumnas").append('<table align="left" width="70%" cellpadding="4" cellspacing="0" border="0"> ' +
			'<tr>' +
			'<td width="10%"><label><input type="checkbox" name="chCol_SERVICE" id="chCol_SERVICE" value="SERVICE" onclick="fCargarVistaPrevia()"> Service </label></td>' +
			'<td width="10%"><label><input type="checkbox" name="chCol_REGION" id="chCol_REGION" value="REGION" onclick="fCargarVistaPrevia()"> Regi\u00F3n </label></td>' +
			'<td width="10%"><label><input type="checkbox" name="chCol_COUNTRY" id="chCol_COUNTRY" value="COUNTRY" onclick="fCargarVistaPrevia()"> Country </label></td>' +
			'<td width="15%"><label><input type="checkbox" name="chCol_REVENUE" id="chCol_REVENUE" value="REVENUE" onclick="fCargarVistaPrevia()"> Revenue Share </label></td>' +
			'<td width="15%"><label><input type="checkbox" name="chCol_VAT" id="chCol_VAT" value="VAT" onclick="fCargarVistaPrevia()"> Client Retail (VAT) </label></td>' +
			'<td width="8%"><label><input type="checkbox"  name="chCol_MES" id="chCol_MES" value="MES" onclick="fCargarVistaPrevia()"> Mes </label></td>' +
			'<td width="12%"><label><input type="checkbox" name="chCol_TOTAL" id="chCol_TOTAL" value="TOTAL" onclick="fCargarVistaPrevia()"> Total Revenue </label></td>' +
			'</tr>' +
			'</table>');

	}//Termina if( pstClave == "RRS" )

	if (pstClave == "RAB") {
		$("#dvColumnas").append('<table align="left" width="20%" cellpadding="4" cellspacing="0" border="0"> ' +
			'<tr>' +
			'<td width="10%"><label><input type="checkbox" name="chCol_MES" id="chCol_MES" value="MES" onclick="fCargarVistaPrevia()"> Mes </label></td>' +
			'<td width="10%"><label><input type="checkbox" name="chCol_TOTAL" id="chCol_TOTAL" value="TOTAL" onclick="fCargarVistaPrevia()"> Total General </label></td>' +
			'</tr>' +
			'</table>');
	}//Termina if( pstClave == "RAB" )


	if (columnasSeleccionadas != null) {
		var layColumnas = columnasSeleccionadas.split(',');

		for (var i = 0; i < layColumnas.length; i++) {
			$("#chCol_" + layColumnas[i]).prop('checked', true);

		}//Termina for( var i=0; i<layColumnas.length; i++ )

	}
	else {
		$("input:checkbox[name^='chCol_']").each(function() {
			$(this).prop('checked', true);
		});

	}




	$("#dvGuardar").append('<button type="submit" class="btn btn-success" onclick="guardarConfiguracion()">Guardar cambios</button>');

	fCargarVistaPrevia();
}


function fCargarVistaPrevia() {
	$("#divTabla").empty();
	$('#idVistaPrevia').remove();

	var lnuTotalColumnas = 0;
	var pstClaveReporte = $("#reportes").val();


	var lstTitulo = $("<div id='dvTitulo'><label class=' control-label sep-bottom'><b> Vista Previa Reporte " + gayReportes[pstClaveReporte] + "</b></label></div><br>")
	var lstTabla = $("<table id='idVistaPrevia' class='table' border='1'/>");
	var lstEncabezado = $("<thead/>");
	var lstCuerpo = $("<tbody/>");
	var lstFila = $("<tr class='encabezado'/>");

	if (pstClaveReporte == 'RAB')
		var lstTabla = $("<table id='idVistaPrevia' width='40%' class='table' border='1'/>");



	lstTabla.append(lstEncabezado.append(lstFila)).append(lstCuerpo);

	$("#divTabla").append(lstTitulo);
	$("#divTabla").append(lstTabla);

	var gayColumnas = new Array();

	if (pstClaveReporte == 'ROP')
		gayColumnas = gayColumnasROP;
	else if (pstClaveReporte == 'RRS')
		gayColumnas = gayColumnasRRS;
	else if (pstClaveReporte == 'RAB')
		gayColumnas = gayColumnasRAB;

	for (var lstColumna in gayColumnas) {
		if (lstColumna == 'NAME')
			lstFila.append($("<th/>").text("Standard Asset Name"));

		if ($("#chCol_" + lstColumna).is(":checked")) {
			lstFila.append($("<th/>").text(gayColumnas[lstColumna]));
		}

	}


	var Fila = $("<tr/>");
	for (i = 0; i < gayColumnas.length; i++)
		Fila.append($("<td/>").text(""));

	$("#idVistaPrevia tbody").append(Fila);

}


function guardarConfiguracion() {
	if ($('#estudios').val() == "0")
		showError("Favor de elegir un estudio");
	else {
		var lstClavesColumnas = '';

		$("input:checkbox[name^='chCol_']").each(function() {

			if ($(this).is(':checked')) {

				lstClavesColumnas = lstClavesColumnas + $(this).val() + ',';

			}
		});


		var lnuTotalCaracteres = lstClavesColumnas.length;
		var lstColumnas = lstClavesColumnas.substring(0, (lnuTotalCaracteres - 1));


		var jsonString = '{"claveReporte": "' + $("#reportes").val() + '", "idEstudio": "' + $("#estudios").val() + '", "clavesColumnas": "' + lstColumnas + '"}';
		var stringJson = JSON.parse(jsonString);

		$.ajax({
			url: contextPath + "/reporte/configuracionReportes/guardaConfiguracion",
			type: 'POST',
			data: stringJson,
			dataType: "json",
			success: function(response) {
				if (response.msgError != null)
					showError(response.msgError);
				else
					showMessage("Se guardo correctamente la configuraci\u00F3n");
			}
		});
	}
}