function PagosTxController ()
{
	this.grid =  new PagosTxGrid();
	this.idFormEliminar = $("#idFormBusqueda").validate({});
	var me = this;
	$('#mes').datepicker( {
		maxDate: '-1m',
        dateFormat: 'mm-yy',
        onClose: function(dateText, inst) { 
        	if(dateText != ''){
        		$(this).datepicker('setDate', new Date(inst.currentYear, inst.currentMonth, 1));
        		me.buscarPagos();
        	}
        }
    });
}

PagosTxController.prototype.buscarPagos = function() {
	if($("#idFormBusqueda").valid())
	{
		var fec = '01-'+$("#mes").val();
		var items = [];
		var meses = [];
		this.ajax("buscaPagos", { 
			"filtros.idEstudio" : $("#estudio").val() ,
			"filtros.fecha" :  fec.replace(/-/g,"/"),
			"filtros.tipoTitulo" :  $("#tipoTitulo").val(),
			"filtros.asc" : $("#tipoOrden").val(),
			"filtros.numMesesHistorico" : $("#nummes").val()
		} , function (ret) {
			  items = ret.pagos;
			  meses = ret.meses;
		} , function (ret) {
			    showError(ret.error);
		});
		this.grid.paint(items,meses);
	}
}

PagosTxController.prototype.ajax = function(method, data, success, error) {
	$.ajax({
		url : contextPath+ '/reporte/pagoTransaccionesH/' + method + 'pagosTXHAjax.action',
		type : "post",
		data : data,
		async : false,
		success : function (ret)
		{
			if(ret.error == '' || ret.error == null)
			{
				success(ret);
			}
			else{
				error(ret);
			}
		},
		error : function ()
		{
			showError("Ocurri\u00F3 un error");
		}
	});
}

var pagosTxController;

$().ready(function() {
	pagosTxController = new PagosTxController();
});