package com.mx.dla.dda.contrato.transaccion.terminos.daos;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.carga.transaccion.dtos.TitulosCargaTransaccionesDTO;
import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.ComunTerminosDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.FsCategoriaMGDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.FsPeriodoCatDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.FsPeriodoDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.FsSeccionDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.TerminoMinimoDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.TerminoPrecioDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.TerminosAuxiliarDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.TerminosPaisDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.TerminosPrecioDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.TerminosRevenueDTO;

public interface TerminosTransaccionDAO {
	                                                                                                       
	public List<TerminoMinimoDTO> obtenerMinimosCategoria    (@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public List<String>           obtenerMinPeriodosCategoria(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public List<String>           obtenerMinCatsCategoria    (@Param("idContrato")Long idContrato, @Param("seccion")String seccion);	
	public List<TerminoMinimoDTO> obtenerMinimosPeriodo      (@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public Integer                obtenerMinimosNA           (@Param("idContrato")Long idContrato, @Param("seccion")String seccion);

	public void guardarSeccionMinimo   (@Param("seccion")FsSeccionDTO seccion);
	public void guardarSeccionRevenue  (@Param("seccion")FsSeccionDTO seccion);	
	public void guardarPeridoMinimos   (@Param("periodo")FsPeriodoDTO periodo);
	public void guardarCategoriaMinimos(@Param("categoria")FsCategoriaMGDTO categoria);
	public void guardarPerCategaMinimos(@Param("percat")FsPeriodoCatDTO percat);
	
	public void eliminarSeccionMinimo   (@Param("idSeccion")Long idSeccion, @Param("seccion")String seccion);
	public void eliminarPeridoMinimos   (@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public void eliminarCategoriaMinimos(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public void eliminarPerCategaMinimos(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	
	
	public List<TerminoMinimoDTO> obtenerRelease        (@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public void                   guardarValoresRelease (@Param("release")TerminoMinimoDTO release, @Param("idContrato")Long idContrato, @Param("idSeccion")Long idSeccion);
	public void                   eliminarRelease       (@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	
	public Integer                 obtenerAplicaPrecios(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public List<Integer>           obtenerNumRegPrecios(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public List<TerminoPrecioDTO>  obtenerPrecioPremier(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public List<TerminoPrecioDTO>  obtenerPrecioLibreria(@Param("idContrato")Long idContrato);
	public void                    eliminarValoresPrecioLibreria(@Param("idContrato")Long idContrato);
	public void guardarValoresPrecioLibreria(@Param("precios")List<TerminosPrecioDTO> precios, @Param("idContrato")Long idContrato);
	public void actualizarAplicaPrecios(@Param("idContrato")Long idContrato, @Param("seccion")String seccion, @Param("aplica")Integer aplica);
	
	
	public void guardarValoresPrecio(@Param("precios")List<TerminosPrecioDTO> precios, @Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public void eliminarValoresPrecio(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	
	public List<TerminosPaisDTO> obtenerFormatos();
	public List<TerminosPaisDTO> obtenerPaises(@Param("idContrato")Long idContrato);

	public List<TerminosRevenueDTO> obtenerRevenueRelease(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public List<String>             obtenerPeriodosRevenue(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public void                     guardarRevenue(@Param("revenues")List<TerminosRevenueDTO> revenues);
	public void                     eliminarRevenue(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
		
	
	//public List<TerminosRevenueDTO> obtenerRevenueBox(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	//public List<TerminosRevenueDTO> obtenerRevenueGlobal(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	
	//public void actualizarTipoRevenue(@Param("idCatMin")Long idCatMin);
	//public void actualizarRevenueBox(@Param("id")Long id, @Param("p_dla")String p_dla, @Param("p_estudio")String p_estudio);
	//public void guardarRevenueGloblal(@Param("idContrato")Long idContrato, @Param("idSeccion")Long idSeccion, @Param("dla")String dla, @Param("estudio")String estudio);
	
	//public void actualizarTipoRevenueGB(@Param("tipo")String tipo, @Param("idSeccion")Long idSeccion);
	//public void eliminarRevenueGlobal(@Param("idContrato")Long idContrato, @Param("idSeccion")Long idSeccion);

	public ComunTerminosDTO obtenerComun(@Param("idContrato")Long idContrato);
	public List<CatalogoDTO>           obtenerTiposCambio();
	
	public void guardarComun(@Param("idContrato")Long idContrato, @Param("tipoCambio")Long tipoCambio, @Param("inflacion")Double inflacion);
	public void eliminarDatosComun(@Param("idContrato")Long idContrato);
	

	public List<TerminoPrecioDTO>  obtenerPrecioMovies(@Param("idContrato")Long idContrato);
	public List<TerminoPrecioDTO>  obtenerPrecioSeries(@Param("idContrato")Long idContrato);
	
	public Integer obtenerNumRegPreciosMovies(@Param("idContrato")Long idContrato);
	public Integer obtenerNumRegPreciosSeries(@Param("idContrato")Long idContrato);
	
	public List<TerminosPaisDTO> obtenerTiers();
	public List<TerminosPaisDTO> obtenerCatSeries();
	
	public void eliminarPrecioMovies(@Param("idContrato")Long idContrato);
	public void eliminarPrecioSeries(@Param("idContrato")Long idContrato);

	public void guardarValoresPrecioMovies(@Param("precios")List<TerminosPrecioDTO> precios, @Param("idContrato")Long idContrato);
	public void guardarValoresPrecioSeries(@Param("precios")List<TerminosPrecioDTO> precios, @Param("idContrato")Long idContrato);

	public List<TerminosRevenueDTO> obtenerRevenueMoviesBox(@Param("idContrato")Long idContrato);
	public List<String> obtenerPeriodosRevenueMoviesBox(@Param("idContrato")Long idContrato, @Param("idSeccion")Long idSeccion);
	public List<TerminosRevenueDTO> obtenerRevenueMoviesGlobal(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	
	public void guardarValoresRevGlobal(@Param("idContrato")Long idContrato, @Param("idSeccion")Long idSeccion, @Param("revenues")List<TerminosRevenueDTO> revenues);
	public void guardarValoresRevBoxMovies(@Param("idContrato")Long idContrato, @Param("revenues")List<TerminosRevenueDTO> revenues);
	
	public void actualizaTipoRevenue(@Param("idSeccion")Long idSeccion, @Param("tipo")String tipo);
	public void eliminarRevenueGlobalMovies(@Param("idContrato")Long idContrato, @Param("idSeccion")Long idSeccion);
	public void eliminarRevenueBoxMovies(@Param("idContrato")Long idContrato);
	
	
	public void guardarValoresRevBoxSeries(@Param("idContrato")Long idContrato, @Param("revenues")List<TerminosRevenueDTO> revenues);
	public List<TerminosRevenueDTO> obtenerRevenueSeriesBox(@Param("idContrato")Long idContrato);
	public void eliminarRevenueBoxSeries(@Param("idContrato")Long idContrato);
	public Long obtenerIdSeccion(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	
	public List<String> obtenerPestanaActual(@Param("idContrato")Long idContrato);

	public List<TerminosAuxiliarDTO> obtenerExcepcionesDatos(@Param("idContrato")Long idContrato,  @Param("seccion")String seccion);
	public List<TerminosAuxiliarDTO> obtenerPeriodos(@Param("idContrato")Long idContrato, @Param("seccion")String seccion, @Param("tipo")String tipo);
	public List<TerminosAuxiliarDTO> obtenerExcepcionesTitulos(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public void    guardarExcepciones(@Param("excepciones")List<TerminosAuxiliarDTO> excepciones);
	public void    eliminarExcepcion(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);

	public List<TerminosPaisDTO> obtenerPaisesImpuestoEstatus(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public void    eliminarPaisesImpuestoEstatus(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public void    guardaPaisesImpuestoEstatus(@Param("impuesto")TerminosAuxiliarDTO impuesto);
	
	public Integer obtenerPagoPpe(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public void actualizarPagoPpe(@Param("idContrato")Long idContrato, @Param("seccion")String seccion, @Param("pagoPpe")Integer pagoPpe);

	public List<TerminosAuxiliarDTO> obtenerBoxOfficeRevenueDatos(@Param("idContrato")Long idContrato, @Param("seccion")String seccion, @Param("tipo")String tipo);
	public List<TerminoMinimoDTO> obtenerMinimosCategoriasBoxOffice    (@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public void    guardarRevenueLibreriaBoxOffice(@Param("revenues")List<TerminosAuxiliarDTO> revenues);

	public Long    obtenerIdMinimoPorValores(@Param("aux")TerminosAuxiliarDTO aux);
	public void eliminarMinimosCategoriasBoxOffice(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public String obtenerTipoRevenue(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public String obtenerTipoMinimo(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);

	public void calculaPagoMinGarantizado(@Param("idContrato")Long idContrato);

}
