package com.mx.dla.dda.reporte.cpview.daos;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.reporte.cpview.dtos.CargaVisualizacionesDetalleDTO;
import com.mx.dla.dda.reporte.cpview.dtos.CargaVisualizacionesPrincipalDTO;
import com.mx.dla.dda.reporte.cpview.dtos.CostPerViewEstudioAnualDatosDTO;
import com.mx.dla.dda.reporte.cpview.dtos.CostPerViewEstudioMensualDatosDTO;

public interface ReporteCostPerViewDAO {

	List<CostPerViewEstudioMensualDatosDTO> obtenerCostPerViewMensualDatosEstudioNivel(@Param("mes") Long mes, @Param("anio") Long anio);

	List<CostPerViewEstudioAnualDatosDTO> obtenerCostPerViewAnualDatosEstudioNivel(@Param("anio_inicial") Long anio_inicial, @Param("anio_final") Long anio_final, @Param("mes") Long mes,
	        @Param("pivot_data") String pivot_data);
	
	List<CostPerViewEstudioMensualDatosDTO> obtenerCostPerViewMensualDatosTituloNivel(@Param("mes") Long mes, @Param("anio") Long anio, @Param("estudio") Long idEstudio,@Param("nombreUnico") String nombreUnico, @Param("temporada") String  temporada);

	List<CostPerViewEstudioAnualDatosDTO> obtenerCostPerViewAnualDatosTituloNivel(@Param("anio_inicial") Long anio_inicial, @Param("anio_final") Long anio_final, @Param("mes") Long mes,
	        @Param("pivot_data") String pivot_data, @Param("estudio") Long idEstudio, @Param("nombreUnico") String nombreUnico, @Param("temporada") String  temporada);

	List<CargaVisualizacionesPrincipalDTO> obtenerVisualizacionesPrincipal(@Param("mes") Long mes, @Param("anio") Long anio);

	List<CargaVisualizacionesDetalleDTO> obtenerVisualizacionesDetalle(@Param("mes") Long mes, @Param("anio") Long anio);

	List<CargaVisualizacionesDetalleDTO> obtenerVisualizaciones(@Param("mes") Long mes, @Param("anio") Long anio);

	
	List<CostPerViewEstudioMensualDatosDTO> obtenerCostPerViewDiciembreDatosEstudioNivel(@Param("anio") Long anio);

	List<CostPerViewEstudioMensualDatosDTO> obtenerCostPerViewDiciembreDatosTituloNivel(@Param("anio") Long anio, @Param("estudio") Long idEstudio, @Param("nombreUnico") String nombreUnico, @Param("temporada") String  temporada);

}
