package com.mx.dla.dda.catalogos.bos;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.admin.catalogos.estudios.daos.CatalogoEstudiosDAO;
import com.mx.dla.dda.admin.catalogos.estudios.dtos.CatalogoContratoDTO;
import com.mx.dla.dda.catalogos.daos.CatalogosDAO;
import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.catalogos.dtos.CategoriaDTO;
import com.mx.dla.dda.catalogos.dtos.EmpresaVentaDTO;
import com.mx.dla.dda.catalogos.dtos.EstatusDTO;
import com.mx.dla.dda.catalogos.dtos.EstudioDTO;
import com.mx.dla.dda.catalogos.dtos.FormatoDTO;
import com.mx.dla.dda.catalogos.dtos.MedioEntregaDTO;
import com.mx.dla.dda.catalogos.dtos.PaisVentaDTO;
import com.mx.dla.dda.catalogos.dtos.RegionVentaDTO;
import com.mx.dla.dda.catalogos.dtos.ReleaseDTO;
import com.mx.dla.dda.catalogos.dtos.ServicioDTO;
import com.mx.dla.dda.catalogos.dtos.TerritorioDTO;
import com.mx.dla.dda.contrato.fees.dtos.TiempoVidaDTO;
import com.mx.dla.dda.contrato.fees.dtos.TipoSuscriptorDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

@Component
public class CatalogosBO {

	@Autowired
	private CatalogosDAO catalogosDAO;

	@Autowired
	private CatalogoEstudiosDAO contratosDAO;

	public List<EstudioDTO> obtenListaEstudios() throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.obtenerEstudios();
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public List<CategoriaDTO> obtenListaCategorias() throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.obtenerCategorias();
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public List<ServicioDTO> obtenListaServicios() throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.obtenerServicios();
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public List<TerritorioDTO> obtenListaTerritorios() throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.obtenerTerritorios();
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public List<MedioEntregaDTO> obtenListaMediosEntrega()
			throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.obtenerMediosEntrega();
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public List<EstatusDTO> obtenerEstatus() throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.obtenerEstatus();
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public List<FormatoDTO> getFormatos() throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.getFormatos();
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public List<ReleaseDTO> getReleases() throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.getReleases();
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public List<PaisVentaDTO> getPaises() throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.getPaises();
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public int obtenSqIdContrato(String tipoOperacion, int idContrato)
			throws ResultMapException, SQLException, TransaccionException {
		try {
			if (tipoOperacion.equals("Alta")) {
				idContrato = catalogosDAO.obtenerSqIdContrato();
			}
			return idContrato;
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public List<EmpresaVentaDTO> getEmpresasVenta() throws ResultMapException, SQLException, TransaccionException {
		try {

			List<EmpresaVentaDTO> empresas = new ArrayList<EmpresaVentaDTO>();
			empresas = catalogosDAO.getEmpresasVenta();
			return empresas;
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public PaisVentaDTO getPaisXId(Long idPais) throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.getPaisXId(idPais);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public RegionVentaDTO getRegionXId(@Param("id") Long id)
			throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.getRegionXId(id);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public List<RegionVentaDTO> getRegiones() throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.getRegiones();
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public List<TipoSuscriptorDTO> obtenerTipoSuscriptor()
			throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.obtenerTipoSuscriptor();
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public List<TiempoVidaDTO> obtenerTiempoVida() throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.obtenerTiempoVida();
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public List<CatalogoDTO> obtenCatalogoEmpresas(List<Long> idEmpresas, List<Long> idPaises,
			List<String> descEmpresas, List<Long> staEmpresas)
			throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.obtenCatalogoEmpresas(idEmpresas, idPaises, descEmpresas, staEmpresas);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public List<CatalogoDTO> obtenCatalogoAreas(List<Long> idAreas, List<String> descAreas,
			List<Long> indAutorizaContratoAreas, List<Long> ordenAreas)
			throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.obtenCatalogoAreas(idAreas, descAreas, indAutorizaContratoAreas, ordenAreas);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public List<CatalogoDTO> obtenCatalogoPerfiles(List<Long> idPerfiles, List<String> descPerfiles,
			List<Long> staPerfiles) throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.obtenCatalogoPerfiles(idPerfiles, descPerfiles, staPerfiles);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public List<CatalogoDTO> obtenCatalogoEstudios(List<Long> idEstudios, List<Long> idSapEstudios,
			List<String> descEstudios, List<String> monedaEstudios, List<String> codigoPaisEstudios,
			List<String> nombrePaisEstudios, List<String> sociedadEstudios, List<String> siglaDdaEstudios,
			List<Long> ordenEstudios, List<Long> idGroupEstudios)
			throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.obtenCatalogoEstudios(idEstudios, idSapEstudios, descEstudios, monedaEstudios,
					codigoPaisEstudios, nombrePaisEstudios, sociedadEstudios, siglaDdaEstudios, ordenEstudios,
					idGroupEstudios);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public List<CatalogoDTO> obtenCatalogoPeliculasSeries(long idEstudio)
			throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.buscarCatalogoTitulosCPV(idEstudio);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public List<CatalogoDTO> obtenCatalogoTemporadas(long idEstudio, String nombreUnico)
			throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.buscarCatalogoTemporadas(idEstudio, nombreUnico);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	/** RFD **/
	public List<CatalogoDTO> obtenContratos(long idEstudio)
			throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.buscarContratosPorEstudio(idEstudio);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public List<CatalogoDTO> obtenCatalogoPeliculasSeriesDC(long contrato)
			throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.buscarCatalogoTitulosDC(contrato);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public List<CatalogoDTO> obtenCatalogoTemporadasDC(long idEstudio, Long nombreUnico)
			throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogosDAO.buscarCatalogoTemporadasDC(idEstudio, nombreUnico);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	/** RFD **/

	public List<CatalogoContratoDTO> getContratosByEstudio(Long idEstudio)
			throws ResultMapException, SQLException, TransaccionException {
		try {
			return contratosDAO.contratosByEstudio(idEstudio);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

}
