package com.mx.dla.dda.contrato.bdeal.bos;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.contrato.bdeal.daos.BdealDAO;
import com.mx.dla.dda.contrato.bdeal.dtos.ErrorCargaDTO;
import com.mx.dla.dda.contrato.bdeal.dtos.TituloBdealDTO;
import com.mx.dla.dda.contrato.generales.enums.MensajeTexto;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.contrato.ws.actualizaridbroadview.ParamActualizaIdBVDTO;
import com.mx.dla.dda.contrato.ws.actualizaridbroadview.ResponseActualizaIdBVDTO;
import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.context.ExcelMapperContext;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;

@Component
public class BdealBO extends BaseBO {

	@Value("${uri.file.carga.broadview}")
	private String uriCarga;

	@Autowired
	protected ExcelMapperTransform excelMapperTransform;

	@Autowired
	private ExcelMapperContext excelMapperContext;

	@Autowired
	private BdealDAO bdealDAO;

	@Autowired
	private DLARestClientFactory dlaRestClientFactory;

	public ResponseActualizaIdBVDTO guardaDocumento(File fileUpload, String fileName, Long idContrato,
			String expediente) throws IOException, TransaccionException, ExcelMapperException {

		ParamActualizaIdBVDTO request = new ParamActualizaIdBVDTO();
		ResponseActualizaIdBVDTO response = null;
		DLARestClient client = null;

		

			boolean validado = excelMapperTransform.validateHeader(fileUpload, "tituloBdeal");
			logger.debug("validado : [{}]", validado);

			if (validado) {

				// Copia archivo en file system

				String nombreArchivo = uriCarga + idContrato + expediente + fileName;
				fileName = idContrato + expediente + fileName;

				byte[] file = FileUtils.readFileToByteArray(fileUpload);
				File d = new File(nombreArchivo);
				
				logger.debug("cadena nombrearchivo: : [{}]", nombreArchivo);
				logger.debug("uriCarga: : [{}]", uriCarga);
				
				
				d.setExecutable(true, false);
				d.setReadable(true, false);
				d.setWritable(true, false);

				logger.debug("Absolute path [{}]  -  [{}]", d.getCanonicalPath(), d.getPath());
				FileUtils.writeByteArrayToFile(d, file);
				
				logger.debug("objeto file : [{}]", file);
				logger.debug("objeto d : [{}]", d);
				
				client = dlaRestClientFactory.getClient(DLARestServices.ACTUALIZAR_ID_BROADVIEW);
				request.setNombreArchivo(idContrato + expediente + fileName);
				request.setExpediente(expediente);
				request.setIdContratoActual(idContrato.toString());
				logger.debug("request : [{}]", request);
				logger.debug("client!!! : [{}]", client);
				response = client.get(request, ResponseActualizaIdBVDTO.class);
				logger.debug("response : [{}]", response);
                
                
                
			} else {
				response = new ResponseActualizaIdBVDTO();
				response.setResultado(false);
				response.setMensaje(MensajeTexto.ERROR_AL_CARGAR.getTexto());
			}

		

		return response;
	}

	public InputStream seleccionaTipoDescarga(String tipo, Long id) {

		InputStream descarga = null;
		byte[] data = null;

		if (tipo.equals("titulos")) {
			data = exportarTitulosBdeal(id);
		} else {
			data = exportarErroresCarga(id);
		}

		descarga = new ByteArrayInputStream(data);

		return descarga;
	}

	public byte[] exportarTitulosBdeal(Long idContrato) {

		logger.info("idContrato : [{}]", idContrato);

		byte[] bytesExcel = null;
		List<TituloBdealDTO> titulosBdeal = null;
		ExcelMapper mapper = null;

		try {
			titulosBdeal = bdealDAO.obtenTituloBdeal(idContrato);

			if (titulosBdeal.size() == 0) {
				titulosBdeal.add(new TituloBdealDTO());
			}

			mapper = excelMapperContext.getExcelMapper("tituloBdeal");
			bytesExcel = excelMapperTransform.transformObjectToExcel(titulosBdeal, mapper, TituloBdealDTO.class);

		} catch (Exception ex) {
			logger.error("Error : [{}]", ex);
		}

		return bytesExcel;
	}

	public byte[] exportarErroresCarga(Long idCarga) {

		byte[] bytesExcel = null;
		List<ErrorCargaDTO> errores = null;
		ExcelMapper mapper = null;

		try {

			errores = bdealDAO.obtenErrorCarga(idCarga);

			if (errores.size() == 0) {
				errores.add(new ErrorCargaDTO());
			}

			mapper = excelMapperContext.getExcelMapper("erroresCargaBdeal");
			bytesExcel = excelMapperTransform.transformObjectToExcel(errores, mapper, ErrorCargaDTO.class);

		} catch (Exception ex) {
			logger.error("Error : [{}]", ex);
		}

		return bytesExcel;

	}

}
