package com.mx.dla.dda.reporte.configuracion.bos;

import java.sql.SQLException;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;

//import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.reporte.configuracion.daos.ConfiguracionReportesDAO;
import com.mx.dla.global.bos.BaseBO;

@Component
public class ConfiguracionReportesBO extends BaseBO {

	@Autowired
	private ConfiguracionReportesDAO configuracionReportesDAO;

	public void guardarConfiguracion(String claveReporte, Long idEstudio, String clavesColumnas)
			throws ResultMapException, SQLException, TransaccionException {

		logger.info("Parametros en ConfiguracionReportesBO claveReporte:" + claveReporte + ", id estudio: " + idEstudio
				+ ", claves Columnas:" + clavesColumnas);

		try {
			logger.info(
					"Se borra la configuracin que exista claveReporte:" + claveReporte + ", idEstudio:" + idEstudio);
			configuracionReportesDAO.eliminaConfiguracionReporte(claveReporte, idEstudio);

			String columnasClaves[] = clavesColumnas.split(",");

			for (String columna : columnasClaves) {
				logger.info("BO COLUMNA :" + columna);

				configuracionReportesDAO.insertarConfiguracionReporte(claveReporte, idEstudio, columna);
			}

		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos.", e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos", e);
		}

	}

	public String consultaConfiguracion(String claveReporte, Long idEstudio) throws ResultMapException, SQLException, TransaccionException {

		String columnasSeleccionadas = null;

		try {

			logger.info("Parametros en ConfiguracionReportesBO [consultaConfiguracion] claveReporte:" + claveReporte
					+ ", id estudio: " + idEstudio);
			logger.info(configuracionReportesDAO.consultaConfiguracion(claveReporte, idEstudio));

			columnasSeleccionadas = configuracionReportesDAO.consultaConfiguracion(claveReporte, idEstudio);

		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos.", e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos", e);
		}

		return columnasSeleccionadas;

	}

}