package com.mx.dla.dda.reporte.pagoSuscriptores.bos;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.reporte.pagoSuscriptores.daos.ReportePagoSuscriptoresDAO;
import com.mx.dla.dda.reporte.pagoSuscriptores.dtos.ReportePagoSuscriptoresDTO;

@Component
public class ReportePagoSuscriptoresBO {

	@Autowired
	private ReportePagoSuscriptoresDAO reportePagoSuscriptoresDAO;

	public List<ReportePagoSuscriptoresDTO> obtenInformacionReporte(
			ReportePagoSuscriptoresDTO datos) {

		List<ReportePagoSuscriptoresDTO> reporteData = reportePagoSuscriptoresDAO
				.consultaInfoReportePagoSuscriptores(datos);

		for (ReportePagoSuscriptoresDTO data : reporteData) {

			String titulo = data.getDescTitulo();
			String inicio = data.getFechaInicio();
			String fin = data.getFechaFin();
			String categoria = data.getDescCategoria();
			String precio = data.getPrecio();
			String suscriptores = data.getSuscriptores();

			if (titulo == null || titulo != null && titulo.trim().equals(""))
				data.setDescTitulo("");

			if (inicio == null || inicio != null && inicio.trim().equals(""))
				data.setFechaInicio("");

			if (fin == null || fin != null && fin.trim().equals(""))
				data.setFechaFin("");

			if (categoria == null || categoria != null
					&& categoria.trim().equals(""))
				data.setDescCategoria("");

			if (precio == null || precio != null && precio.trim().equals(""))
				data.setPrecio("");

			if (suscriptores == null || suscriptores != null
					&& suscriptores.trim().equals(""))
				data.setSuscriptores("");

		}

		return reporteData;

	}
}
