package com.mx.dla.dda.contrato.minimoseleccion.dtos;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

//import java.util.Locale;

public class PeridoPagoDTO implements Serializable{

	private static final long serialVersionUID = 1L;
	private Long idContratoPago;
	private Date fechaInicio;
	private Date fechaFin;
	private List<DetallePeriodoPagoDTO> detallePeriodo;
	private String sfechaInicio;
	private String sfechaFin;
	private String minimoMonto;

	public Long getIdContratoPago() {
		return idContratoPago;
	}

	public void setIdContratoPago(Long idContratoPago) {
		this.idContratoPago = idContratoPago;
	}

	public Date getFechaInicio() {

		return fechaInicio;
	}

	public void setFechaInicio(Date fechaInicio) {
		this.fechaInicio = fechaInicio;
	}

	public Date getFechaFin() {
		return fechaFin;
	}

	public void setFechaFin(Date fechaFin) {
		this.fechaFin = fechaFin;
	}

	public List<DetallePeriodoPagoDTO> getDetallePeriodo() {
		return detallePeriodo;
	}

	public void setDetallePeriodo(List<DetallePeriodoPagoDTO> detallePeriodo) {
		this.detallePeriodo = detallePeriodo;
	}

	public String getSfechaInicio() {
		// SimpleDateFormat formatoDeFecha = new SimpleDateFormat("dd/MMM/yyyy",
		// new Locale("es","MX"));
		// setSfechaInicio(formatoDeFecha.format(getFechaInicio()));
		setSfechaInicio(formatoFecha(getFechaInicio()));
		return sfechaInicio;
	}

	public void setSfechaInicio(String sfechaInicio) {
		this.sfechaInicio = sfechaInicio;
	}

	public String getSfechaFin() {
		// SimpleDateFormat formatoDeFecha = new SimpleDateFormat("dd/MMM/yyyy",
		// new Locale("es","MX"));
		// setSfechaFin(formatoDeFecha.format(getFechaFin()));
		setSfechaFin(formatoFecha(getFechaFin()));
		return sfechaFin;
	}

	public void setSfechaFin(String sfechaFin) {
		this.sfechaFin = sfechaFin;
	}

	@Override
	public String toString() {
		return "PeridoPagoDTO [idContratoPago=" + idContratoPago
				+ ", fechaInicio=" + fechaInicio + ", fechaFin=" + fechaFin
				+ ", detallePeriodo=" + detallePeriodo + "]";
	}

	public void setMinimoMonto(String minimoMonto) {
		this.minimoMonto = minimoMonto;
	}

	public String getMinimoMonto() {
		return minimoMonto;
	}

	public String formatoFecha(Date fechaIn) {

		String fechaOut = "";

		if (fechaIn != null) {

			fechaOut = new SimpleDateFormat("d/MM/yyyy").format(fechaIn);
			String[] fecha = fechaOut.split("/");
			int mes = Integer.parseInt(fecha[1]);

			switch (mes) {
			case 1:
				fechaOut = "/Ene/";
				break;
			case 2:
				fechaOut = "/Feb/";
				break;
			case 3:
				fechaOut = "/Mar/";
				break;
			case 4:
				fechaOut = "/Abr/";
				break;
			case 5:
				fechaOut = "/May/";
				break;
			case 6:
				fechaOut = "/Jun/";
				break;
			case 7:
				fechaOut = "/Jul/";
				break;
			case 8:
				fechaOut = "/Ago/";
				break;
			case 9:
				fechaOut = "/Sep/";
				break;
			case 10:
				fechaOut = "/Oct/";
				break;
			case 11:
				fechaOut = "/Nov/";
				break;
			case 12:
				fechaOut = "/Dic/";
				break;
			default:
				fechaOut = "/" + mes + "/";
			}
			fechaOut = fecha[0] + fechaOut + fecha[2];
		}

		return fechaOut;
	}

}
