package com.mx.dla.dda.general.utilerias;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class FechaUtilerias {

	public static HashMap<String, Long> getFechaValores(String fecha, String formato) throws ParseException {

		HashMap<String, Long> valores = new HashMap<String, Long>();

		DateFormat formatoEntrada = new SimpleDateFormat(formato);
		Date date = formatoEntrada.parse(fecha);

		SimpleDateFormat formatoMes = new SimpleDateFormat("MM");
		Long mes = Long.parseLong(formatoMes.format(date));

		SimpleDateFormat formatoAnio = new SimpleDateFormat("yyyy");
		Long anio = Long.parseLong(formatoAnio.format(date));

		valores.put("Year", anio);
		valores.put("Month", mes);

		return valores;
	}
	
	public static boolean monthGreatherThan(Date compare, Date other) {
		Calendar c = Calendar.getInstance();
		c.setTime(other);
		c.set(Calendar.DAY_OF_MONTH, c.getActualMaximum(Calendar.DAY_OF_MONTH));
		return compare.after(c.getTime());
	}

}
