package com.mx.dla.dda.contrato.titulo.actions;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.common.constants.ContratoConstats;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.titulo.bos.TituloBO;
import com.mx.dla.dda.contrato.titulo.constants.TipoCargaDocumento;
import com.mx.dla.dda.contrato.titulo.dtos.Lista;
import com.mx.dla.dda.contrato.titulo.dtos.RespuestaCargaExcel;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;
import com.mx.dla.dda.contrato.titulo.exception.TituloException;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;

public class TituloAction extends BaseContratoAction {

	private static final long serialVersionUID = -2801098338739181070L;

	@Autowired
	private GeneralesBO generalesBO;
	@Autowired
	private TituloBO tituloBO;

	private Lista clista;
	private Titulo titulo;
	private String error;

	private File file;
	private String fileContentType;
	private String fileFileName;
	private InputStream fileInputStream;

	private RespuestaCargaExcel respuestaExcel;
	private String tipoCarga;
	private String tipoAmortizacion;

	private String btnAmortizacion;
	private List<CatalogoDTO> tiposCarga;

	public String execute() throws TransaccionException  {

		Long idC = (Long) getSession().get(ContratoConstats.ID_CONTRATO_SESSION);
		ContratoDTO ct = null;
		try {
			ct = generalesBO.obtenContrato(idC);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		getSession().put(ContratoConstats.CONTRATO_SESSION, ct);

		setIdContrato(idC);
		setEstatusContrato(ct.getIdEstatus());

		clista = tituloBO.init(ct);

		tipoAmortizacion = ct.getTipoAmortizacion();
		getSession().put(ContratoConstats.LISTA_SESSION, clista);
		return SUCCESS;
	}

	public String guardarCambiosPermanente() {
		try {
			ContratoDTO ct = (ContratoDTO) getSession().get(ContratoConstats.CONTRATO_SESSION);
			tituloBO.guardarCambiosPermanente(ct);
		} catch (TituloException te) {
			logger.error("Error : ", te);
			error = te.getMessage();
		} 
		return SUCCESS;
	}

	public String descarArchivo() {
		try {
			Long idC = (Long) getSession().get(ContratoConstats.ID_CONTRATO_SESSION);
			getTitulo().setIdContrato(idC);
			byte[] bytes = tituloBO.generateExcelReport(getTitulo());
			fileInputStream = new ByteArrayInputStream(bytes);
			Date a = new Date();
			SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
			fileFileName = "plantilla-" + sdf.format(a) + ".xlsx";
			return SUCCESS;
		} catch (ExcelMapperException e) {
			logger.error("Error ", e);
			error = "Ocurrio un error al subir el documento";
			return ERROR;
		} catch (IOException e) {
			logger.error("Error ", e);
			error = "Ocurrio un error al subir el documento";
			return ERROR;
		}
	}

	public String descarArchivoErrores() {
		try {
			ContratoDTO ct = (ContratoDTO) getSession().get(ContratoConstats.CONTRATO_SESSION);
			byte[] bytes = tituloBO.buscarArchivoDeErrores(ct);
			logger.info("Encontro el archivos");
			fileInputStream = new ByteArrayInputStream(bytes);
			Date a = new Date();
			SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
			fileFileName = "errores-" + sdf.format(a) + ".xlsx";
			logger.info("Saco el nombre", fileFileName);
			return SUCCESS;
		} catch (IOException e) {
			logger.error("Error ", e);
			error = "No existe documento de errores";
			return ERROR;
		}
	}

	public String cargaMasiva() throws ExcelMapperException, IOException {
		try {
			logger.info("Type [{}] name [{}]", fileContentType, fileFileName);
			ContratoDTO ct = (ContratoDTO) getSession().get(ContratoConstats.CONTRATO_SESSION);
			Lista li = (Lista) getSession().get(ContratoConstats.LISTA_SESSION);
			logger.info("Contrato [{}]", ct);
			logger.info("Datos titulo [{}]", getTitulo());
			UsuarioDTO usuario = (UsuarioDTO) getSession().get("usuario");
			Date i = new Date();

			logger.info("{}", tipoCarga);

			TipoCargaDocumento tc = TipoCargaDocumento.parse(getTipoCarga());
			if (tc.equals(TipoCargaDocumento.COSTOS)) {
				getTitulo().setIdContrato(ct.getIdContrato());
				getTitulo().setIdLista(li.getIdLista());
			}
			respuestaExcel = tituloBO.cargaMasivaDeTitulos2(getTitulo(), ct, tc, file, fileFileName, li,
					usuario.getExpediente());
			tiposCarga = tituloBO.buscaTipoCargaDocumento(ct);

			logger.info("{}", tiposCarga);

			getSession().put(ContratoConstats.LISTA_SESSION, respuestaExcel.getLista());
			logger.info("Tiempo  titulosBO.cargaMasivaDeTitulos  [{}]", new Date().getTime() - i.getTime());
		} catch (TituloException e) {
			logger.error("Error ", e);
			error = e.getMessage();
		}
		return SUCCESS;
	}

	public String obtenTipoCargaDocumento() {
		ContratoDTO ct = (ContratoDTO) getSession().get(ContratoConstats.CONTRATO_SESSION);

		tiposCarga = tituloBO.buscaTipoCargaDocumento(ct);

		return SUCCESS;

	}

	public String getError() {
		return error;
	}

	public void setError(String error) {
		this.error = error;
	}

	public Lista getClista() {
		return clista;
	}

	public void setClista(Lista clista) {
		this.clista = clista;
	}

	public Titulo getTitulo() {
		return titulo;
	}

	public void setTitulo(Titulo titulo) {
		this.titulo = titulo;
	}

	public File getFile() {
		return file;
	}

	public void setFile(File file) {
		this.file = file;
	}

	public String getFileContentType() {
		return fileContentType;
	}

	public void setFileContentType(String fileContentType) {
		this.fileContentType = fileContentType;
	}

	public String getFileFileName() {
		return fileFileName;
	}

	public void setFileFileName(String fileFileName) {
		this.fileFileName = fileFileName;
	}

	public InputStream getFileInputStream() {
		return fileInputStream;
	}

	public void setFileInputStream(InputStream fileInputStream) {
		this.fileInputStream = fileInputStream;
	}

	public RespuestaCargaExcel getRespuestaExcel() {
		return respuestaExcel;
	}

	public void setRespuestaExcel(RespuestaCargaExcel respuestaExcel) {
		this.respuestaExcel = respuestaExcel;
	}

	public String getTipoCarga() {
		return tipoCarga;
	}

	public void setTipoCarga(String tipoCarga) {
		this.tipoCarga = tipoCarga;
	}

	public String getTipoAmortizacion() {
		return tipoAmortizacion;
	}

	public void setTipoAmortizacion(String tipoAmortizacion) {
		this.tipoAmortizacion = tipoAmortizacion;
	}

	public String getBtnAmortizacion() {
		return btnAmortizacion;
	}

	public void setBtnAmortizacion(String btnAmortizacion) {
		this.btnAmortizacion = btnAmortizacion;
	}

	public List<CatalogoDTO> getTiposCarga() {
		return tiposCarga;
	}

	public void setTiposCarga(List<CatalogoDTO> tiposCarga) {
		this.tiposCarga = tiposCarga;
	}

}
