function callActionAjax(actionRoute, jsonActionParameter, functionProcessor){
	 $.ajax({
	     url: contextPath + actionRoute,
	     type: 'POST',
	     data:  jsonActionParameter, 
		 dataType: "json",
	     success:function(response){ 
	    	 functionProcessor(response);    
	     },
	     error:function(jqXhr, textStatus, errorThrown){
	     }
	 });
	
}

function validaNuloUndefinido(variable){
	
	if( (variable === null && typeof variable === "object") ||
	    (variable === undefined && typeof variable === "undefined") ||
	    (variable === "" && typeof variable === "string")
	  ){
		return 0;
	   }else {  
		return variable;
	   }
}

function validaParametrosEntrada(estudioEleccion, mesEleccion){
	var estudioNoValida = validaNuloUndefinido(estudioEleccion);
	var mesNoValida = validaNuloUndefinido(mesEleccion);
	var fechaValida = validaFechaMesAnio(mesEleccion);

	if (estudioNoValida == 0 || mesNoValida == 0 || fechaValida == 0)
		return 0;
   	 return 1;
}


$(document).ready(function(){	

	$('#fecha').datepicker({ dateFormat: 'mm/yy' });
	$("#loadingDiv").hide();
	
	
    $('#consultaReporte').click(function() { 
    	
    	 var estudioEleccion = $('#estudioEleccion').val();
    	 var contratoEleccion = $('#contratoEleccion').val()
       	 var mesEleccion = $('#fecha').val();
    	    	
	 if (validaParametrosEntrada(estudioEleccion, mesEleccion) != 0){
	    	generaReporteAmortizacion(estudioEleccion, mesEleccion, contratoEleccion);
	 }else {
		 showError("No se ha seleccionado un valor v\u00E1lido de estudio y/o fecha o la fecha seleccionada no tiene el formato adecuado MM/YYYY");
		 }
    });
    
    
    $('#generaExcelReporte').click(function() { 
    	
    	 var estudioEleccion = $('#estudioEleccion').val();
       	 var mesEleccion = $('#fecha').val();
    	
   	 if (validaParametrosEntrada(estudioEleccion, mesEleccion) != 0){

   		var url = contextPath +'/reporte/amortizacion/excelAmortizacionCON.action?idEstudio=' + $("#estudioEleccion").val() + '&fecha='+ $("#fecha").val();
   		window.open(url);
   		 
   	 }else {
		 showError("No se ha seleccionado un valor v\u00E1lido de estudio y/o fecha o la fecha seleccionada no tiene el formato adecuado MM/YYYY");
   		 }
       	
       }); 
	
});

function llamaObtenerContratos() {
	
	
	var jsonString = '{"idEstudio" : "' + $("#estudioEleccion").val() + '"}';
	var stringJson = JSON.parse(jsonString);
    callActionAjax( "/reporte/amortizacion/obtenerContratosListado", stringJson, procesaContratos);
    
}

function procesaContratos(jsonData) {
	
	var contratos = jsonData.contratos;
	$('#contratoEleccion').find('option').remove();
	if(contratos.length > 0){

		$("#contratoEleccion").prop( "disabled", false);
		$("#contratoEleccion").append('<option value="-1">Todos</option>');
		for(var i = 0; i < contratos.length; i++) {
			cnt = contratos[i];
			$("#contratoEleccion").append('<option value="' + cnt.idContrato + '">' + cnt.numContrato + '</option>');
		}
		
	}else {
		$("#contratoEleccion").prop( "disabled", true);
	}
	
}


function validaFechaMesAnio(fecha){
	
	var fecha_valida = 0;
	
    fecha = '01/' + fecha;

	try {
	    testdate = $.datepicker.parseDate('dd/mm/yy', fecha);
	    fecha_valida = 1;

	} catch (e)
	{
		fecha_valida = 0;
	}
	
    return fecha_valida;
}


function generaReporteAmortizacion(estudio, fecha, contrato){

	  if (validaNuloUndefinido(estudio) == 0)
		  estudio = null;
	  
	  if (validaNuloUndefinido(fecha) == 0)
		  fecha = null;
	  	  
	  var jsonString = '{"idEstudio":' + estudio + ',"fecha": "' + fecha + '","idContrato":' + contrato + '}';	  
	  var stringJson = JSON.parse(jsonString);
	  $("#loadingDiv").show();
	  callActionAjax( "/reporte/amortizacion/cargaInicialReporteSAPDLA", stringJson, procesaDatosReporte);
}

function generaDetalleReporteAmortizacionContrato(contrato, fecha, estudio){
	  
	  if (validaNuloUndefinido(contrato) == 0)
		  contrato = null;
	  
	  if (validaNuloUndefinido(fecha) == 0)
		  fecha = null;
	  
	  var jsonString = '{"idContrato":' + contrato + ',"fecha": "' + fecha + '","idEstudio":' + estudio + '}';	  	  	  
	  var stringJson = JSON.parse(jsonString);	  
	  var tamanofilasTitulos = $('tr.'+contrato+'collapsed').length;
	  $("#loadingDiv").show(); 	  
	  if (tamanofilasTitulos == 0)
	     callActionAjax( "/reporte/amortizacion/cargaTitulosMontoContratoSAPDLA", stringJson, procesaDatosDetalleContrato);
}

function procesaDatosReporte(datos){
	
	var nombreTabla = "reportePagoSuscriptor";
	var nombreTablaContenedor = "facturaDetalleContainerContainer";
	var  nombreAppender = "tablaAmortizacionDetalle"; 
	
	
	var headerTablaRow = tituloReporte (nombreTabla, nombreTablaContenedor, datos.fechasRango, datos.year);
	
    $('#' + nombreAppender).append(headerTablaRow);
    
	$.each(datos.totalesMontosContratosSAPDLA, function(i, item) {
	    procesaDetalle(item);
	});
	
	$('.header').click(function(){	  
		
		 var separado = $(this).attr('id');
	     var idContrato = obtenNSplitPorSeparador(separado, "rId", 1);
		 var mesEleccion = $('#fecha').val();
		 var estudioEleccion = $('#estudioEleccion').val();
		 fHideShow(idContrato.substring(0, idContrato.length - 1));
	     	
		 if($(this).attr('search') == '0')
		 {
			 $(this).attr('search', '1');
		     generaDetalleReporteAmortizacionContrato(idContrato.substring(0, idContrato.length - 1), mesEleccion, estudioEleccion);	 
		 } else {
			
		}
	     	     
	});
	$("#loadingDiv").hide();
} 

function procesaDetalle(value ){
	var nombreTabla = "reportePagoSuscriptor";
	$.each(value, function(i, item) {
	    var fila = detalleContratoReporte(value[i], i, value[0].id);
	    $('#'+ nombreTabla + ' > tbody:last').append(fila);
	});
}

function detalleContratoReporte(objetoDetalle, num, idg){
	
    var fila = '<tr id="rId'+ idg +'' + num + '" class="header success" search="0">' ;
    if (num == 0){
	    fila = fila + '<td rowspan="2" id="rId'+ idg +'-cId0" style="vertical-align: middle;" >'+
	                     '<div><h6><strong class="text-danger" >'+
	                          objetoDetalle.descripcion +
	                     '</strong></h6></div>'+  
	                  '</td>';
    }
    
    fila = fila +  '<td id="rId'+ idg +'-cId1" class="text-right" >'+
                             '<div><h6><strong>'
                             + objetoDetalle.sistema +
                             '</strong></h6></div>'+   
	                       '</td>';
	fila = fila +  '<td id="rId'+ idg +'-cId2" class="text-right" >'+
                             '<div><h6><strong>'
                             + objetoDetalle.idBroadview +
                             '</strong></h6></div>'+   
	                       '</td>';
	fila = fila +  '<td id="rId'+ idg +'-cId3" class="text-right" >'+
                             '<div><h6><strong>'
                             + objetoDetalle.codigoSAP +
                             '</strong></h6></div>'+   
	                       '</td>';
	if (objetoDetalle.fechainicio == null){
		fila = fila +  '<td id="rId'+ idg +'-cId4" class="text-right" >'+
	                             '<div><h6><strong>-</strong></h6></div>'+   
		                       '</td>';
	}else {
		fila = fila +  '<td id="rId'+ idg +'-cId5" class="text-right" >'+
	                             '<div><h6><strong>'
	                             + objetoDetalle.fechainicio.substring(0,10) +
	                             '</strong></h6></div>'+   
		                       '</td>';
	}
	if (objetoDetalle.fechaFin == null){
		fila = fila +  '<td id="rId'+ idg +'-cId5" class="text-right" >'+
	                             '<div><h6><strong>-</strong></h6></div>'+   
		                       '</td>';
	}else{
		fila = fila +  '<td id="rId'+ idg +'-cId5" class="text-right" >'+
	                             '<div><h6><strong>'
	                             + objetoDetalle.fechaFin.substring(0,10) +
	                             '</strong></h6></div>'+   
		                       '</td>';
	}
	if(objetoDetalle.costo == null){
		var costo = parseFloat('0.0');
	}else {
		var costo = parseFloat(objetoDetalle.costo);
	}
	fila = fila +  '<td id="rId'+ idg +'-cId3" class="text-right" >'+
                             '<div><h6><strong>'
                             + costo.formatDLA() +
                             '</strong></h6></div>'+   
	                       '</td>';
	var m = parseFloat(objetoDetalle.acumuladoAnterior);
	fila = fila + '<td id="rId'+ idg +'-cId5" class="text-right" >'+
	                     '<div><h6><strong">'+
	                     m.formatDLA() 
	                     +'</strong></h6></div>'+  
	                  '</td>';
    $.each(objetoDetalle.montoMes, function(i, item) {
	    var n = parseFloat(item.monto);

            fila = fila +  '<td id="rId'+ idg +'-cId'+ (i + 6) +'" class="text-right" >'+
                             '<div><h6><strong class="text-' + item.color + '">'+
                             "" + n.formatDLA() +
                             '</strong></h6></div>'+   
	                       '</td>';
	});
	m = parseFloat(objetoDetalle.acumuladoPosterior);
	fila = fila + '<td id="rId'+ idg +'-cId5" class="text-right" >'+
	                     '<div><h6><strong>'+
	                     m.formatDLA() 
	                     +'</strong></h6></div>'+  
	                  '</td>';
	if(objetoDetalle.remanente == null){
		m = parseFloat('0.0');
	}else {
		m = parseFloat(objetoDetalle.remanente);
	}
	
	fila = fila + '<td id="rId'+ idg +'-cId5" class="text-right" >'+
	                     '<div><h6><strong>'+
	                     m.formatDLA() 
	                     +'</strong></h6></div>'+  
	                  '</td>';

    fila = fila +  '</tr>';

    return fila;
}


function tituloReporte (idNombreTabla, idNombreTablaContainer, fechas, year){
	
    var fechasTamano = fechas.length;

	 
    $('#' + idNombreTablaContainer).remove();

	var header = '<div id="'+ idNombreTablaContainer +'" >'+
	             '<table id="'+idNombreTabla +'" class="table table-striped table-hover">'+
	             '<thead>'+
		            '<tr class="encabezado" >'+
			              '<th>Estudio/Titulo</th>';
			              
			              header = header + '<th class="text-right"><div></div></th>';
			              header = header + '<th class="text-right"><div>Id Broadview</div></th>';
			              header = header + '<th class="text-right"><div>Codigo SAP</div></th>';
			              header = header + '<th class="text-right"><div>Fecha Inicio</div></th>';
			              header = header + '<th class="text-right"><div>Fecha Fin</div></th>';
			              header = header + '<th class="text-right"><div>Costo</div></th>';
			              header = header + '<th class="text-right"><div>'+ 'Acumulado' + (year - 1) + '</div></th>';
	
			              for (var i=0; i<fechasTamano; i++){  
			            	  header = header + '<th class="text-right"><div>' + fechas [i] + '</div></th>';
			              }
			              header = header +  '<th><div>Acumulado</div></th>';
			              header = header + '<th class="text-right"><div>'+ 'Acumulado' + (year + 1) + '</div></th>';
			              
			    header = header + '<th class="text-right"><div>Remanente</div></th>'+
		            '</tr>'+
	             '</thead>'+
	             '<tbody>'+
	             '</tbody>'+
                 '</table>'+
	             '</div>';
                  
	return header;
}

function procesaDatosDetalleContrato(datos){
	
	var idContrato = datos.idContrato;
	$.each(datos.totalesMontosTitulosSAPDLA, function(i, item) {
	    procesaDetalleTitulo(item, idContrato);
	});
	
	$('#rId'+ idContrato + '1').attr('search', '0');
	$("#loadingDiv").hide();
} 

function procesaDetalleTitulo(value, idContrato ){
	var nombreTabla = "reportePagoSuscriptor";
	var fila = '';
	$.each(value, function(i, item) {
	    fila = fila + detalleTitulosReporte(value[i], idContrato, i);
	});
	$('#rId'+ idContrato + '1').after(fila);
}

function detalleTitulosReporte(objetoDetalle, contrato, num){
	
	var montosPorMes = objetoDetalle.montoMes;
    var fila = '<tr id="'+ objetoDetalle.descripcion + '-' + objetoDetalle.temporada + '" class="'+contrato+'collapsed">' ;
    if (num == 0){
	    fila = fila + '<td rowspan="2" style="vertical-align: middle;" >'+
	                     '<div><h6><strong class="text-info">'+
	                          objetoDetalle.descripcion +
	                     '</strong></h6></div>'+  
	                  '</td>';
    }
	fila = fila + '<td style="vertical-align: middle;" >'+
	                     '<div><h6><strong class="text-info">'+
	                          objetoDetalle.sistema +
	                     '</strong></h6></div>'+  
	                  '</td>';
	fila = fila + '<td style="vertical-align: middle;" >'+
	                     '<div><h6><strong class="text-info">'+
	                          objetoDetalle.idBroadview +
	                     '</strong></h6></div>'+  
	                  '</td>';
	fila = fila + '<td style="vertical-align: middle;" >'+
	                     '<div><h6><strong class="text-info">'+
	                          objetoDetalle.codigoSAP +
	                     '</strong></h6></div>'+  
	                  '</td>';
	fila = fila + '<td style="vertical-align: middle;" >'+
	                     '<div><h6><strong class="text-info">-</strong></h6></div>'+  
	                  '</td>';
	fila = fila + '<td style="vertical-align: middle;" >'+
	                     '<div><h6><strong class="text-info">-</strong></h6></div>'+  
	                  '</td>';
	if(objetoDetalle.costo == null){
		var costo = parseFloat('0.0');
	}else {
		var costo = parseFloat(objetoDetalle.costo);
	}
	fila = fila +  '<td align="right" class="text-right" >'+
                             '<div><h6><strong>'
                             + costo.formatDLA() +
                             '</strong></h6></div>'+   
	                       '</td>';
	var m = parseFloat(objetoDetalle.acumuladoAnterior);
	fila = fila + '<td align="right" >'+
	                     '<div><h6><strong class="text-info">'+
	                     m.formatDLA()
	                     +'</strong></h6></div>'+  
	                  '</td>';
    $.each(objetoDetalle.montoMes, function(i, item) {
	    var n = parseFloat(item.monto);
        fila = fila +  '<td  align="right">'+
                             '<div><h6><strong class="text-' + item.color + '">'+
                             "" + n.formatDLA()  +
                             '</strong></h6></div>'+   
	                       '</td>';
	});
	m = parseFloat(objetoDetalle.acumuladoPosterior);
	fila = fila + '<td align="right" >'+
	                     '<div><h6><strong class="text-info">'+
	                     m.formatDLA()
	                     +'</strong></h6></div>'+  
	                  '</td>';
	if(objetoDetalle.remanente == null){
		m = parseFloat('0.0');
	}else {
		m = parseFloat(objetoDetalle.remanente);
	}
	m = parseFloat(objetoDetalle.remanente);
	fila = fila + '<td align="right" >'+
	                     '<div><h6><strong class="text-info">'+
	                     m.formatDLA()
	                     +'</strong></h6></div>'+  
	                  '</td>';

    fila = fila +  '</tr>';

    return fila;
}

function fHideShow( pnuId )
{
	if( $( "." + pnuId + "collapsed:visible" ).length > 0 )
		$( "." + pnuId + "collapsed" ).hide();
	else
		$( "." + pnuId + "collapsed" ).show();
}


function obtenNSplitPorSeparador(cadena, separador, nOcurrencia) {
	var ocurrencias = cadena.split(separador);
	return ocurrencias[nOcurrencia];
}