
var visualizacionesCostoPerViewController = function($scope, $filter, utileriasService) {
	
	$scope.tipoReporte = null;
	$scope.tabla = null;
	$scope.header = null;
	$scope.leidos = null;
	$scope.correctos = null;
	$scope.erroneos = null;
	$scope.principal = null;
	$scope.mensajeConfirmacion = null;
	$scope.muestraInformacion = null;
	
	var nMeses = 1;
    var actualfecha = new Date();
    var year        = (((actualfecha.getMonth() + 1) - nMeses) <= 0) ? (actualfecha.getFullYear() - 1) : actualfecha.getFullYear();
    var month       = (((actualfecha.getMonth() + 1) - nMeses) <= 0) ? (12 + ((actualfecha.getMonth() + 1) - nMeses)) : ((actualfecha.getMonth() + 1) - nMeses);
	var date =  ("00" + month).slice(-2) + '/' + year;
	
	$scope.fechaConsulta = date;
	
    $('#mes').datepicker({ dateFormat: 'mm/yy'});
    
	$scope.muestraCarga = function(fecha) {
		if($('#mes').val() == "")			    
			showError("Favor de elegir una fecha para la consulta de carga");		
		else
		    $scope.consultaCargaMensual(fecha);
	}	
	
	$scope.consultaCargaMensual = function(fecha) {
		   
    	   var parametros     = {fecha : fecha};
    	   var actionpath = '/reporte/reporteCostPerView/obtenerDatosCargaVisualizacionesMensual.action';
		   
    	   utileriasService.actionCall(actionpath, parametros).then(function(data) {		
			   
			   if(data.errorMensaje != null){
				   showError("Ha ocurrido el siguiente error: " + data.errorMensaje);	
				   $scope.muestraInformacion = false;
			   }
			   else{
				   $scope.tabla = data.visualizacionesVista.tabla;
				   $scope.header = data.visualizacionesVista.header;
				   $scope.leidos = data.visualizacionesVista.leidos;
				   $scope.correctos = data.visualizacionesVista.correctos;
				   $scope.erroneos = data.visualizacionesVista.erroneos;
				   $scope.muestraInformacion = true;
			   }

		   }, 
		   function(error){
			   $scope.muestraInformacion = false;
			   showError("Ha ocurrido el siguiente error: " + error);		
		   });
		
	};	
	
	
	$scope.abrirModal = function(fecha) {
		
		if($('#mes').val() == "")			    
			showError("Favor de elegir una fecha para la carga");		
		else {

		 	   var parametros     = {fecha : fecha};
		 	   var actionpath = '/reporte/reporteCostPerView/obtenerDatosCargaVisualizacionesPrincipal.action';
				   
		 	   utileriasService.actionCall(actionpath, parametros).then(function(data) {		
					   
					   if(data.errorMensaje != null)
						   showError("Ha ocurrido el siguiente error: " + data.errorMensaje);	
					   else {
						   $scope.principal = data.visualizacionesVista;
						   
							if ($scope.principal != null){
								$scope.mensajeConfirmacion = "Los datos ya fueron cargados para [" + utileriasService.getMes(fecha) + "]. Desea recargarlos?";
								$('#modalConfirmacion').modal('show');
							}else
								$scope.abrirModalCarga(fecha);  
					   }
					   
				   }, 
				   function(error){
					   showError("Ha ocurrido el siguiente error: " + error);		
				   });

		}

	};

	$scope.abrirModalCarga = function(fecha) {
		
		$('#modalConfirmacion').modal('hide');
		
		uploader = new FileUploader(
				 "fileUploadSection",
				 "/reporte/reporteCostPerView/cargarArchivo.action",
				 function(){ var data ={ "fecha"  : fecha }; return data; },
				 function(files,data,xhr,pd){ 
					     $("#fileUploadModal").modal("hide");  
					     if(data.errorMensaje != null)
					             showError("Ha ocurrido el siguiente error: " + data.errorMensaje);	
				         else 
				        	   $scope.consultaCargaMensual(fecha); 
								 

				  },
				 function(files,status,errMsg,pd){ showError("Ha ocurrido el siguiente error: " + errMsg); $("#fileUploadModal").modal("hide");}
				 );
		
		uploader.limpiaForma("fileUploadForm");
		$("#esperaDiv").html("");
		$("#fileUploadModal").modal("show");
	};
	
	$scope.cargarDatos = function() {
		uploader.startUpload("fileUploadSection");
	};
	
	$scope.descargaPlantilla = function() {
		var url = contextPath +'/reporte/reporteCostPerView/descargarPlantilla.action';
       
		try { window.open(url); }
	    catch(e)   { showError("Ha ocurrido el siguiente error: " + e.description); }
	}
	
	$scope.descargaVisualizaciones = function(fecha) {
		var url = contextPath +'/reporte/reporteCostPerView/descargarVisualizaciones.action?fecha=' + fecha;

		try { window.open(url); }
	    catch(e)   { showError("Ha ocurrido el siguiente error: " + e.description); }
	}
	
	$scope.cambioFechaAccion = function() {
	    $scope.muestraInformacion = false;
	}

	
}

registraController("visualizacionesCostoPerViewController", visualizacionesCostoPerViewController);
