package com.mx.dla.dda.carga.transaccion.actions;

import java.io.File;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.carga.transaccion.bos.CargaTransaccionesBO;
import com.mx.dla.dda.carga.transaccion.ws.asociarTitulosTransCntVigentes.ResponseAsociarTitTransCntVigentesDTO;
import com.mx.dla.dda.carga.transaccion.ws.procesarCargaTitulosPN.CargaPrincipalPNDTO;
import com.mx.dla.dda.carga.transaccion.ws.procesarCargaTitulosPN.ResponseCargaTitulosPNDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

public class CargaArchivoTransaccionesAction extends BaseContratoAction {

    private static final long serialVersionUID = 4698989047503278255L;

    private File file;
    private String fileContentType;
    private String fileFileName;
    private Long idCarga;
    private String mesCarga;
    private boolean exito;
    private String error;
    private String mensaje;
    private CargaPrincipalPNDTO cargaPrincipal = null;

    @Autowired
    private CargaTransaccionesBO cargaTransaccionesBO;

    //carga archivo para transacciones
    public String cargaArchivo() {
        ResponseCargaTitulosPNDTO response = null;
        ResponseAsociarTitTransCntVigentesDTO responseAsocTit = null;
        UsuarioDTO usuario = null;

        logger.info("idCarga: [{}], mesCarga [{}]", idCarga, mesCarga);//
        try {
            usuario = (UsuarioDTO) getSession().get("usuario");
            response = cargaTransaccionesBO.cargarArchivoDeTransacciones(file, fileFileName, usuario.getExpediente(), mesCarga, idCarga);

            setExito(response.isResultado());
            setMensaje(response.getMensaje());
            setCargaPrincipal(response.getDatosCarga());
            setIdCarga(response.getIdCarga());
            //si se ejecuto correctamente la carga, inicia el calculo de pago...
            if (mensaje.equals("OK")) {
                responseAsocTit = cargaTransaccionesBO.reCalculoPago(idCarga);
                logger.info("Response CalculoPago: [{}],", responseAsocTit);
            } else {
                logger.info("No entro a CalculoPago");
            }

            return SUCCESS;

        } catch (TransaccionException e) {
            error = e.getMessage();
            logger.error("Error al invocar cargaTransaccionesBO : " + error);
            return error;
        }

    }

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getFileContentType() {
        return fileContentType;
    }

    public void setFileContentType(String fileContentType) {
        this.fileContentType = fileContentType;
    }

    public String getFileFileName() {
        return fileFileName;
    }

    public void setFileFileName(String fileFileName) {
        this.fileFileName = fileFileName;
    }

    public Long getIdCarga() {
        return idCarga;
    }

    public void setIdCarga(Long idCarga) {
        this.idCarga = idCarga;
    }

    public String getMesCarga() {
        return mesCarga;
    }

    public void setMesCarga(String mesCarga) {
        this.mesCarga = mesCarga;
    }

    public boolean isExito() {
        return exito;
    }

    public void setExito(boolean exito) {
        this.exito = exito;
    }

    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getMensaje() {
        return mensaje;
    }

    public void setMensaje(String mensaje) {
        this.mensaje = mensaje;
    }

    public CargaPrincipalPNDTO getCargaPrincipal() {
        return cargaPrincipal;
    }

    public void setCargaPrincipal(CargaPrincipalPNDTO cargaPrincipal) {
        this.cargaPrincipal = cargaPrincipal;
    }

}
