package com.mx.dla.dda.contrato.generales.actions;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;

@Controller
@Scope("request")
public class EliminaContratoAction extends BaseContratoAction{
	
	private static final long serialVersionUID = 1L;
	
	private Long idContratoP;
	private boolean seElimino;
	
	@Autowired
	private GeneralesBO generalesBO;
	
	@Override
	public String execute() {
		
		logger.debug("idContrato a eliminar : [{}]", idContratoP);
		seElimino = generalesBO.eliminaContrato(idContratoP);
		logger.debug("respuesta de eliminar contrato : [{}]", seElimino);
		
		return SUCCESS;
	}
	
	public void setIdContratoP(Long idContratoP) {
		this.idContratoP = idContratoP;
	}
	
	public Long getIdContratoP() {
		return idContratoP;
	}
	
	public void setSeElimino(boolean seElimino) {
		this.seElimino = seElimino;
	}
	
	public boolean getSeElimino() {
		return seElimino;
	}
}
