package com.mx.dla.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.owasp.encoder.Encode;

public class Validaciones {
	
	private static final List<String> FORBIDDEN_WORDS = Collections.unmodifiableList(Arrays.asList("<script>","<a>","onclick"));
	
	public static String encodeString(String dato) {
		return Encode.forHtml(dato);
	}
	
	public static String[] validaListaNegra (String dato) {
		String[] respuesta = new String[2];
		respuesta[0] = "1";
		respuesta[1] = "";
		if(FORBIDDEN_WORDS.stream().anyMatch(word -> dato.contains(word.toLowerCase()))) {
			respuesta[0] = "0";
			respuesta[1] = "No es posible registrar el valor ingresado";
		}
		return respuesta;
	}
	
	public static String[] validaShort (String dato, short min, short max, int minLength, int maxLength) {
		String[] respuesta = new String[2];
		Pattern pat = Pattern.compile("^-?\\d+$"); 
		Matcher mat = pat.matcher(dato);
		Short datoShort = null;
		respuesta[1] = "";
		if (mat.matches()) { 
			respuesta[0] = "1";
			datoShort = Short.parseShort(dato);
		} else { 
			respuesta[0] = "0";
			respuesta[1] = "El valor ingresado no es de tipo short";
		}
		if(datoShort != null) {
			if(min != -1 && datoShort < min) {
				respuesta[0] = "0";
				respuesta[1] = "El valor ingresado es menor que el valor mnimo permitido";
			}
			if(max != -1 && datoShort > max) {
				respuesta[0] = "0";
				respuesta[1] = "El valor ingresado es mayor que el valor mximo permitido";
			}
			if(maxLength != -1 && dato.length() > maxLength) {
				respuesta[0] = "0";
				respuesta[1] = "La longitud del valor ingresado es mayor que la longitud mximo permitida";
			}
			if(minLength != -1 && dato.length() < minLength) {
				respuesta[0] = "0";
				respuesta[1] = "La longitud del valor ingresado es menor que la longitud mnimo permitida";
			}
		}
		return respuesta;
	}
	
	public static String[] validaInt (String dato, int min, int max, int minLength, int maxLength) {
		String[] respuesta = new String[2];
		Pattern pat = Pattern.compile("^-?\\d+$"); 
		Matcher mat = pat.matcher(dato);
		Integer datoInt = null;
		respuesta[1] = "";
		if (mat.matches()) { 
			respuesta[0] = "1";
			datoInt = Integer.parseInt(dato);
		} else { 
			respuesta[0] = "0";
			respuesta[1] = "El valor ingresado no es de tipo int";
		}
		if(datoInt != null) {
			if(min != -1 && datoInt < min) {
				respuesta[0] = "0";
				respuesta[1] = "El valor ingresado es menor que el valor mnimo permitido";
			}
			if(max != -1 && datoInt > max) {
				respuesta[0] = "0";
				respuesta[1] = "El valor ingresado es mayor que el valor mximo permitido";
			}
			if(maxLength != -1 && dato.length() > maxLength) {
				respuesta[0] = "0";
				respuesta[1] = "La longitud del valor ingresado es mayor que la longitud mximo permitida";
			}
			if(minLength != -1 && dato.length() < minLength) {
				respuesta[0] = "0";
				respuesta[1] = "La longitud del valor ingresado es menor que la longitud mnimo permitida";
			}
		}
		return respuesta;
	}
	
	public static String[] validaLong (String dato, long min, long max, int minLength, int maxLength) {
		String[] respuesta = new String[2];
		Pattern pat = Pattern.compile("^-?\\d+$"); 
		Matcher mat = pat.matcher(dato);
		Long datoLong = null;
		respuesta[1] = "";
		if (mat.matches()) { 
			respuesta[0] = "1";
			datoLong = Long.parseLong(dato);
		} else { 
			respuesta[0] = "0";
			respuesta[1] = "El valor ingresado no es de tipo long";
		}
		if(datoLong != null) {
			if(min != -1 && datoLong < min) {
				respuesta[0] = "0";
				respuesta[1] = "El valor ingresado es menor que el valor mnimo permitido";
			}
			if(max != -1 && datoLong > max) {
				respuesta[0] = "0";
				respuesta[1] = "El valor ingresado es mayor que el valor mximo permitido";
			}
			if(maxLength != -1 && dato.length() > maxLength) {
				respuesta[0] = "0";
				respuesta[1] = "La longitud del valor ingresado es mayor que la longitud mximo permitida";
			}
			if(minLength != -1 && dato.length() < minLength) {
				respuesta[0] = "0";
				respuesta[1] = "La longitud del valor ingresado es menor que la longitud mnimo permitida";
			}
		}
		return respuesta;
	}
	
	public static String[] validaDouble (String dato, double min, double max, int minLength, int maxLength) {
		String[] respuesta = new String[2];
		Pattern pat = Pattern.compile("^-?\\d+(\\.\\d+)?$"); 
		Matcher mat = pat.matcher(dato);
		Double datoDouble = null;
		respuesta[1] = "";
		if (mat.matches()) { 
			respuesta[0] = "1";
			datoDouble = Double.parseDouble(dato);
		} else { 
			respuesta[0] = "0";
			respuesta[1] = "El valor ingresado no es de tipo double";
		}
		if(datoDouble != null) {
			if(min != -1 && datoDouble < min) {
				respuesta[0] = "0";
				respuesta[1] = "El valor ingresado es menor que el valor mnimo permitido";
			}
			if(max != -1 && datoDouble > max) {
				respuesta[0] = "0";
				respuesta[1] = "El valor ingresado es mayor que el valor mximo permitido";
			}
			if(maxLength != -1 && dato.length() > maxLength) {
				respuesta[0] = "0";
				respuesta[1] = "La longitud del valor ingresado es mayor que la longitud mximo permitida";
			}
			if(minLength != -1 && dato.length() < minLength) {
				respuesta[0] = "0";
				respuesta[1] = "La longitud del valor ingresado es menor que la longitud mnimo permitida";
			}
		}
		return respuesta;
	}
	
	public static String[] validaFloat (String dato, float min, float max, int minLength, int maxLength) {
		String[] respuesta = new String[2];
		Pattern pat = Pattern.compile("^-?\\d+(\\.\\d+)?$"); 
		Matcher mat = pat.matcher(dato);
		Float datoFloat = null;
		respuesta[1] = "";
		if (mat.matches()) { 
			respuesta[0] = "1";
			datoFloat = Float.parseFloat(dato);
		} else { 
			respuesta[0] = "0";
			respuesta[1] = "El valor ingresado no es de tipo float";
		}
		if(datoFloat != null) {
			if(min != -1 && datoFloat < min) {
				respuesta[0] = "0";
				respuesta[1] = "El valor ingresado es menor que el valor mnimo permitido";
			}
			if(max != -1 && datoFloat > max) {
				respuesta[0] = "0";
				respuesta[1] = "El valor ingresado es mayor que el valor mximo permitido";
			}
			if(maxLength != -1 && dato.length() > maxLength) {
				respuesta[0] = "0";
				respuesta[1] = "La longitud del valor ingresado es mayor que la longitud mximo permitida";
			}
			if(minLength != -1 && dato.length() < minLength) {
				respuesta[0] = "0";
				respuesta[1] = "La longitud del valor ingresado es menor que la longitud mnimo permitida";
			}
		}
		return respuesta;
	}
	
	public static String[] validaString (String dato, int minLength, int maxLength) {
		String[] respuesta = new String[2];
		respuesta = validaListaNegra(dato);
		if(dato != null) {
			if(maxLength != -1 && dato.length() > maxLength) {
				respuesta[0] = "0";
				respuesta[1] = "La longitud del valor ingresado es mayor que la longitud mximo permitida";
			}
			if(minLength != -1 && dato.length() < minLength) {
				respuesta[0] = "0";
				respuesta[1] = "La longitud del valor ingresado es menor que la longitud mnimo permitida";
			}
		}
		return respuesta;
	}

}
