/*
 *  Bootstrap Color Picker Sliders - v3.0.1
 *
 *  Bootstrap 3 optimized responsive color selector with HSV, HSL, RGB and CIE-Lch (which supports human perceived lightness) selectors and color swatches.
 *  http://www.virtuosoft.eu/code/bootstrap-colorpickersliders/
 *
 *  Made by István Ujj-Mészáros
 *  Under Apache License v2.0 License
 *
 *  Requirements:  *
 *      TinyColor: https://github.com/bgrins/TinyColor/
 *
 *  Using color math algorithms from EasyRGB Web site:/
 *      http://www.easyrgb.com/index.php?X=MATH */
!function(a){"use strict";a.fn.ColorPickerSliders=function(b){return this.each(function(){function c(){"undefined"==typeof b&&(b={}),fb=a.extend({color:"hsl(342, 52%, 70%)",size:"default",placement:"auto",trigger:"focus",preventtouchkeyboardonshow:!0,title:"",hsvpanel:!1,sliders:!0,grouping:!0,swatches:["FFFFFF","C0C0C0","808080","000000","FF0000","800000","FFFF00","808000","00FF00","008000","00FFFF","008080","0000FF","000080","FF00FF","800080"],customswatches:"colorpickkersliders",connectedinput:!1,flat:!1,updateinterval:30,previewontriggerelement:!0,previewcontrasttreshold:15,previewformat:"rgb",erroneousciecolormarkers:!0,invalidcolorsopacity:1,finercierangeedges:!0,titleswatchesadd:"Add color to swatches",titleswatchesremove:"Remove color from swatches",titleswatchesreset:"Reset to default swatches",order:{},labels:{},onchange:function(){}},b),fb.order=b.hasOwnProperty("order")?a.extend({opacity:!1,hsl:!1,rgb:!1,cie:!1,preview:!1},b.order):{opacity:0,hsl:1,rgb:2,cie:3,preview:4},b.hasOwnProperty("labels")||(b.labels={}),fb.labels=a.extend({hslhue:"HSL-Hue",hslsaturation:"HSL-Saturation",hsllightness:"HSL-Lightness",rgbred:"RGB-Red",rgbgreen:"RGB-Green",rgbblue:"RGB-Blue",cielightness:"CIE-Lightness",ciechroma:"CIE-Chroma",ciehue:"CIE-hue",opacity:"Opacity",preview:"Preview"},b.labels)}function d(){kb||(kb=!0,pb=a.fn.ColorPickerSliders.detectWhichGradientIsSupported(),"filter"===pb&&(pb=!1),!pb&&a.fn.ColorPickerSliders.svgSupported()&&(pb="svg"),c(),fb.order.hasOwnProperty("preview")&&fb.order.preview!==!1||pb||(fb.order.preview=10),p(),f(),g(),P(),Q(),fb.flat&&o(),q())}function e(){n(),E(),O(),r()}function f(){mb?(yb.tiny=tinycolor(lb.val()),yb.tiny.isValid()||(yb.tiny=tinycolor(fb.color))):yb.tiny=tinycolor(fb.color),yb.hsla=yb.tiny.toHsl(),yb.rgba=yb.tiny.toRgb(),yb.hsv=yb.tiny.toHsv(),yb.cielch=a.fn.ColorPickerSliders.rgb2lch(yb.rgba)}function g(){fb.connectedinput&&(nb=fb.connectedinput instanceof jQuery?fb.connectedinput:a(fb.connectedinput))}function h(b,c){var d=tinycolor(b);return d.isValid()?(yb.tiny=d,yb.hsla=d.toHsl(),yb.rgba=d.toRgb(),yb.hsv=d.toHsv(),yb.cielch=a.fn.ColorPickerSliders.rgb2lch(yb.rgba),fb.flat||qb?(gb.removeClass("cp-unconvertible-cie-color"),O(c)):(c||Q(),P()),!0):!1}function i(a){if(!fb.flat){if(qb)return lb.popover("hide"),lb.popover("show"),void r();k(a),qb=!0}}function j(){qb=!1,l()}function k(b){if(!(hb instanceof jQuery)){switch("undefined"==typeof b&&(b=!1),hb=a('<div class="cp-popover-container"></div>').appendTo("body"),gb=a('<div class="cp-container"></div>').appendTo(hb),gb.html(m()),fb.size){case"sm":gb.addClass("cp-container-sm");break;case"lg":gb.addClass("cp-container-lg")}e(),b||x(),lb.popover({html:!0,animation:!1,trigger:"manual",title:fb.title,placement:fb.placement,container:hb,content:function(){return gb}}),lb.popover("show")}}function l(){hb.remove(),hb=null,lb.popover("destroy")}function m(){var a=[],b="";if(fb.sliders&&(fb.order.opacity!==!1&&(a[fb.order.opacity]='<div class="cp-slider cp-opacity cp-transparency"><span>'+fb.labels.opacity+'</span><div class="cp-marker"></div></div>'),fb.order.hsl!==!1&&(a[fb.order.hsl]='<div class="cp-slider cp-hslhue cp-transparency"><span>'+fb.labels.hslhue+'</span><div class="cp-marker"></div></div><div class="cp-slider cp-hslsaturation cp-transparency"><span>'+fb.labels.hslsaturation+'</span><div class="cp-marker"></div></div><div class="cp-slider cp-hsllightness cp-transparency"><span>'+fb.labels.hsllightness+'</span><div class="cp-marker"></div></div>'),fb.order.rgb!==!1&&(a[fb.order.rgb]='<div class="cp-slider cp-rgbred cp-transparency"><span>'+fb.labels.rgbred+'</span><div class="cp-marker"></div></div><div class="cp-slider cp-rgbgreen cp-transparency"><span>'+fb.labels.rgbgreen+'</span><div class="cp-marker"></div></div><div class="cp-slider cp-rgbblue cp-transparency"><span>'+fb.labels.rgbblue+'</span><div class="cp-marker"></div></div>'),fb.order.cie!==!1&&(a[fb.order.cie]='<div class="cp-slider cp-cielightness cp-transparency"><span>'+fb.labels.cielightness+'</span><div class="cp-marker"></div></div><div class="cp-slider cp-ciechroma cp-transparency"><span>'+fb.labels.ciechroma+'</span><div class="cp-marker"></div></div><div class="cp-slider cp-ciehue cp-transparency"><span>'+fb.labels.ciehue+'</span><div class="cp-marker"></div></div>'),fb.order.preview!==!1&&(a[fb.order.preview]='<div class="cp-preview cp-transparency"><input type="text" readonly="readonly"></div>')),fb.grouping&&(b+=!!fb.hsvpanel+!!(fb.sliders&&a.length>0)+!!fb.swatches>1?'<ul class="cp-pills">':'<ul class="cp-pills hidden">',fb.hsvpanel&&(b+='<li><a href="#" class="cp-pill-hsvpanel">HSV panel</a></li>'),fb.sliders&&a.length>0&&(b+='<li><a href="#" class="cp-pill-sliders">Sliders</a></li>'),fb.swatches&&(b+='<li><a href="#" class="cp-pill-swatches">Swatches</a></li>'),b+="</ul>"),fb.hsvpanel&&(b+='<div class="cp-hsvpanel"><div class="cp-hsvpanel-sv"><span></span><div class="cp-marker-point"></div></div><div class="cp-hsvpanel-h"><span></span><div class="cp-hsvmarker-vertical"></div></div><div class="cp-hsvpanel-a cp-transparency"><span></span><div class="cp-hsvmarker-vertical"></div></div></div>'),fb.sliders){b+='<div class="cp-sliders">';for(var c=0;c<a.length;c++)"undefined"!=typeof a[c]&&(b+=a[c]);b+="</div>"}return fb.swatches&&(b+='<div class="cp-swatches clearfix"><button type="button" class="add btn btn-default" title="'+fb.titleswatchesadd+'"><span class="glyphicon glyphicon-floppy-save"></span></button><button type="button" class="remove btn btn-default" title="'+fb.titleswatchesremove+'"><span class="glyphicon glyphicon-trash"></span></button><button type="button" class="reset btn btn-default" title="'+fb.titleswatchesreset+'"><span class="glyphicon glyphicon-repeat"></span></button><ul></ul></div>'),b}function n(){ib={actualswatch:!1,swatchescontainer:a(".cp-swatches",gb),swatches:a(".cp-swatches ul",gb),swatches_add:a(".cp-swatches button.add",gb),swatches_remove:a(".cp-swatches button.remove",gb),swatches_reset:a(".cp-swatches button.reset",gb),all_sliders:a(".cp-sliders, .cp-preview input",gb),hsvpanel:{sv:a(".cp-hsvpanel-sv",gb),sv_marker:a(".cp-hsvpanel-sv .cp-marker-point",gb),h:a(".cp-hsvpanel-h",gb),h_marker:a(".cp-hsvpanel-h .cp-hsvmarker-vertical",gb),a:a(".cp-hsvpanel-a span",gb),a_marker:a(".cp-hsvpanel-a .cp-hsvmarker-vertical",gb)},sliders:{hue:a(".cp-hslhue span",gb),hue_marker:a(".cp-hslhue .cp-marker",gb),saturation:a(".cp-hslsaturation span",gb),saturation_marker:a(".cp-hslsaturation .cp-marker",gb),lightness:a(".cp-hsllightness span",gb),lightness_marker:a(".cp-hsllightness .cp-marker",gb),opacity:a(".cp-opacity span",gb),opacity_marker:a(".cp-opacity .cp-marker",gb),red:a(".cp-rgbred span",gb),red_marker:a(".cp-rgbred .cp-marker",gb),green:a(".cp-rgbgreen span",gb),green_marker:a(".cp-rgbgreen .cp-marker",gb),blue:a(".cp-rgbblue span",gb),blue_marker:a(".cp-rgbblue .cp-marker",gb),cielightness:a(".cp-cielightness span",gb),cielightness_marker:a(".cp-cielightness .cp-marker",gb),ciechroma:a(".cp-ciechroma span",gb),ciechroma_marker:a(".cp-ciechroma .cp-marker",gb),ciehue:a(".cp-ciehue span",gb),ciehue_marker:a(".cp-ciehue .cp-marker",gb),preview:a(".cp-preview input",gb)},all_pills:a(".cp-pills",gb),pills:{hsvpanel:a(".cp-pill-hsvpanel",gb),sliders:a(".cp-pill-sliders",gb),swatches:a(".cp-pill-swatches",gb)}},fb.customswatches||(ib.swatches_add.hide(),ib.swatches_remove.hide(),ib.swatches_reset.hide())}function o(){fb.flat&&(mb?gb=a('<div class="cp-container"></div>').insertAfter(lb):(gb=a('<div class="cp-container"></div>'),lb.append(gb)),gb.append(m()),e(),x())}function p(){fb.connectedinput instanceof jQuery?fb.connectedinput.add(lb):fb.connectedinput=fb.connectedinput===!1?lb:a(fb.connectedinput).add(lb)}function q(){lb.on("colorpickersliders.updateColor",function(a,b){h(b)}),lb.on("colorpickersliders.show",function(){i()}),lb.on("colorpickersliders.hide",function(){j()}),fb.flat||"focus"!==fb.trigger||("undefined"==typeof lb.attr("tabindex")&&lb.attr("tabindex",-1),fb.preventtouchkeyboardonshow&&(a(lb).prop("readonly",!0).addClass("cp-preventtouchkeyboardonshow"),a(lb).on("click",function(b){qb&&(a(lb).prop("readonly",!1),b.stopPropagation())})),mb||a(lb).on("click",function(a){i(),a.stopPropagation()}),a(lb).on("focus",function(a){i(),a.stopPropagation()}),a(lb).on("blur",function(b){j(),fb.preventtouchkeyboardonshow&&a(lb).prop("readonly",!0),b.stopPropagation()})),nb&&nb.on("keyup change",function(){var b=a(this);h(b.val(),!0)})}function r(){gb.on("contextmenu",function(a){return a.preventDefault(),!1}),a(document).on("colorpickersliders.changeswatches",function(){E()}),ib.swatches.on("touchstart mousedown click","li span",function(b){var c=a(this).css("background-color");h(c),b.preventDefault()}),ib.swatches_add.on("touchstart mousedown click",function(a){H(),a.preventDefault(),a.stopPropagation()}),ib.swatches_remove.on("touchstart mousedown click",function(a){I(),a.preventDefault(),a.stopPropagation()}),ib.swatches_reset.on("touchstart touchend mousedown click",function(a){("click"===a.type||"touchend"===a.type)&&J(),a.preventDefault(),a.stopImmediatePropagation()}),ib.sliders.hue.parent().on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){sb="hue";var b=L(sb,a);K("hsla","h",3.6*b),O()}}),ib.sliders.saturation.parent().on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){sb="saturation";var b=L(sb,a);K("hsla","s",b/100),O()}}),ib.sliders.lightness.parent().on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){sb="lightness";var b=L(sb,a);K("hsla","l",b/100),O()}}),ib.sliders.opacity.parent().on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){sb="opacity";var b=L(sb,a);K("hsla","a",b/100),O()}}),ib.sliders.red.parent().on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){sb="red";var b=L(sb,a);K("rgba","r",2.55*b),O()}}),ib.sliders.green.parent().on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){sb="green";var b=L(sb,a);K("rgba","g",2.55*b),O()}}),ib.sliders.blue.parent().on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){sb="blue";var b=L(sb,a);K("rgba","b",2.55*b),O()}}),ib.hsvpanel.sv.on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){sb="hsvsv";var b=M("sv",a);K("hsv","s",b.horizontal/100),K("hsv","v",(100-b.vertical)/100),O()}}),ib.hsvpanel.h.on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){sb="hsvh";var b=M("h",a);K("hsv","h",3.6*b.vertical),O()}}),ib.hsvpanel.a.on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){sb="hsva";var b=M("a",a);K("hsv","a",(100-b.vertical)/100),O()}}),ib.sliders.cielightness.parent().on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){sb="cielightness";var b=L(sb,a);K("cielch","l",rb/100*b),O()}}),ib.sliders.ciechroma.parent().on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){sb="ciechroma";var b=L(sb,a);K("cielch","c",zb/100*b),O()}}),ib.sliders.ciehue.parent().on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){sb="ciehue";var b=L(sb,a);K("cielch","h",3.6*b),O()}}),ib.sliders.preview.on("click",function(){this.select()}),a(document).on("touchmove mousemove",function(a){sb&&((new Date).getTime()-xb>vb&&!wb?C(sb,a):B(sb,a))}),a(document).on("touchend mouseup",function(a){a.which>1||sb&&(sb=!1,a.preventDefault())}),ib.pills.hsvpanel.on("click",function(a){a.preventDefault(),y()}),ib.pills.sliders.on("click",function(a){a.preventDefault(),z()}),ib.pills.swatches.on("click",function(a){a.preventDefault(),A()}),fb.flat||hb.on("touchstart mousedown",".popover",function(a){return a.preventDefault(),a.stopPropagation(),!1})}function s(a,b){try{localStorage.setItem("cp-userdata-"+a,JSON.stringify(b))}catch(c){}}function t(a){try{var b=JSON.parse(localStorage.getItem("cp-userdata-"+a));return b}catch(c){return null}}function u(){return""!==ob?ob:(0===ib.pills.hsvpanel.length&&(ob+="_hsvpanel_"),0===ib.pills.sliders.length&&(ob+="_sliders_"),0===ib.pills.swatches.length&&(ob+="_swatches_"),ob)}function v(){return t("config_activepill"+u())}function w(a){return s("config_activepill"+u(),a)}function x(){switch(v()){case"hsvpanel":y();break;case"sliders":z();break;case"swatches":A();break;default:if(ib.pills.hsvpanel.length){y();break}if(ib.pills.sliders.length){z();break}if(ib.pills.swatches.length){A();break}}}function y(){return 0===ib.pills.hsvpanel.length?!1:(a("a",ib.all_pills).removeClass("active"),ib.pills.hsvpanel.addClass("active"),gb.removeClass("sliders-active swatches-active").addClass("hsvpanel-active"),w("hsvpanel"),O(!0),i(!0),!0)}function z(){return 0===ib.pills.sliders.length?!1:(a("a",ib.all_pills).removeClass("active"),ib.pills.sliders.addClass("active"),gb.removeClass("hsvpanel-active swatches-active").addClass("sliders-active"),w("sliders"),O(!0),i(!0),!0)}function A(){return 0===ib.pills.swatches.length?!1:(a("a",ib.all_pills).removeClass("active"),ib.pills.swatches.addClass("active"),gb.removeClass("hsvpanel-active sliders-active").addClass("swatches-active"),w("swatches"),O(!0),i(!0),!0)}function B(a,b){clearTimeout(ub),ub=setTimeout(function(){C(a,b)},vb)}function C(a,b){var c;if(wb)return void B(a,b);switch(wb=!0,xb=(new Date).getTime(),c="hsvsv"===a?M("sv",b):"hsvh"===a?M("h",b):"hsva"===a?M("a",b):L(a,b),a){case"hsvsv":K("hsv","s",c.horizontal/100),K("hsv","v",(100-c.vertical)/100);break;case"hsvh":K("hsv","h",3.6*c.vertical);break;case"hsva":K("hsv","a",(100-c.vertical)/100);break;case"hue":K("hsla","h",3.6*c);break;case"saturation":K("hsla","s",c/100);break;case"lightness":K("hsla","l",c/100);break;case"opacity":K("hsla","a",c/100);break;case"red":K("rgba","r",2.55*c);break;case"green":K("rgba","g",2.55*c);break;case"blue":K("rgba","b",2.55*c);break;case"cielightness":K("cielch","l",rb/100*c);break;case"ciechroma":K("cielch","c",zb/100*c);break;case"ciehue":K("cielch","h",3.6*c)}O(),b.preventDefault(),wb=!1}function D(){jb=[];for(var a=0;a<fb.swatches.length;a++){var b=tinycolor(fb.swatches[a]);b.isValid()&&jb.push(b.toRgbString())}}function E(){if(fb.swatches){if(fb.customswatches){var b=!1;try{b=JSON.parse(localStorage.getItem("swatches-"+fb.customswatches))}catch(c){}b?jb=b:D()}else D();if(jb instanceof Array){ib.swatches.html("");for(var d=0;d<jb.length;d++){var e=tinycolor(jb[d]);if(e.isValid()){var f=a("<span></span>").css("background-color",e.toRgbString()),g=a('<div class="btn btn-default cp-swatch"></div>');g.append(f),ib.swatches.append(a("<li></li>").append(g))}}}F()}}function F(){var b=!1;a("span",ib.swatches).filter(function(){var c=a(this).css("background-color");if(c=tinycolor(c),c.alpha=Math.round(100*c.alpha)/100,c.toRgbString()===yb.tiny.toRgbString()){b=!0;var d=a(this).parent();d.is(ib.actualswatch)||(ib.actualswatch&&ib.actualswatch.removeClass("actual"),ib.actualswatch=d,d.addClass("actual"))}}),b||ib.actualswatch&&(ib.actualswatch.removeClass("actual"),ib.actualswatch=!1),ib.actualswatch?(ib.swatches_add.prop("disabled",!0),ib.swatches_remove.prop("disabled",!1)):(ib.swatches_add.prop("disabled",!1),ib.swatches_remove.prop("disabled",!0))}function G(){localStorage.setItem("swatches-"+fb.customswatches,JSON.stringify(jb))}function H(){jb.unshift(yb.tiny.toRgbString()),G(),a(document).trigger("colorpickersliders.changeswatches")}function I(){var b=jb.indexOf(yb.tiny.toRgbString());-1!==b&&(jb.splice(b,1),G(),a(document).trigger("colorpickersliders.changeswatches"))}function J(){confirm("Do you really want to reset the swatches? All customizations will be lost!")&&(D(),G(),a(document).trigger("colorpickersliders.changeswatches"))}function K(b,c,d){switch(b){case"hsv":yb.hsv[c]=d,yb.tiny=tinycolor({h:yb.hsv.h,s:yb.hsv.s,v:yb.hsv.v,a:yb.hsv.a}),yb.rgba=yb.tiny.toRgb(),yb.hsla=yb.tiny.toHsl(),yb.cielch=a.fn.ColorPickerSliders.rgb2lch(yb.rgba);break;case"hsla":yb.hsla[c]=d,yb.tiny=tinycolor({h:yb.hsla.h,s:yb.hsla.s,l:yb.hsla.l,a:yb.hsla.a}),yb.rgba=yb.tiny.toRgb(),yb.hsv=yb.tiny.toHsv(),yb.cielch=a.fn.ColorPickerSliders.rgb2lch(yb.rgba),gb.removeClass("cp-unconvertible-cie-color");break;case"rgba":yb.rgba[c]=d,yb.tiny=tinycolor({r:yb.rgba.r,g:yb.rgba.g,b:yb.rgba.b,a:yb.hsla.a}),yb.hsla=yb.tiny.toHsl(),yb.hsv=yb.tiny.toHsv(),yb.cielch=a.fn.ColorPickerSliders.rgb2lch(yb.rgba),gb.removeClass("cp-unconvertible-cie-color");break;case"cielch":yb.cielch[c]=d,yb.rgba=a.fn.ColorPickerSliders.lch2rgb(yb.cielch),yb.tiny=tinycolor(yb.rgba),yb.hsla=yb.tiny.toHsl(),yb.hsv=yb.tiny.toHsv(),fb.erroneousciecolormarkers&&(yb.rgba.isok?gb.removeClass("cp-unconvertible-cie-color"):gb.addClass("cp-unconvertible-cie-color"))}}function L(b,c){var d=a.fn.ColorPickerSliders.calculateEventPositionPercentage(c,ib.sliders[b]);return ib.sliders[b+"_marker"].data("position",d),d}function M(b,c){var d=a.fn.ColorPickerSliders.calculateEventPositionPercentage(c,ib.hsvpanel.sv,!0);return ib.hsvpanel[b+"_marker"].data("position",d),d}function N(a){Ab=setTimeout(function(){O(a)},fb.updateinterval)}function O(a){return clearTimeout(Ab),Date.now=Date.now||function(){return+new Date},Date.now()-tb<fb.updateinterval?void N(a):("undefined"==typeof a&&(a=!1),tb=Date.now(),fb.hsvpanel===!1||fb.grouping&&"hsvpanel"!==v()||(R(),S(),T()),!fb.sliders||fb.grouping&&"sliders"!==v()||(fb.order.opacity!==!1&&X(),fb.order.hsl!==!1&&(U(),V(),W()),fb.order.rgb!==!1&&(Y(),Z(),$()),fb.order.cie!==!1&&(ab(),bb(),cb()),fb.order.preview!==!1&&db()),a||Q(),(100-yb.cielch.l)*yb.cielch.a<fb.previewcontrasttreshold?(ib.all_sliders.css("color","#000"),mb&&fb.previewontriggerelement&&lb.css("background",yb.tiny.toRgbString()).css("color","#000")):(ib.all_sliders.css("color","#fff"),mb&&fb.previewontriggerelement&&lb.css("background",yb.tiny.toRgbString()).css("color","#fff")),!fb.swatches||fb.grouping&&"swatches"!==v()||F(),fb.onchange(gb,yb),void lb.data("color",yb))}function P(){mb&&fb.previewontriggerelement&&((100-yb.cielch.l)*yb.cielch.a<fb.previewcontrasttreshold?lb.css("background",yb.tiny.toRgbString()).css("color","#000"):lb.css("background",yb.tiny.toRgbString()).css("color","#fff"))}function Q(){nb&&nb.each(function(b,c){var d=a(c),e=d.data("color-format")||fb.previewformat;switch(e){case"hex":d.val(yb.hsla.a<1?yb.tiny.toRgbString():yb.tiny.toHexString());break;case"hsl":d.val(yb.tiny.toHslString());break;case"rgb":default:d.val(yb.tiny.toRgbString())}})}function R(){ib.hsvpanel.sv.css("background",tinycolor("hsv("+yb.hsv.h+",100%,100%)").toRgbString()),ib.hsvpanel.sv_marker.css("left",100*yb.hsv.s+"%").css("top",100-100*yb.hsv.v+"%")}function S(){ib.hsvpanel.h_marker.css("top",yb.hsv.h/360*100+"%")}function T(){eb(ib.hsvpanel.a,a.fn.ColorPickerSliders.getScaledGradientStops(yb.hsla,"a",1,0,2),!0),ib.hsvpanel.a_marker.css("top",100-100*yb.hsv.a+"%")}function U(){eb(ib.sliders.hue,a.fn.ColorPickerSliders.getScaledGradientStops(yb.hsla,"h",0,360,7)),ib.sliders.hue_marker.css("left",yb.hsla.h/360*100+"%")}function V(){eb(ib.sliders.saturation,a.fn.ColorPickerSliders.getScaledGradientStops(yb.hsla,"s",0,1,2)),ib.sliders.saturation_marker.css("left",100*yb.hsla.s+"%")}function W(){eb(ib.sliders.lightness,a.fn.ColorPickerSliders.getScaledGradientStops(yb.hsla,"l",0,1,3)),ib.sliders.lightness_marker.css("left",100*yb.hsla.l+"%")}function X(){eb(ib.sliders.opacity,a.fn.ColorPickerSliders.getScaledGradientStops(yb.hsla,"a",0,1,2)),ib.sliders.opacity_marker.css("left",100*yb.hsla.a+"%")}function Y(){eb(ib.sliders.red,a.fn.ColorPickerSliders.getScaledGradientStops(yb.rgba,"r",0,255,2)),ib.sliders.red_marker.css("left",yb.rgba.r/255*100+"%")}function Z(){eb(ib.sliders.green,a.fn.ColorPickerSliders.getScaledGradientStops(yb.rgba,"g",0,255,2)),ib.sliders.green_marker.css("left",yb.rgba.g/255*100+"%")}function $(){eb(ib.sliders.blue,a.fn.ColorPickerSliders.getScaledGradientStops(yb.rgba,"b",0,255,2)),ib.sliders.blue_marker.css("left",yb.rgba.b/255*100+"%")}function _(b,c){if(1===fb.invalidcolorsopacity||!fb.finercierangeedges)return b;b.sort(function(a,b){return a.position-b.position});for(var d=[],e=1;e<b.length;e++)if(b[e].isok!==b[e-1].isok)for(var f=Math.round(b[e].position)-Math.round(b[e-1].position),g=a.fn.ColorPickerSliders.getScaledGradientStops(b[e].rawcolor,c,b[e-1].rawcolor[c],b[e].rawcolor[c],f,fb.invalidcolorsopacity,b[e-1].position,b[e].position),h=0;h<g.length;h++)if(g[h].isok!==b[e-1].isok){d.push(g[h]),h>0&&d.push(g[h-1]);break}return a.merge(d,b)}function ab(){var b=a.fn.ColorPickerSliders.getScaledGradientStops(yb.cielch,"l",0,100,10,fb.invalidcolorsopacity);b=_(b,"l"),eb(ib.sliders.cielightness,b),ib.sliders.cielightness_marker.css("left",yb.cielch.l/rb*100+"%")}function bb(){var b=a.fn.ColorPickerSliders.getScaledGradientStops(yb.cielch,"c",0,zb,5,fb.invalidcolorsopacity);b=_(b,"c"),eb(ib.sliders.ciechroma,b),ib.sliders.ciechroma_marker.css("left",yb.cielch.c/zb*100+"%")}function cb(){var b=a.fn.ColorPickerSliders.getScaledGradientStops(yb.cielch,"h",0,360,28,fb.invalidcolorsopacity);b=_(b,"h"),eb(ib.sliders.ciehue,b),ib.sliders.ciehue_marker.css("left",yb.cielch.h/360*100+"%")}function db(){ib.sliders.preview.css("background",a.fn.ColorPickerSliders.csscolor(yb.rgba));var b;switch(fb.previewformat){case"hex":b=yb.hsla.a<1?yb.tiny.toRgbString():yb.tiny.toHexString();break;case"hsl":b=yb.tiny.toHslString();break;case"rgb":default:b=yb.tiny.toRgbString()}ib.sliders.preview.val(b)}function eb(b,c,d){switch("undefined"==typeof d&&(d=!1),c.sort(function(a,b){return a.position-b.position}),pb){case"noprefix":a.fn.ColorPickerSliders.renderNoprefix(b,c,d);break;case"webkit":a.fn.ColorPickerSliders.renderWebkit(b,c,d);break;case"ms":a.fn.ColorPickerSliders.renderMs(b,c,d);break;case"svg":a.fn.ColorPickerSliders.renderSVG(b,c,d);break;case"oldwebkit":a.fn.ColorPickerSliders.renderOldwebkit(b,c,d)}}var fb,gb,hb,ib,jb,kb=!1,lb=a(this),mb=lb.is("input"),nb=!1,ob="",pb=!1,qb=!1,rb=101,sb=!1,tb=0,ub=null,vb=70,wb=!1,xb=0,yb={tiny:null,hsla:null,rgba:null,hsv:null,cielch:null},zb=144;d();var Ab})},a.fn.ColorPickerSliders.getEventCoordinates=function(a){return"undefined"!=typeof a.pageX?{pageX:a.originalEvent.pageX,pageY:a.originalEvent.pageY}:"undefined"!=typeof a.originalEvent.touches?{pageX:a.originalEvent.touches[0].pageX,pageY:a.originalEvent.touches[0].pageY}:void 0},a.fn.ColorPickerSliders.calculateEventPositionPercentage=function(b,c,d){"undefined"==typeof d&&(d=!1);var e=a.fn.ColorPickerSliders.getEventCoordinates(b),f=c.width(),g=e.pageX-c.offset().left,h=g/f*100;if(0>h&&(h=0),h>100&&(h=100),d){var i=c.height(),j=e.pageY-c.offset().top,k=j/i*100;return 0>k&&(k=0),k>100&&(k=100),{horizontal:h,vertical:k}}return h},a.fn.ColorPickerSliders.getScaledGradientStops=function(b,c,d,e,f,g,h,i){"undefined"==typeof g&&(g=1),"undefined"==typeof h&&(h=0),"undefined"==typeof i&&(i=100);for(var j=[],k=e-d,l=!0,m=0;f>m;++m){var n,o=m/(f-1),p=a.fn.ColorPickerSliders.modifyColor(b,c,o*k+d);if(1>g){var q=a.fn.ColorPickerSliders.lch2rgb(p,g);l=q.isok,n=a.fn.ColorPickerSliders.csscolor(q,g)}else n=a.fn.ColorPickerSliders.csscolor(p,g);j[m]={color:n,position:o*(i-h)+h,isok:l,rawcolor:p}}return j},a.fn.ColorPickerSliders.getGradientStopsCSSString=function(a){for(var b="",c="",d="",e=0;e<a.length;e++){var f=a[e];b+=","+f.color+" "+f.position+"%",c+=",color-stop("+f.position+"%,"+f.color+")";var g=tinycolor(f.color);d+='<stop stop-color="'+g.toHexString()+'" stop-opacity="'+g.toRgb().a+'" offset="'+f.position/100+'"/>'}return{noprefix:b,oldwebkit:c,svg:d}},a.fn.ColorPickerSliders.renderNoprefix=function(b,c,d){"undefined"==typeof d&&(d=!1);var e,f=a.fn.ColorPickerSliders.getGradientStopsCSSString(c).noprefix;e=d?"linear-gradient(to bottom":"linear-gradient(to right",e+=f+")",b.css("background-image",e)},a.fn.ColorPickerSliders.renderWebkit=function(b,c,d){"undefined"==typeof d&&(d=!1);var e,f=a.fn.ColorPickerSliders.getGradientStopsCSSString(c).noprefix;e=d?"-webkit-linear-gradient(top":"-webkit-linear-gradient(left",e+=f+")",b.css("background-image",e)},a.fn.ColorPickerSliders.renderOldwebkit=function(b,c,d){"undefined"==typeof d&&(d=!1);var e,f=a.fn.ColorPickerSliders.getGradientStopsCSSString(c).oldwebkit;e=d?"-webkit-gradient(linear, 0% 0%, 0 100%":"-webkit-gradient(linear, 0% 0%, 100% 0%",e+=f+")",b.css("background-image",e)},a.fn.ColorPickerSliders.renderMs=function(b,c,d){"undefined"==typeof d&&(d=!1);var e,f=a.fn.ColorPickerSliders.getGradientStopsCSSString(c).noprefix;e=d?"-ms-linear-gradient(to bottom":"-ms-linear-gradient(to right",e+=f+")",b.css("background-image",e)},a.fn.ColorPickerSliders.renderSVG=function(b,c,d){"undefined"==typeof d&&(d=!1);var e="",f=a.fn.ColorPickerSliders.getGradientStopsCSSString(c).svg;e=d?'<svg xmlns="http://www.w3.org/2000/svg" width="100%" height="100%" viewBox="0 0 1 1" preserveAspectRatio="none"><linearGradient id="vsgg" gradientUnits="userSpaceOnUse" x1="0" y1="0" x2="0" y2="100%">':'<svg xmlns="http://www.w3.org/2000/svg" width="100%" height="100%" viewBox="0 0 1 1" preserveAspectRatio="none"><linearGradient id="vsgg" gradientUnits="userSpaceOnUse" x1="0" y1="0" x2="100%" y2="0">',e+=f,e+='</linearGradient><rect x="0" y="0" width="1" height="1" fill="url(#vsgg)" /></svg>',e="url(data:image/svg+xml;base64,"+a.fn.ColorPickerSliders.base64encode(e)+")",b.css("background-image",e)},a.fn.ColorPickerSliders.base64encode=function(a){var b,c,d,e,f,g,h,i,j="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",k=0,l=0,m="",n=[];if(!a)return a;do b=a.charCodeAt(k++),c=a.charCodeAt(k++),d=a.charCodeAt(k++),i=b<<16|c<<8|d,e=i>>18&63,f=i>>12&63,g=i>>6&63,h=63&i,n[l++]=j.charAt(e)+j.charAt(f)+j.charAt(g)+j.charAt(h);while(k<a.length);m=n.join("");var o=a.length%3;return(o?m.slice(0,o-3):m)+"===".slice(o||3)},a.fn.ColorPickerSliders.isGoodRgb=function(a){var b=258,c=-1;return a.r>b||a.g>b||a.b>b||a.r<c||a.g<c||a.b<c?!1:(a.r=Math.min(255,a.r),a.g=Math.min(255,a.g),a.b=Math.min(255,a.b),a.r=Math.max(0,a.r),a.g=Math.max(0,a.g),a.b=Math.max(0,a.b),!0)},a.fn.ColorPickerSliders.rgb2lch=function(b){var c=a.fn.ColorPickerSliders.CIELab2CIELCH(a.fn.ColorPickerSliders.XYZ2CIELab(a.fn.ColorPickerSliders.rgb2XYZ(b)));return b.hasOwnProperty("a")&&(c.a=b.a),c},a.fn.ColorPickerSliders.lch2rgb=function(b,c){"undefined"==typeof c&&(c=1);var d=a.fn.ColorPickerSliders.XYZ2rgb(a.fn.ColorPickerSliders.CIELab2XYZ(a.fn.ColorPickerSliders.CIELCH2CIELab(b)));if(a.fn.ColorPickerSliders.isGoodRgb(d))return b.hasOwnProperty("a")&&(d.a=b.a),d.isok=!0,d;var e=a.extend({},b),f=e.c,g=-1,h=0;do++h,e.c=g+(f-g)/2,d=a.fn.ColorPickerSliders.XYZ2rgb(a.fn.ColorPickerSliders.CIELab2XYZ(a.fn.ColorPickerSliders.CIELCH2CIELab(e))),a.fn.ColorPickerSliders.isGoodRgb(d)?g=e.c:f=e.c;while(Math.abs(f-g)>.9&&100>h);return b.hasOwnProperty("a")&&(d.a=b.a),d.r=Math.max(0,d.r),d.g=Math.max(0,d.g),d.b=Math.max(0,d.b),d.r=Math.min(255,d.r),d.g=Math.min(255,d.g),d.b=Math.min(255,d.b),1>c&&(d.a=d.hasOwnProperty("a")?d.a*c:c),d.isok=!1,d},a.fn.ColorPickerSliders.modifyColor=function(b,c,d){var e=a.extend({},b);if(!b.hasOwnProperty(c))throw"Missing color property: "+c;return e[c]=d,e},a.fn.ColorPickerSliders.csscolor=function(b,c){"undefined"==typeof c&&(c=1);var d=!1,e=a.extend({},b);return e.hasOwnProperty("c")&&(e=a.fn.ColorPickerSliders.lch2rgb(e,c)),e.hasOwnProperty("h")&&(d="hsla("+e.h+","+100*e.s+"%,"+100*e.l+"%,"+e.a+")"),e.hasOwnProperty("r")&&(d=e.a<1?"rgba("+Math.round(e.r)+","+Math.round(e.g)+","+Math.round(e.b)+","+e.a+")":"rgb("+Math.round(e.r)+","+Math.round(e.g)+","+Math.round(e.b)+")"),d},a.fn.ColorPickerSliders.rgb2XYZ=function(a){var b={},c=a.r/255,d=a.g/255,e=a.b/255;return c>.04045?c=Math.pow((c+.055)/1.055,2.4):c/=12.92,d>.04045?d=Math.pow((d+.055)/1.055,2.4):d/=12.92,e>.04045?e=Math.pow((e+.055)/1.055,2.4):e/=12.92,c=100*c,d=100*d,e=100*e,b.x=.4124*c+.3576*d+.1805*e,b.y=.2126*c+.7152*d+.0722*e,b.z=.0193*c+.1192*d+.9505*e,b},a.fn.ColorPickerSliders.XYZ2CIELab=function(a){var b={},c=a.x/95.047,d=a.y/100,e=a.z/108.883;return c=c>.008856?Math.pow(c,.333333333):7.787*c+.137931034,d=d>.008856?Math.pow(d,.333333333):7.787*d+.137931034,e=e>.008856?Math.pow(e,.333333333):7.787*e+.137931034,b.l=116*d-16,b.a=500*(c-d),b.b=200*(d-e),b},a.fn.ColorPickerSliders.CIELab2CIELCH=function(a){var b={};return b.l=a.l,b.c=Math.sqrt(Math.pow(a.a,2)+Math.pow(a.b,2)),b.h=Math.atan2(a.b,a.a),b.h=b.h>0?b.h/Math.PI*180:360-Math.abs(b.h)/Math.PI*180,b},a.fn.ColorPickerSliders.CIELCH2CIELab=function(a){var b={};return b.l=a.l,b.a=Math.cos(.01745329251*a.h)*a.c,b.b=Math.sin(.01745329251*a.h)*a.c,b},a.fn.ColorPickerSliders.CIELab2XYZ=function(a){var b={};return b.y=(a.l+16)/116,b.x=a.a/500+b.y,b.z=b.y-a.b/200,b.y=Math.pow(b.y,3)>.008856?Math.pow(b.y,3):(b.y-.137931034)/7.787,b.x=Math.pow(b.x,3)>.008856?Math.pow(b.x,3):(b.x-.137931034)/7.787,b.z=Math.pow(b.z,3)>.008856?Math.pow(b.z,3):(b.z-.137931034)/7.787,b.x=95.047*b.x,b.y=100*b.y,b.z=108.883*b.z,b},a.fn.ColorPickerSliders.XYZ2rgb=function(a){var b={};return a.x=a.x/100,a.y=a.y/100,a.z=a.z/100,b.r=3.2406*a.x+-1.5372*a.y+a.z*-.4986,b.g=a.x*-.9689+1.8758*a.y+.0415*a.z,b.b=.0557*a.x+a.y*-.204+1.057*a.z,b.r=b.r>.0031308?1.055*Math.pow(b.r,.41666667)-.055:12.92*b.r,b.g=b.g>.0031308?1.055*Math.pow(b.g,.41666667)-.055:12.92*b.g,b.b=b.b>.0031308?1.055*Math.pow(b.b,.41666667)-.055:12.92*b.b,b.r=Math.round(255*b.r),b.g=Math.round(255*b.g),b.b=Math.round(255*b.b),b},a.fn.ColorPickerSliders.detectWhichGradientIsSupported=function(){var a=document.createElement("detectGradientSupport").style;try{if(a.backgroundImage="linear-gradient(to top left, #9f9, white)",-1!==a.backgroundImage.indexOf("gradient"))return"noprefix";if(a.backgroundImage="-webkit-linear-gradient(left top, #9f9, white)",-1!==a.backgroundImage.indexOf("gradient"))return"webkit";if(a.backgroundImage="-ms-linear-gradient(left top, #9f9, white)",-1!==a.backgroundImage.indexOf("gradient"))return"ms";if(a.backgroundImage="-webkit-gradient(linear, left top, right bottom, from(#9f9), to(white))",-1!==a.backgroundImage.indexOf("gradient"))return"oldwebkit"}catch(b){try{if(a.filter='progid:DXImageTransform.Microsoft.gradient(startColorstr="#ffffff",endColorstr="#000000",GradientType=0)',-1!==a.filter.indexOf("DXImageTransform"))return"filter"}catch(b){}}return!1},a.fn.ColorPickerSliders.svgSupported=function(){return!!document.createElementNS&&!!document.createElementNS("http://www.w3.org/2000/svg","svg").createSVGRect}}(jQuery);