function TitulosController(editForm, gridName) {
	this.editForm = editForm;
	this.service = new TitulosService();
	var _data = this.service.buscarTitulosPorFiltro({});
	this.grid = new TitulosGrid(gridName, _data);
	var me = this;
	this.uploader = new UploaderEX("cargaTitulosDiv" , function(data)
			{
				if(data.error == '' || data.error == null)
				{
					if(data.tipoCarga == 'N')
					{
						location.reload();
					}
					else
					{
						showMessage("El documento ["+data.fileUploadFileName+"] se a subido con exito");
						me.buscarPorFiltro();
						$('#modalCarga').modal('hide');
					}
					
				}
				else{
					showError(data.error);
					$('#modalCarga').modal('hide');
				}
			});
	this.initEditableForm();
}

TitulosController.prototype.leerForma = function(_forma) {
	var columns = this.grid.getColumns();
	var _i = {};
	var me = this;
	columns.forEach(function(column, i) {
		var _item = $("#" + _forma + "   [name='" + column.name + "']");
		var val;
		if (_item.is(':checkbox')) {
			val = _item.prop('checked');
		} 
		else if (_item.is('select')) {
			if(_item.val()!= '')
			{
				val = {};
				val["desc"] = _item.find('option:selected').text();
				val["value"] = _item.val();
			}
		} 
		else if(_item.is(':radio'))
		{
			val = _item.filter(':checked').val();
		}
		else {
			val = _item.val();
		}
		if (val !== '') {
			me.service.deepSet(_i, column.name, val);
		}
	});
	return _i;
};

TitulosController.prototype.llenarForma = function(t,_forma) {
	var columns = this.grid.getColumns();
	var me = this;
	columns.forEach(function(column, i) {
		var _item = $("#" + _forma + " [name='" + column.name + "']");
		var value = t[column.name];
		
		if (column.date  != null) {
			value = me.grid.grid.changeDateFormat(me.grid.grid.settings.dateFormatIn,
					me.grid.grid.settings.dateFormatOut, t[column.name]);
		}
		if (_item.is(':checkbox')) {
			_item.prop('checked', value);
		} else if (_item.is('select')) {
			if( typeof value != 'undefined'  && value != null )
			{
				_item.val(value.value);
			}
			
		} else if(_item.is(':radio'))
		{
			_item.filter("[value='"+value+"']" ).prop('checked', true);
		}
		else {
			_item.val(value);
		}
	});
}

TitulosController.prototype.limpiarForma = function(idForm) {
	$("#" + idForm).find(
			'input:text, input:hidden, input:password, input:file, select, textarea').val('');
	$("#" + idForm).find('input:radio, input:checkbox').removeAttr(
			'checked').removeAttr('selected');
};

TitulosController.prototype.openNewRow = function ()
{
	if ($("#idLAvalable").val() == $("#idLista").val())
	{	
		$("#fechaFin").datepicker("option", "minDate", null);
		$("#fechaInicio").datepicker("option", "maxDate", null);
		this["idFormTitulo"].resetForm();
		this.limpiarForma(this.editForm);
		$('#modalTitulo').modal('show');
	}
	else
	{
		showError("No es posible efectuar la accion");
	}
}

TitulosController.prototype.openEditRow = function(link)
{
	$("#fechaFin").datepicker("option", "minDate", null);
	$("#fechaInicio").datepicker("option", "maxDate", null);
	this["idFormTitulo"].resetForm();
	this.limpiarForma(this.editForm);
	var index = $(link).attr("name");
	var a = this.grid.getItemByIndex(index);
	this.llenarForma(a,this.editForm);
	$("#selTipoTitulo").val(a.tipoTitulo);
	$('#modalTitulo').modal('show');
}

TitulosController.prototype.openModal= function (idForm,idModal)
{
	$("#vFin").datepicker("option", "minDate", null);
	$("#vInicio").datepicker("option", "maxDate", null);
	this[idForm].resetForm();
	this.limpiarForma(idForm);
	var a = this.grid.itemsSelected();
	if(a.length == 0)
	{
		showError("Debe seleccionar minimo 1 registro");
	}
	else
	{	
		$('#'+idModal).modal('show');
	}
}

TitulosController.prototype.saveRow = function()
{
	if($("#idFormTitulo").valid())
	{
		var a = this.leerForma(this.editForm);
		if(a["idTituloCnt"] == '' || typeof a["idTituloCnt"] == 'undefined'){
			a["idLista"] =  $("#idLAvalable").val();
		}
		var indexes = [];
		indexes.push(a.idTituloCnt);
		this.save("EDITAR",a,indexes);
		$('#modalTitulo').modal('hide');	
	}
}

TitulosController.prototype.saveMultipleRow = function(idForm,modal,cambio)
{
	if($("#"+idForm).valid())
	{
		var a = this.leerForma(idForm);
		var v = this.grid.itemsSelected();
		var indexes = [];
		for(var i =0; i<v.length;i++)
		{
			indexes.push(v[i].idTituloCnt);
		}
		this.save(cambio,a,indexes);
		$('#'+modal).modal('hide');	
	}
}

TitulosController.prototype.buscarPorFiltro = function()
{
	var a = this.leerForma("idFormBusqueda");
	var _data = this.service.buscarTitulosPorFiltro(a);
	this.grid.reload(_data);
}

TitulosController.prototype.descargarArchivo = function()
{
	var a = this.leerForma("idFormBusqueda");
	this.service.descargarArchivo(a , function (ret)
			{
		
			});
}

TitulosController.prototype.save = function (tipoCambio,item,indexes)
{
	var me = this;
	var indx = "";;
	for(var i=0;i<indexes.length;i++)
	{
		if(typeof indexes[i] != 'undefined'){
			indx+=indexes[i]+","
		}
	}
	this.service.guardarTitulos(tipoCambio, item, indx, function (){
		showMessage("Datos guardados correctamente");
		me.buscarPorFiltro();
		me.cargarCatalogoTitulos();
	});
	
}

TitulosController.prototype.deleteItem = function (idForm)
{
	if($("#"+idForm).valid())
	{
		var me = this;
		var a ={};
		
		a = this.leerForma("idFormEliminar");
		this.service.eliminarTitulos(a, function () {
			$('#modalEliminar').modal('hide');
			showMessage("Datos guardados correctamente");
			me.buscarPorFiltro();
		});
	}
}

TitulosController.prototype.openDeleteItem = function (link)
{
	var index = $(link).attr("name");
	var a = this.grid.getItemByIndex(index);
	$(".descTituloElim").html(a.descTitulo);
	this["idFormEliminar"].resetForm();
	this.limpiarForma("idFormEliminar");
	this.llenarForma(a,"idFormEliminar");
	$('#modalEliminar').modal('show');
	
}

TitulosController.prototype.initEditableForm = function() {
	var me = this;
	// Inicia date pickers
	$('#fechaInicio').datepicker('option', 'onClose', function(selectedDate) {
		$("#fechaFin").datepicker("option", "minDate", selectedDate);
	});
	$('#fechaFin').datepicker('option', 'onClose', function(selectedDate) {
		$("#fechaInicio").datepicker("option", "maxDate", selectedDate);
	});
	
	$('#vInicio').datepicker('option', 'onClose', function(selectedDate) {
		$("#vFin").datepicker("option", "minDate", selectedDate);
	});
	$('#vFin').datepicker('option', 'onClose', function(selectedDate) {
		$("#vInicio").datepicker("option", "maxDate", selectedDate);
	});
	this.cargarCatalogoTitulos();
	// inicia validador de la forma
	this.idFormTitulo = $("#idFormTitulo").validate({});
	this.idFormCategoria = $("#idFormCategoria").validate({});
	this.idFormFormatos = $("#idFormFormatos").validate({});
	this.idFormVentana = $("#idFormVentana").validate({});
	this.idFormEliminar = $("#idFormEliminar").validate({});

}


TitulosController.prototype.cargarCatalogoTitulos = function() {
	// Inicia el auto completar de titulos
	var items = this.service.buscarCatalogoTitulos();
	var opts = new Bloodhound({
		datumTokenizer : Bloodhound.tokenizers.whitespace,
		queryTokenizer : Bloodhound.tokenizers.whitespace,
		local : items
	});
	$("#descTitulo").typeahead({
		hint : true,
		highlight : true,
		minLength : 1
	}, {
		name : 'Titulos',
		source : opts
	});
	$("#descTituloB").typeahead({
		hint : true,
		highlight : true,
		minLength : 1
	}, {
		name : 'Titulos',
		source : opts
	});
}

TitulosController.prototype.openCargarDocumento = function()
{
	if ($("#idLAvalable").val() == $("#idLista").val())
	{
		this.uploader.opentUploader();
	}
	else
	{
		showError("No es posible efectuar la accion");
	}
}

TitulosController.prototype.muestraFechaCarga = function(item)
{
	if($(item).val() == 'N')
	{
		$("#fechaInicioNuevaDiv").show();
	}else
	{
		$("#fechaInicioNuevaDiv").hide();
	}
}

TitulosController.prototype.startUpload = function(item)
{
	this.uploader.startUpload();
}

TitulosController.prototype.exportarBusqueda = function()
{
	var a = this.leerForma("idFormBusqueda");
	var _data = this.service.buscarTitulosPorFiltro(a);
	this.grid.reload(_data);
	this.service.descargarArchivo(a);
}

var titulosController;

$().ready(function() {

	titulosController = new TitulosController("idFormTitulo", "dyn1");
});

