package com.mx.dla.dda.admin.catalogos.apartados.daos;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.contrato.generales.dtos.ApartadoDTO;

public interface ApartadosDAO {

	public List<ApartadoDTO> getApartados();
	
	public List<ApartadoDTO> getApartadosXAmortizable(@Param("amortizable")String amortizable);
	
	public void guardarApartado(@Param("apartado")ApartadoDTO apartado, @Param("estatus")Integer estatus);
	
	public void editarApartado(@Param("apartado")ApartadoDTO apartado);
	
	public void editarSAP(@Param("apartado")ApartadoDTO apartado);
	
	public Long obtenerApartadoExistente(@Param("amortizable")String amortizable, @Param("apartado")String apartado);
	
	public void eliminarApartado(@Param("id") Long id);
}
