package com.mx.dla.dda.contrato.amortizacion.constants;

import com.mx.dla.dda.catalogos.dtos.Catalogable;

public enum TipoAmortizacion implements Catalogable{

	LINEAL("L","Lineal"),
	EXCLUSIVIDAD("E","Exclusividad")
	;
	
	private String type;
	
	private String desc;
	
	TipoAmortizacion(String type , String desc)
	{
		this.type = type;
		this.desc = desc;
	}
	
	public String getDesc() {
		return desc;
	}
	public String getType() {
		return type;
	}
	
	@Override
	public String getValue() {
		return type;
	}
	
	public static TipoAmortizacion parse(String tipo)
	{
		TipoAmortizacion [] values = TipoAmortizacion.values();
		TipoAmortizacion target = null;
		for(TipoAmortizacion t : values)
		{
			if(t.getType().equals(tipo))
			{
				target = t;
				break;
			}
		}
		return target;
		
	}
}
