package com.mx.dla.dda.contrato.generales.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;
import com.mx.dla.dda.contrato.generales.bos.TitulosBroadViewBO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.titulo.bos.TituloBO;
import com.mx.dla.dda.contrato.titulo.daos.ListaDAO;
import com.mx.dla.dda.contrato.titulo.dtos.Lista;
import com.mx.dla.dda.contrato.titulo.dtos.TituloBroadView;
import com.mx.dla.dda.contrato.titulo.dtos.TitulosContratoSap;
import com.mx.dla.dda.contrato.transaccion.titulos.bos.TituloTranBO;
import com.mx.dla.dda.contrato.ws.cargaTitulos.ParamTitulosBroadViewDTO;
import com.mx.dla.dda.contrato.ws.cargaTitulos.ResponseCargaTitulosDTO;
import com.mx.dla.dda.contrato.ws.cargaTitulos.ResponseTitulosBroadViewDTO;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;

import lombok.Data;

@Data
@Controller
@Scope("request")
public class ObtenerTitulosBroadViewAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private Long contratoBv;

	private Long contratoDda;
	
	private Long tipoContrato;

	private List<TituloBroadView> titulosBv;
	
	private List<TitulosContratoSap> titulosCnt;
	
	private String insertResponse;
	
	private String numContrato;
	
	@Autowired
	private DLARestClientFactory dlaRestClientFactory;

	@Autowired
	private TitulosBroadViewBO titulosBO;
	
	@Autowired
	private TituloBO tituloBO;
	
	@Autowired
	private TituloTranBO tituloTranBO;
	
	@Autowired
	private GeneralesBO generalesBO;
	@Autowired
	protected ListaDAO listaDAO;

	public String buscar() {
		DLARestClient c = dlaRestClientFactory.getClient(DLARestServices.TITULOS_BROAD_VIEW);
		String request = contratoBv.toString() +"?formato=oracle&contrato_dda=" + contratoDda.toString();
		ResponseTitulosBroadViewDTO response = null;
		try {
			response = c.getBv(request, ResponseTitulosBroadViewDTO.class);
		} catch (Exception e) {
			e.printStackTrace();
		}
		System.out.println("Tipo contrato: " + tipoContrato);
		logger.info("Comenzando busqueda");
		if (tipoContrato != 2) {
			titulosBO.insertaTitulosBraodView(contratoBv, contratoDda);
			setTitulosBv(titulosBO.busquedaTitulosBraodView(contratoDda));
		} else {
			titulosBO.insertaTitulosBraodViewTransac(contratoBv, contratoDda);
			setTitulosBv(titulosBO.busquedaTitulosBraodViewTransac(contratoDda));
		}
		setNumContrato(titulosBv.get(0).getContratoDda());
		logger.info("Termina insercion y busqueda");
		return SUCCESS;
	}
	
	public String insertar(){
		System.out.println("Insertando Titulos para contratoBv: " + contratoBv + " y contratoDda: " + contratoDda);
		if (tipoContrato != 2) {
			titulosBO.actualizaTitulosBroadView(contratoDda);
			ContratoDTO ct = generalesBO.obtenContrato(contratoDda);
			Lista lista = tituloBO.init(ct);
			listaDAO.updateListaTitulos(lista);
		} else {
			ContratoDTO ct = generalesBO.obtenContrato(contratoDda);
			tituloTranBO.init(ct.getIdContrato(), ct.getFechaInicio(), true);
			titulosBO.actualizaTitulosBroadViewTransac(contratoDda);
		}
		return SUCCESS;
	}
	
	public String titulosContrato() {
		setTitulosCnt(tituloBO.recuperarTitulos(contratoDda));
		setNumContrato(titulosCnt.get(0).getContratoDda());
		return SUCCESS;
	}

}
