package com.mx.dla.dda.reporte.configuracion.actions;

//import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.listado.dtos.CatListadoContratoDTO;
import com.mx.dla.dda.reporte.configuracion.bos.ConfiguracionReportesBO;
import com.mx.dla.dda.catalogos.bos.CatalogosBO;
import com.opensymphony.xwork2.Action;


public class ConfiguracionReportesAction extends BaseContratoAction {

	private static final long serialVersionUID = 21363082260499407L;

	private CatListadoContratoDTO catalogos = new CatListadoContratoDTO();
		
	private String claveReporte;
	private Long idEstudio;
	private String clavesColumnas;
	private String clavesSeleccionadas;
	
	private String mensajeExcepcion;
	
	@Autowired
	private CatalogosBO catalogosBO;
	
	@Autowired
	private ConfiguracionReportesBO reportesConfiguracionBO;
	
	public String primeraCarga(){
		return SUCCESS;
	}

	public String getCatalogosAction() {
		
		try {
						
			catalogos.setEstudios(catalogosBO.obtenListaEstudios());
									
		}catch(PersistenceException  ibe){
				setMensajeExcepcion("Ocurri un error al obtener los datos.");
				logger.error("Error.", ibe);				   			   
		}catch(Exception e){
				setMensajeExcepcion("Ocurri un error al obtener los datos.");
				logger.error("Error.", e);				   
		}		
		return Action.SUCCESS;
	}		

	
	public String guardaConfiguracion() {
		
		try {
			
			logger.info("EN action clave reporte:" + claveReporte + "| id estudio: " + idEstudio + "|claves Columnas:" + clavesColumnas.toString() );
			reportesConfiguracionBO.guardarConfiguracion( claveReporte, idEstudio, clavesColumnas );
									
		}catch(PersistenceException  ibe){
				setMensajeExcepcion("Ocurri un error al guardar los datos.");
				logger.error("Error.", ibe);				   			   
		}catch(Exception e){
				setMensajeExcepcion("Ocurri un error al guardar los datos.");
				logger.error("Error.", e);				   
		}	
		
		return Action.SUCCESS;
	}	
	
	public String consultaConfiguracion() {
		
		try {
			
			logger.info("EN action [consultaConfiguracion] clave reporte:" + claveReporte + "| id estudio: " + idEstudio );
			clavesSeleccionadas = reportesConfiguracionBO.consultaConfiguracion( claveReporte, idEstudio );
									
		}catch(PersistenceException  ibe){
				setMensajeExcepcion("Ocurri un error al consultar los datos.");
				logger.error("Error.", ibe);				   			   
		}catch(Exception e){
				setMensajeExcepcion("Ocurri un error al consultar los datos.");
				logger.error("Error.", e);				   
		}	
		
		return Action.SUCCESS;
	}	
	
	public String getClaveReporte() {
		return claveReporte;
	}

	public void setClaveReporte(String claveReporte) {
		this.claveReporte = claveReporte;
	}

	public Long getIdEstudio() {
		return idEstudio;
	}

	public void setIdEstudio(Long idEstudio) {
		this.idEstudio = idEstudio;
	}

	public String getClavesColumnas() {
		return clavesColumnas;
	}

	public void setClavesColumnas(String clavesColumnas) {
		this.clavesColumnas = clavesColumnas;
	}

	public CatListadoContratoDTO getCatalogos() {
		return catalogos;
	}

	public void setCatalogos(CatListadoContratoDTO catalogos) {
		this.catalogos = catalogos;
	}
	
	public String getClavesSeleccionadas() {
		return clavesSeleccionadas;
	}

	public void setClavesSeleccionadas(String clavesSeleccionadas) {
		this.clavesSeleccionadas = clavesSeleccionadas;
	}

	public void setMensajeExcepcion(String mensajeExcepcion) 
	{
		this.mensajeExcepcion = mensajeExcepcion;
	}
	
	public String getMensajeExcepcion() 
	{
		return mensajeExcepcion;
	}

}
