package com.mx.dla.dda.contrato.generales.daos;

import java.util.Date;
import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.catalogos.dtos.EstudioDTO;
import com.mx.dla.dda.catalogos.dtos.IndicadorDTO;
import com.mx.dla.dda.catalogos.dtos.RegistroCatalogoDTO;
import com.mx.dla.dda.contrato.generales.dtos.ApartadoDTO;
import com.mx.dla.dda.contrato.generales.dtos.AreaAutorizadorDTO;
import com.mx.dla.dda.contrato.generales.dtos.BotonDTO;
import com.mx.dla.dda.contrato.generales.dtos.FechasDTO;
import com.mx.dla.dda.contrato.generales.dtos.NumeroTitulosTransDTO;

public interface PoblarGeneralesDAO {
	
	public List<EstudioDTO> obtenerEstudios();
	
	public List<EstudioDTO> obtenerEstudiosAddons();
	
	
	public List<? extends RegistroCatalogoDTO> obtenerCategorias();
	
	public List<? extends RegistroCatalogoDTO> obtenerServiciosPorTipo(@Param("tipoContrato") Long tipoContrato);
	
	public List<? extends RegistroCatalogoDTO> obtenerTerritorios();
	
	public List<? extends RegistroCatalogoDTO> obtenerMediosEntrega();
	
	public List<? extends RegistroCatalogoDTO> obtenerFiliales();
	
	public List<? extends RegistroCatalogoDTO> obtenerTypesPorTipo(@Param("tipoContrato") Long tipoContrato);
	
	public List<? extends RegistroCatalogoDTO> obtenerCategoriasActuales(@Param("idContrato") Long idContrato);
	
	public List<? extends RegistroCatalogoDTO> obtenerServiciosActuales(@Param("idContrato") Long idContrato);
	
	public List<? extends RegistroCatalogoDTO> obtenerTerritoriosActuales(@Param("idContrato") Long idContrato);
	
	public List<? extends RegistroCatalogoDTO> obtenerMediosEntregaActuales(@Param("idContrato") Long idContrato);
	
	public List<? extends RegistroCatalogoDTO> obtenerFilialesActuales(@Param("idContrato") Long idContrato);
	
	public List<? extends RegistroCatalogoDTO> obtenerTypesActuales(@Param("idContrato") Long idContrato);
	
	public String obtenerDescripcionEstatus(@Param("idEstatus") Long idEstatus);

	public List<BotonDTO> obtenerBotones(@Param("idEstatus") Long idEstatus);
	
	public String obtenerDescripcionMovimiento(@Param("idMovimiento") Long idMovimiento);
	
	public Date obtenerFechaMinContratoTitulo(@Param("idContrato") Long idContrato);
	
	public Date obtenerFechaMaxContratoTitulo(@Param("idContrato") Long idContrato);
	
	public List<Long> obtenContratoConVirtual(@Param("idEstudio") Long idEstudio, @Param("idContrato") Long idContrato);
	
	public List<EstudioDTO> obtenerEstudioOficial();
	
	public List<ApartadoDTO> obtenerApartados(@Param("idEstudio") Long idEstudio);
	
	public FechasDTO obtenFechasContrato(@Param("idContrato") Long idContrato);
	
	public List<EstudioDTO> obtenerEstudioActual(@Param("idContrato") Long idContrato);
	
	public List<AreaAutorizadorDTO> obtenerAreaAutorizador(@Param("idContrato") Long idContrato);
	
	public Integer obtenNoCategoriaEnContratoTitulo(@Param("idCategoria") Long idCategoria, @Param("idContrato") Long idContrato);
	
	public Integer obtenNoServiciosEnContratoServicio(@Param("idServicio") Long idServicio, @Param("idContrato") Long idContrato);
	
	public List<IndicadorDTO> obtenerIndicadores();
	
	public Integer numeroTitulosEnContratoTL(@Param("idContrato") Long idContrato);
	
	public NumeroTitulosTransDTO numeroTitulosEnContratoTrans(@Param("idContrato") Long idContrato);

}
