package com.mx.dla.dda.contrato.titulo.daos;

import java.util.List;

import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Options;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.mapping.StatementType;

import com.mx.dla.dda.contrato.titulo.dtos.AmortizacionSAP;
import com.mx.dla.dda.contrato.titulo.dtos.SapNum;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;
import com.mx.dla.dda.contrato.titulos.dtos.CatTitulo;
import com.mx.dla.dda.contrato.ws.cargaTitulos.ParamCargaCostosDTO;

public interface TituloDmDAO {

	void insertarTitulo(Titulo titulo);
	void actualizarTitulo(Titulo titulo);
	void actualizarTituloVar(@Param("titulo")Titulo titulo, @Param("prefix")String prefix);
	void actualizarTituloCambio(Titulo titulo);
	void borrarTitulo (Long idTitulo);
	void borrarTitulosPorLista (Long idLista);
	void borrarTitulosPorContrato (Long idContrato);
	
	List<Titulo> buscarTitulosPorLista(Long idLista);
	List<Titulo> buscarTitulosActivosEliminadosPorLista(Long idLista);
	List<Titulo> buscarTitulosPorIdTituloOrig( @Param("idTituloCntOrig")Long idTituloCntOrig,  @Param("prefix")String prefix);
	Titulo buscarTitulo(Long idTituloCnt);
	Titulo buscarTituloEstatus( @Param("idTituloCnt")Long idTituloCnt,  @Param("estatus") String estatus);
	
	List<Titulo> buscarTituloFiltro(Titulo titulo);
	List<Titulo> buscarTituloAgrupableFiltro(Titulo titulo);
	List<Titulo> buscarTituloFiltroPaginado(Titulo titulo);
	List<Titulo> buscarTitulosTrasladados(Long idTituloCnt);	
	
	
	void insertarCatTitulo(CatTitulo catTitulo);
	
	Long cuentaTitulosPorListaYDescTitulo(@Param("idLista")Long idLista,@Param("descTitulo")String descTitulo, @Param("prefix") String prefix);
	
	CatTitulo buscarCatalogoTituloPorDesc(@Param("idEstudio")Long idEstudio,@Param("descTitulo")String descTitulo);
	Titulo buscarTitulosPorDescripcionEnLista(@Param("idLista")Long idLista,@Param("descTitulo")String descTitulo,
												@Param("temporada")String temporada,@Param("episodio")String episodio);
	
	Double buscarTotalCostoTitulos(@Param("idContrato")Long idContrato, @Param("prefix") String prefix);

	List<Long> buscarIdsPorIdCarga(@Param("idCarga")String idCarga);
	
	
	
	//Busquedas nuevas
	List<Titulo> buscaTotalesLista(@Param("idLista")Long idLista, @Param("prefix") String prefix);
	List<Titulo> buscaTotalesSerie(@Param("idLista")Long idLista , @Param("nombreUnico") String nombreUnico, @Param("prefix") String prefix);
	List<Titulo> buscaDetalleSerie(@Param("idLista")Long idLista , @Param("nombreUnico") String nombreUnico, @Param("prefix") String prefix);
	List<Titulo> buscaDetallePeliculas(@Param("idLista")Long idLista, @Param("prefix") String prefix);
	
	public void borrarRegistroSAPNUM(@Param("idTitulo")Long idTitulo);
	public void insertarSapSubnum(SapNum sapNum);
	public List<Titulo> buscaSerie1Capitulo(@Param("idLista")Long idLista, @Param("prefix") String prefix);
	
	public String buscaMaxSubNum(Long idTituloCtoOrig);
	public List<SapNum> buscaSubNumDisminucion(Long idTituloCtoOrig);
	
	public List<AmortizacionSAP> buscaMaxSubNumByFechaAmort(@Param("idTituloCtoOrig")Long idTituloCtoOrig, @Param("anio") Integer anio);
	public List<SapNum> getAumnentosSAPNUMContables(@Param("idTituloCtoOrig")Long idTituloCtoOrig, @Param("anio") Integer anio);	
	public List<SapNum>  getSAPNUMTrasladados(@Param("idTitulo")Long idTitulo);
	
	public void  actualizarSubNum(SapNum sapNum);
	public List<Titulo> buscarTitulosEnmiendaSincro(@Param("idCto")Long idCto, @Param("prefix") String prefix);
	public SapNum getAumentosDisminXTitulo(@Param("idTituloCtoOrig")Long idTituloCtoOrig, @Param("idCto")Long idCto);
	
	public List<Titulo> buscarTitulosTrasladados(@Param("idCto")Long idCto, @Param("prefix") String prefix);
	public List<SapNum> getAumentosSapNumXTitulo(@Param("IdTituloCnt")Long IdTituloCnt, @Param("idCto")Long idCto);
	
	public void actualizarCostos(@Param("precio")String precios, @Param("idbv")String idbvs);
	
}
