package com.mx.dla.dda.admin.catalogos.materiales.actions;

import java.util.ArrayList;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.admin.catalogos.materiales.daos.CatalogoMaterialesDAO;
import com.mx.dla.dda.admin.catalogos.materiales.dtos.CatalogoMaterialDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.global.actions.BaseAction;

public class CatalogoMaterialesAction extends BaseAction {

	private static final long serialVersionUID = -4856342072710036099L;
	private static Logger log = Logger.getLogger(CatalogoMaterialesAction.class);
	private List<CatalogoMaterialDTO> catalogoMateriales;
	@Autowired
	private CatalogoMaterialesDAO catalogoMaterialesDAO;

	@Override
	public String execute() {

		return SUCCESS;
	}

	public String listadoMateriales() throws TransaccionException {

		try {

			catalogoMateriales = new ArrayList<CatalogoMaterialDTO>();
			catalogoMateriales = catalogoMaterialesDAO.catalogoMateriales();
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		log.info("Catalogo de materiales");
		return "catalogoMaterialesLista";
	}

	/**
	 * @return the catalogoMateriales
	 */
	public List<CatalogoMaterialDTO> getCatalogoMateriales() {
		return catalogoMateriales;
	}

	/**
	 * @param catalogoMateriales the catalogoEstudios to set
	 */
	public void setCatalogoMateriales(List<CatalogoMaterialDTO> catalogoMateriales) {
		this.catalogoMateriales = catalogoMateriales;
	}

}
