/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.event;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.GenericApplicationListenerAdapter;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.OrderComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractApplicationEventMulticaster
implements ApplicationEventMulticaster,
BeanFactoryAware {
    private final ListenerRetriever defaultRetriever = new ListenerRetriever(false);
    private final Map<ListenerCacheKey, ListenerRetriever> retrieverCache = new ConcurrentHashMap<ListenerCacheKey, ListenerRetriever>();
    private BeanFactory beanFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApplicationListener(ApplicationListener listener) {
        ListenerRetriever listenerRetriever = this.defaultRetriever;
        synchronized (listenerRetriever) {
            this.defaultRetriever.applicationListeners.add(listener);
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApplicationListenerBean(String listenerBeanName) {
        ListenerRetriever listenerRetriever = this.defaultRetriever;
        synchronized (listenerRetriever) {
            this.defaultRetriever.applicationListenerBeans.add(listenerBeanName);
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplicationListener(ApplicationListener listener) {
        ListenerRetriever listenerRetriever = this.defaultRetriever;
        synchronized (listenerRetriever) {
            this.defaultRetriever.applicationListeners.remove(listener);
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplicationListenerBean(String listenerBeanName) {
        ListenerRetriever listenerRetriever = this.defaultRetriever;
        synchronized (listenerRetriever) {
            this.defaultRetriever.applicationListenerBeans.remove(listenerBeanName);
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllListeners() {
        ListenerRetriever listenerRetriever = this.defaultRetriever;
        synchronized (listenerRetriever) {
            this.defaultRetriever.applicationListeners.clear();
            this.defaultRetriever.applicationListenerBeans.clear();
            this.retrieverCache.clear();
        }
    }

    public final void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    private BeanFactory getBeanFactory() {
        if (this.beanFactory == null) {
            throw new IllegalStateException("ApplicationEventMulticaster cannot retrieve listener beans because it is not associated with a BeanFactory");
        }
        return this.beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ApplicationListener> getApplicationListeners() {
        ListenerRetriever listenerRetriever = this.defaultRetriever;
        synchronized (listenerRetriever) {
            return this.defaultRetriever.getApplicationListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ApplicationListener> getApplicationListeners(ApplicationEvent event) {
        LinkedHashSet<String> listenerBeans;
        LinkedHashSet<ApplicationListener> listeners;
        Class<?> sourceType;
        Class<?> eventType = event.getClass();
        ListenerCacheKey cacheKey = new ListenerCacheKey(eventType, sourceType = event.getSource().getClass());
        ListenerRetriever retriever = this.retrieverCache.get(cacheKey);
        if (retriever != null) {
            return retriever.getApplicationListeners();
        }
        retriever = new ListenerRetriever(true);
        LinkedList<ApplicationListener> allListeners = new LinkedList<ApplicationListener>();
        ListenerRetriever listenerRetriever = this.defaultRetriever;
        synchronized (listenerRetriever) {
            listeners = new LinkedHashSet<ApplicationListener>(this.defaultRetriever.applicationListeners);
            listenerBeans = new LinkedHashSet<String>(this.defaultRetriever.applicationListenerBeans);
        }
        for (ApplicationListener listener : listeners) {
            if (!this.supportsEvent(listener, eventType, sourceType)) continue;
            retriever.applicationListeners.add(listener);
            allListeners.add(listener);
        }
        if (!listenerBeans.isEmpty()) {
            BeanFactory beanFactory = this.getBeanFactory();
            for (String listenerBeanName : listenerBeans) {
                ApplicationListener listener = (ApplicationListener)beanFactory.getBean(listenerBeanName, ApplicationListener.class);
                if (allListeners.contains(listener) || !this.supportsEvent(listener, eventType, sourceType)) continue;
                retriever.applicationListenerBeans.add(listenerBeanName);
                allListeners.add(listener);
            }
        }
        OrderComparator.sort(allListeners);
        this.retrieverCache.put(cacheKey, retriever);
        return allListeners;
    }

    protected boolean supportsEvent(ApplicationListener listener, Class<? extends ApplicationEvent> eventType, Class sourceType) {
        SmartApplicationListener smartListener;
        SmartApplicationListener smartApplicationListener = smartListener = listener instanceof SmartApplicationListener ? (SmartApplicationListener)listener : new GenericApplicationListenerAdapter(listener);
        return smartListener.supportsEventType(eventType) && smartListener.supportsSourceType(sourceType);
    }

    private static class ListenerCacheKey {
        private final Class eventType;
        private final Class sourceType;

        public ListenerCacheKey(Class eventType, Class sourceType) {
            this.eventType = eventType;
            this.sourceType = sourceType;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            ListenerCacheKey otherKey = (ListenerCacheKey)other;
            return this.eventType.equals(otherKey.eventType) && this.sourceType.equals(otherKey.sourceType);
        }

        public int hashCode() {
            return this.eventType.hashCode() * 29 + this.sourceType.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListenerRetriever {
        public final Set<ApplicationListener> applicationListeners = new LinkedHashSet<ApplicationListener>();
        public final Set<String> applicationListenerBeans = new LinkedHashSet<String>();
        private final boolean preFiltered;

        public ListenerRetriever(boolean preFiltered) {
            this.preFiltered = preFiltered;
        }

        public Collection<ApplicationListener> getApplicationListeners() {
            LinkedList<ApplicationListener> allListeners = new LinkedList<ApplicationListener>();
            for (ApplicationListener listener : this.applicationListeners) {
                allListeners.add(listener);
            }
            if (!this.applicationListenerBeans.isEmpty()) {
                BeanFactory beanFactory = AbstractApplicationEventMulticaster.this.getBeanFactory();
                for (String listenerBeanName : this.applicationListenerBeans) {
                    ApplicationListener listener = (ApplicationListener)beanFactory.getBean(listenerBeanName, ApplicationListener.class);
                    if (!this.preFiltered && allListeners.contains(listener)) continue;
                    allListeners.add(listener);
                }
            }
            OrderComparator.sort(allListeners);
            return allListeners;
        }
    }
}

