/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.bdeal.bos;

import com.mx.dla.dda.contrato.bdeal.daos.BdealDAO;
import com.mx.dla.dda.contrato.bdeal.dtos.ErrorCargaDTO;
import com.mx.dla.dda.contrato.bdeal.dtos.TituloBdealDTO;
import com.mx.dla.dda.contrato.generales.enums.MensajeTexto;
import com.mx.dla.dda.contrato.ws.actualizaridbroadview.ParamActualizaIdBVDTO;
import com.mx.dla.dda.contrato.ws.actualizaridbroadview.ResponseActualizaIdBVDTO;
import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.context.ExcelMapperContext;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BdealBO
extends BaseBO {
    @Value(value="${uri.file.carga.broadview}")
    private String uriCarga;
    @Autowired
    protected ExcelMapperTransform excelMapperTransform;
    @Autowired
    private ExcelMapperContext excelMapperContext;
    @Autowired
    private BdealDAO bdealDAO;
    @Autowired
    private DLARestClientFactory dlaRestClientFactory;

    public ResponseActualizaIdBVDTO guardaDocumento(File fileUpload, String fileName, Long idContrato, String expediente) throws IOException {
        ParamActualizaIdBVDTO request = new ParamActualizaIdBVDTO();
        ResponseActualizaIdBVDTO response = null;
        DLARestClient client = null;
        try {
            boolean validado = this.excelMapperTransform.validateHeader(fileUpload, "tituloBdeal");
            this.logger.debug("validado : [{}]", (Object)validado);
            if (validado) {
                String nombreArchivo = this.uriCarga + idContrato + expediente + fileName;
                fileName = idContrato + expediente + fileName;
                byte[] file = FileUtils.readFileToByteArray((File)fileUpload);
                File d = new File(nombreArchivo);
                this.logger.debug("cadena nombrearchivo: : [{}]", (Object)nombreArchivo);
                this.logger.debug("uriCarga: : [{}]", (Object)this.uriCarga);
                d.setExecutable(true, false);
                d.setReadable(true, false);
                d.setWritable(true, false);
                this.logger.debug("Absolute path [{}]  -  [{}]", (Object)d.getCanonicalPath(), (Object)d.getPath());
                FileUtils.writeByteArrayToFile((File)d, (byte[])file);
                this.logger.debug("objeto file : [{}]", (Object)file);
                this.logger.debug("objeto d : [{}]", (Object)d);
                client = this.dlaRestClientFactory.getClient(DLARestServices.ACTUALIZAR_ID_BROADVIEW);
                request.setNombreArchivo(idContrato + expediente + fileName);
                request.setExpediente(expediente);
                request.setIdContratoActual(idContrato.toString());
                this.logger.debug("request : [{}]", (Object)request);
                this.logger.debug("client!!! : [{}]", (Object)client);
                response = client.get(request, ResponseActualizaIdBVDTO.class);
                this.logger.debug("response : [{}]", (Object)response);
            } else {
                response = new ResponseActualizaIdBVDTO();
                response.setResultado(false);
                response.setMensaje(MensajeTexto.ERROR_AL_CARGAR.getTexto());
            }
        }
        catch (Exception ex) {
            this.logger.error("Error: [{}]", (Throwable)ex);
            this.logger.debug("Error: [{}]", (Throwable)ex);
        }
        return response;
    }

    public InputStream seleccionaTipoDescarga(String tipo, Long id) {
        ByteArrayInputStream descarga = null;
        byte[] data = null;
        data = tipo.equals("titulos") ? this.exportarTitulosBdeal(id) : this.exportarErroresCarga(id);
        descarga = new ByteArrayInputStream(data);
        return descarga;
    }

    public byte[] exportarTitulosBdeal(Long idContrato) {
        this.logger.info("idContrato : [{}]", (Object)idContrato);
        byte[] bytesExcel = null;
        List titulosBdeal = null;
        ExcelMapper mapper = null;
        try {
            titulosBdeal = this.bdealDAO.obtenTituloBdeal(idContrato);
            if (titulosBdeal.size() == 0) {
                titulosBdeal.add(new TituloBdealDTO());
            }
            mapper = this.excelMapperContext.getExcelMapper("tituloBdeal");
            bytesExcel = this.excelMapperTransform.transformObjectToExcel(titulosBdeal, mapper, TituloBdealDTO.class);
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
        return bytesExcel;
    }

    public byte[] exportarErroresCarga(Long idCarga) {
        byte[] bytesExcel = null;
        List errores = null;
        ExcelMapper mapper = null;
        try {
            errores = this.bdealDAO.obtenErrorCarga(idCarga);
            if (errores.size() == 0) {
                errores.add(new ErrorCargaDTO());
            }
            mapper = this.excelMapperContext.getExcelMapper("erroresCargaBdeal");
            bytesExcel = this.excelMapperTransform.transformObjectToExcel(errores, mapper, ErrorCargaDTO.class);
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
        return bytesExcel;
    }
}

