/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.config;

import org.mybatis.spring.mapper.ClassPathMapperScanner;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class MapperScannerBeanDefinitionParser
implements BeanDefinitionParser {
    private static String ATTRIBUTE_BASE_PACKAGE = "base-package";
    private static String ATTRIBUTE_ANNOTATION = "annotation";
    private static String ATTRIBUTE_MARKER_INTERFACE = "marker-interface";
    private static String ATTRIBUTE_NAME_GENERATOR = "name-generator";
    private static String ATTRIBUTE_TEMPLATE_REF = "template-ref";
    private static String ATTRIBUTE_FACTORY_REF = "factory-ref";

    public synchronized BeanDefinition parse(Element element, ParserContext parserContext) {
        ClassPathMapperScanner scanner = new ClassPathMapperScanner(parserContext.getRegistry());
        ClassLoader classLoader = scanner.getResourceLoader().getClassLoader();
        XmlReaderContext readerContext = parserContext.getReaderContext();
        scanner.setResourceLoader(readerContext.getResourceLoader());
        try {
            String nameGeneratorClassName;
            String markerInterfaceClassName;
            String annotationClassName = element.getAttribute(ATTRIBUTE_ANNOTATION);
            if (StringUtils.hasText((String)annotationClassName)) {
                Class<?> markerInterface = classLoader.loadClass(annotationClassName);
                scanner.setAnnotationClass(markerInterface);
            }
            if (StringUtils.hasText((String)(markerInterfaceClassName = element.getAttribute(ATTRIBUTE_MARKER_INTERFACE)))) {
                Class<?> markerInterface = classLoader.loadClass(markerInterfaceClassName);
                scanner.setMarkerInterface(markerInterface);
            }
            if (StringUtils.hasText((String)(nameGeneratorClassName = element.getAttribute(ATTRIBUTE_NAME_GENERATOR)))) {
                Class<?> nameGeneratorClass = classLoader.loadClass(nameGeneratorClassName);
                BeanNameGenerator nameGenerator = (BeanNameGenerator)BeanUtils.instantiateClass(nameGeneratorClass, BeanNameGenerator.class);
                scanner.setBeanNameGenerator(nameGenerator);
            }
        }
        catch (Exception ex) {
            readerContext.error(ex.getMessage(), readerContext.extractSource((Object)element), ex.getCause());
        }
        String sqlSessionTemplateBeanName = element.getAttribute(ATTRIBUTE_TEMPLATE_REF);
        scanner.setSqlSessionTemplateBeanName(sqlSessionTemplateBeanName);
        String sqlSessionFactoryBeanName = element.getAttribute(ATTRIBUTE_FACTORY_REF);
        scanner.setSqlSessionFactoryBeanName(sqlSessionFactoryBeanName);
        scanner.registerFilters();
        String basePackage = element.getAttribute(ATTRIBUTE_BASE_PACKAGE);
        scanner.scan(StringUtils.tokenizeToStringArray((String)basePackage, (String)",; \t\n"));
        return null;
    }
}

