/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.fees.bos;

import com.mx.dla.dda.contrato.fees.daos.FeesContratoDAO;
import com.mx.dla.dda.contrato.fees.dtos.FeesContratoPagoBD;
import com.mx.dla.dda.contrato.fees.dtos.FeesContratoPagoDTO;
import com.mx.dla.dda.contrato.fees.dtos.FeesFlatBD;
import com.mx.dla.dda.contrato.fees.dtos.FeesPagoFlat;
import com.mx.dla.dda.contrato.fees.dtos.FeesSuscriptorBD;
import com.mx.dla.dda.contrato.fees.dtos.PagoFlatAnioDTO;
import com.mx.dla.dda.contrato.minimoseleccion.bos.MinimoSeleccionBO;
import com.mx.dla.global.bos.BaseBO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FeesFlatBO
extends BaseBO {
    @Autowired
    private FeesContratoDAO feesContratoDAO;
    @Autowired
    private MinimoSeleccionBO minimoSeleccionBO;
    private int ANIO_FLAT = 6;

    public FeesContratoPagoDTO crearFlat(FeesContratoPagoBD pagoBD, List<FeesFlatBD> feeBD) throws ParseException {
        FeesContratoPagoDTO fee = new FeesContratoPagoDTO();
        int numAnios = this.ANIO_FLAT;
        if (feeBD == null) {
            ArrayList<FeesPagoFlat> flats = new ArrayList<FeesPagoFlat>();
            flats.add(new FeesPagoFlat(Long.valueOf(0L), "", Integer.valueOf(numAnios)));
            fee = new FeesContratoPagoDTO(Long.valueOf(-1L), Long.valueOf(0L), Long.valueOf(0L), "", "", "", "", "nuevo", null, flats);
            fee.setFlats(flats);
            fee.setMaxAnios(Integer.valueOf(numAnios));
        } else {
            ArrayList<FeesPagoFlat> flats = new ArrayList<FeesPagoFlat>();
            for (FeesFlatBD itemBD : feeBD) {
                boolean existente = false;
                for (FeesPagoFlat item : flats) {
                    if (item.getIdCategoria().longValue() != itemBD.getIdCategoria().longValue()) continue;
                    item.getAnios().add(new PagoFlatAnioDTO(itemBD.getIdFlat(), itemBD.getAnio(), itemBD.getCosto()));
                    existente = true;
                }
                if (existente) continue;
                FeesPagoFlat pago = new FeesPagoFlat(itemBD.getIdCategoria(), itemBD.getDesCategoria(), Integer.valueOf(0));
                pago.getAnios().add(new PagoFlatAnioDTO(itemBD.getIdFlat(), itemBD.getAnio(), itemBD.getCosto()));
                flats.add(pago);
            }
            numAnios = ((FeesPagoFlat)flats.get(0)).getAnios().size();
            fee = new FeesContratoPagoDTO(pagoBD.getIdContratoPago(), pagoBD.getIdContrato(), pagoBD.getIdTipoSuscriptor(), this.getFecha(pagoBD.getFechaInicio()), this.getFecha(pagoBD.getFechaFin()), pagoBD.getTipoAnio(), pagoBD.getTipoPago(), "editar", null, flats);
            fee.setMaxAnios(Integer.valueOf(numAnios));
            fee.setAnioContrato(pagoBD.getAnioContrato());
        }
        return fee;
    }

    public void guardarFlat(FeesContratoPagoDTO periodo, Long idContrato) throws ParseException, Exception {
        FeesContratoPagoBD contratoPago = new FeesContratoPagoBD(Long.valueOf(0L), idContrato, periodo.getIdSuscriptor(), periodo.getTipoPago(), periodo.getTipoAnio(), this.crearFecha(periodo.getFechaInicio()), this.crearFecha(periodo.getFechaFin()));
        contratoPago.setAnioContrato(periodo.getAnioContrato());
        this.feesContratoDAO.guardarContratoPago(contratoPago);
        this.guardarFlat(periodo, contratoPago);
    }

    public void guardarFlat(FeesContratoPagoDTO periodo, FeesContratoPagoBD contratoPago) throws ParseException {
        ArrayList<FeesSuscriptorBD> minSelAnio = new ArrayList<FeesSuscriptorBD>();
        ArrayList<FeesSuscriptorBD> minSelCat = new ArrayList<FeesSuscriptorBD>();
        ArrayList<FeesFlatBD> flats = new ArrayList<FeesFlatBD>();
        boolean primero = true;
        for (FeesPagoFlat flat : periodo.getFlats()) {
            for (PagoFlatAnioDTO anio : flat.getAnios()) {
                if (primero) {
                    minSelAnio.add(new FeesSuscriptorBD(contratoPago.getIdContratoPago(), Integer.valueOf(anio.getAnio())));
                }
                flats.add(new FeesFlatBD(Long.valueOf(0L), contratoPago.getIdContratoPago(), flat.getIdCategoria(), Integer.valueOf(anio.getAnio()), anio.getCosto()));
                minSelCat.add(new FeesSuscriptorBD(contratoPago.getIdContratoPago(), Integer.valueOf(anio.getAnio()), flat.getIdCategoria()));
            }
            primero = false;
        }
        this.minimoSeleccionBO.guardarMinSeleccionXAnio(minSelAnio);
        this.logger.info("Se ha guardado minimo sel por anio");
        this.feesContratoDAO.guardarPagoFlatAll(flats);
        this.logger.info("Se ha guardado los pagos flats. " + ((Object)flats).toString());
        this.minimoSeleccionBO.guardarMinSeleccionXCatAnio(minSelCat);
        this.logger.info("Se ha guardado el minimo sel." + ((Object)minSelCat).toString());
    }

    public void editarFlat(FeesContratoPagoDTO periodo) throws ParseException, Exception {
        this.logger.info("Se edita flat.");
        FeesContratoPagoBD contratoPago = new FeesContratoPagoBD(periodo.getIdContratoPago(), periodo.getIdContrato(), periodo.getIdSuscriptor(), periodo.getTipoPago(), periodo.getTipoAnio(), this.crearFecha(periodo.getFechaInicio()), this.crearFecha(periodo.getFechaFin()));
        contratoPago.setAnioContrato(periodo.getAnioContrato());
        this.feesContratoDAO.actualizarContratoPago(contratoPago);
        this.guardarFlat(periodo, contratoPago);
    }

    public void eliminarFlats(Long idContrato) {
        this.eliminarPagosFlat(idContrato);
        this.minimoSeleccionBO.eliminarMinSeleccionXCto(idContrato);
        this.feesContratoDAO.eliminarContratoPagoXCto(idContrato);
    }

    public void eliminarFlat(FeesContratoPagoDTO periodo) {
        this.feesContratoDAO.eliminarPagoFlat(periodo.getIdContratoPago());
        this.minimoSeleccionBO.eliminarMinSeleccion(periodo.getIdContratoPago(), null);
        this.feesContratoDAO.eliminarContratoPago(periodo.getIdContratoPago());
    }

    public void eliminarPagosFlat(Long idContrato) {
        this.feesContratoDAO.eliminarPagoFlatxCto(idContrato);
        this.minimoSeleccionBO.eliminarMinSeleccionXCto(idContrato);
        this.logger.info("Se han eliminado los pago flat");
    }

    public Date crearFecha(String valor) throws ParseException {
        SimpleDateFormat formatter1 = new SimpleDateFormat("MM/dd/yyyy");
        Date fecha = formatter1.parse(valor);
        return fecha;
    }

    public String getFecha(Date fecha) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        return sdf.format(fecha);
    }
}

