/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.reporte.cpview.bos;

import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.constants.ExcelMapperDataType;
import com.mx.dla.dda.excelMapper.context.ExcelMapperContext;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.excelMapper.dtos.ExcelRule;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.dda.general.constants.MesesAnio;
import com.mx.dla.dda.general.utilerias.FechaUtilerias;
import com.mx.dla.dda.reporte.amortizacion.baseActivos.bos.BaseActivosBO;
import com.mx.dla.dda.reporte.cpview.daos.ReporteCostPerViewDAO;
import com.mx.dla.dda.reporte.cpview.dtos.CargaVisualizacionesDetalleDTO;
import com.mx.dla.dda.reporte.cpview.dtos.CargaVisualizacionesPrincipalDTO;
import com.mx.dla.dda.reporte.cpview.dtos.CostPerViewEstudioAnualDatosDTO;
import com.mx.dla.dda.reporte.cpview.dtos.CostPerViewEstudioMensualDatosDTO;
import com.mx.dla.dda.reporte.cpview.dtos.ParamCargaTitulosVSDTO;
import com.mx.dla.dda.reporte.cpview.dtos.ReporteCostPerViewVistaDTO;
import com.mx.dla.dda.reporte.cpview.dtos.ResponseCargaTitulosVSDTO;
import com.mx.dla.dda.reporte.cpview.dtos.VisualizacionesCostPerViewVistaDTO;
import com.mx.dla.dda.reporte.cpview.exception.ReportCostPerViewException;
import com.mx.dla.dda.reporte.ws.dtos.ResponseGeneraReporteDTO;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;
import com.mx.dla.global.bos.CustomResourceLoader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ReporteCostoPerViewBO
extends BaseBO {
    @Autowired
    private ReporteCostPerViewDAO reporteCostPerViewDAO;
    @Autowired
    protected ExcelMapperTransform excelMapperTransform;
    @Autowired
    private ExcelMapperContext excelMapperContext;
    @Autowired
    private DLARestClientFactory dlaRestClientFactory;
    @Value(value="${uri.file.carga.visualizaciones}")
    private String uriCarga;
    @Autowired
    private CustomResourceLoader customResourceLoader;
    @Autowired
    private BaseActivosBO baseActivosBO;
    @Value(value="${uri.file.reporte.baseActivosSQL}")
    protected String uriSQL;
    @Value(value="${uri.file.reporte.txtcpv}")
    protected String uriTXT;

    public String[][] obtenReporteMensualTabla(Long anio, Long mes, Long idEstudio, String nombreUnico, String temporada, Boolean consulta) throws IllegalArgumentException, IllegalAccessException {
        String[][] tabla = null;
        int tamanio = 3 * mes.intValue() + 1;
        Comparator<CostPerViewEstudioMensualDatosDTO> comparator = new Comparator<CostPerViewEstudioMensualDatosDTO>(){

            @Override
            public int compare(CostPerViewEstudioMensualDatosDTO o1, CostPerViewEstudioMensualDatosDTO o2) {
                return o1.getEstudio().compareTo(o2.getEstudio());
            }
        };
        List datos = null;
        List diciembre = null;
        if (idEstudio == null) {
            if (consulta.booleanValue()) {
                datos = this.reporteCostPerViewDAO.obtenerCostPerViewMensualDatosEstudioNivel(mes, anio);
                diciembre = this.reporteCostPerViewDAO.obtenerCostPerViewDiciembreDatosEstudioNivel(Long.valueOf(anio - 1L));
            } else {
                datos = this.reporteCostPerViewDAO.obtenerCostPerViewMensualDatosTituloNivel(mes, anio, idEstudio, nombreUnico, temporada);
                diciembre = this.reporteCostPerViewDAO.obtenerCostPerViewDiciembreDatosTituloNivel(Long.valueOf(anio - 1L), idEstudio, nombreUnico, temporada);
            }
        } else {
            datos = this.reporteCostPerViewDAO.obtenerCostPerViewMensualDatosTituloNivel(mes, anio, idEstudio, nombreUnico, temporada);
            diciembre = this.reporteCostPerViewDAO.obtenerCostPerViewDiciembreDatosTituloNivel(Long.valueOf(anio - 1L), idEstudio, nombreUnico, temporada);
        }
        boolean dicFlag = diciembre != null && !diciembre.isEmpty();
        Integer amorIdxEnero = 0;
        Integer visIdxEnero = 1;
        Integer cpvIdxEnero = 2;
        Integer amorIdxDiciembre = 34;
        if (datos != null && !datos.isEmpty()) {
            if (dicFlag) {
                Collections.sort(diciembre, comparator);
            }
            for (CostPerViewEstudioMensualDatosDTO item : datos) {
                int i;
                String[] fila = item.getFieldsAsRow();
                Object[] tfila = Arrays.copyOfRange(fila, 0, 1);
                Object[] sfila = Arrays.copyOfRange(fila, 1, tamanio);
                Object[] afila = Arrays.copyOfRange(fila, fila.length - 4, fila.length);
                if (dicFlag && (i = Collections.binarySearch(diciembre, item, comparator)) >= 0) {
                    CostPerViewEstudioMensualDatosDTO found = (CostPerViewEstudioMensualDatosDTO)diciembre.get(i);
                    String[] arowDic = found.getFieldsAsRow();
                    if (sfila[visIdxEnero] == null || new Double(sfila[visIdxEnero]) == 0.0) {
                        sfila[cpvIdxEnero.intValue()] = "0.0";
                    } else if ((sfila[amorIdxEnero] == null || new Double(sfila[amorIdxEnero]) == 0.0) && arowDic[amorIdxDiciembre] != null) {
                        sfila[cpvIdxEnero.intValue()] = new Double(new Double(arowDic[amorIdxDiciembre]) / new Double((String)sfila[visIdxEnero])).toString();
                    }
                }
                Double sumatoriaAmor = 0.0;
                Double sumatoriaVis = 0.0;
                for (int i2 = 0; i2 < sfila.length; ++i2) {
                    if (i2 % 3 == 0) {
                        sumatoriaAmor = sumatoriaAmor + new Double(sfila[i2]);
                    }
                    if (i2 % 3 != 1) continue;
                    sumatoriaVis = sumatoriaVis + new Double(sfila[i2]);
                }
                afila[0] = String.format("%.2f", sumatoriaAmor);
                afila[1] = String.format("%.2f", sumatoriaVis);
                Double cpv = sumatoriaAmor / sumatoriaVis;
                afila[2] = !cpv.isInfinite() ? String.format("%.2f", cpv) : "";
                String[] row = (String[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])tfila, (Object[])sfila), (Object[])afila);
                tabla = tabla == null ? new String[1][row.length] : (String[][])Arrays.copyOf(tabla, tabla.length + 1);
                tabla[tabla.length - 1] = row;
            }
        }
        return tabla;
    }

    public String[][] obtenReporteAnualTabla(Long anio, Long mes, Long idEstudio, String nombreUnico, String temporada, Boolean consulta) throws IllegalArgumentException, IllegalAccessException {
        String[][] tabla = null;
        String pivot_date = "";
        Integer fanio = anio.intValue();
        int anios = fanio - 4;
        int i = 0;
        while (anios <= fanio) {
            pivot_date = pivot_date + anios + " AS ANIO_" + i + ",";
            ++anios;
            ++i;
        }
        List datos = null;
        datos = idEstudio == null ? (consulta.booleanValue() ? this.reporteCostPerViewDAO.obtenerCostPerViewAnualDatosEstudioNivel(Long.valueOf(anio - 4L), anio, mes, pivot_date.substring(0, pivot_date.length() - 1)) : this.reporteCostPerViewDAO.obtenerCostPerViewAnualDatosTituloNivel(Long.valueOf(anio - 4L), anio, mes, pivot_date.substring(0, pivot_date.length() - 1), idEstudio, nombreUnico, temporada)) : this.reporteCostPerViewDAO.obtenerCostPerViewAnualDatosTituloNivel(Long.valueOf(anio - 4L), anio, mes, pivot_date.substring(0, pivot_date.length() - 1), idEstudio, nombreUnico, temporada);
        if (datos != null && !datos.isEmpty()) {
            for (CostPerViewEstudioAnualDatosDTO item : datos) {
                String[] fila = item.getFieldsAsRow();
                Object[] tfila = Arrays.copyOfRange(fila, 0, 1);
                Object[] sfila = Arrays.copyOfRange(fila, 1, fila.length - 4);
                Object[] afila = Arrays.copyOfRange(fila, fila.length - 4, fila.length);
                Double sumatoriaAmor = 0.0;
                Double sumatoriaVis = 0.0;
                for (int i2 = 0; i2 < sfila.length; ++i2) {
                    if (i2 % 3 == 0) {
                        sumatoriaAmor = sumatoriaAmor + new Double(sfila[i2]);
                    }
                    if (i2 % 3 != 1) continue;
                    sumatoriaVis = sumatoriaVis + new Double(sfila[i2]);
                }
                afila[0] = String.format("%.2f", sumatoriaAmor);
                afila[1] = String.format("%.2f", sumatoriaVis);
                Double cpv = sumatoriaAmor / sumatoriaVis;
                afila[2] = !cpv.isInfinite() ? String.format("%.2f", cpv) : "";
                String[] row = (String[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])tfila, (Object[])sfila), (Object[])afila);
                tabla = tabla == null ? new String[1][row.length] : (String[][])Arrays.copyOf(tabla, tabla.length + 1);
                tabla[tabla.length - 1] = row;
            }
        }
        return tabla;
    }

    public String[] obtenerMesesTabla(Long anio, Long mes) {
        ArrayList<String> meses = new ArrayList<String>();
        for (int i = 1; i <= mes.intValue(); ++i) {
            MesesAnio ames = MesesAnio.parse((String)("" + i));
            meses.add(ames.getDesc() + " - " + anio);
        }
        meses.add("ACUMULADO");
        String[] mesesArr = new String[meses.size()];
        mesesArr = meses.toArray(mesesArr);
        return mesesArr;
    }

    public String[] obtenerAniosTabla(Long anio) {
        ArrayList<String> anios = new ArrayList<String>();
        for (int i = anio.intValue() - 4; i <= anio.intValue(); ++i) {
            anios.add("" + i);
        }
        anios.add("ACUMULADO");
        String[] aniosArr = new String[anios.size()];
        aniosArr = anios.toArray(aniosArr);
        return aniosArr;
    }

    public String[] obtenerHeaderRubro(Long tamanio) {
        ArrayList<String> rubros = new ArrayList<String>();
        int i = 0;
        while ((long)i < tamanio + 1L) {
            rubros.add("Amortizaci\u00f3n");
            rubros.add("Visualizaciones");
            rubros.add("CPV");
            ++i;
        }
        String[] rubrosArr = new String[rubros.size()];
        rubrosArr = rubros.toArray(rubrosArr);
        return rubrosArr;
    }

    public ReporteCostPerViewVistaDTO obtenerReporteMensualVista(String fecha, Long idEstudio, String nombreUnico, String Temporada, Boolean consulta) throws ParseException, IllegalArgumentException, IllegalAccessException {
        ReporteCostPerViewVistaDTO reporte = new ReporteCostPerViewVistaDTO();
        HashMap fechaSplit = FechaUtilerias.getFechaValores((String)fecha, (String)"MM/yyyy");
        Long mes = (Long)fechaSplit.get("Month");
        Long anio = (Long)fechaSplit.get("Year");
        reporte.setTabla(this.obtenReporteMensualTabla(anio, mes, idEstudio, nombreUnico, Temporada, consulta));
        reporte.setPheader(this.obtenerMesesTabla(anio, mes));
        reporte.setRheader(this.obtenerHeaderRubro(mes));
        return reporte;
    }

    public ReporteCostPerViewVistaDTO obtenerReporteAnualVista(String fecha, Long idEstudio, String nombreUnico, String Temporada, Boolean consulta) throws ParseException, IllegalArgumentException, IllegalAccessException {
        ReporteCostPerViewVistaDTO reporte = new ReporteCostPerViewVistaDTO();
        HashMap fechaSplit = FechaUtilerias.getFechaValores((String)fecha, (String)"MM/yyyy");
        Long mes = (Long)fechaSplit.get("Month");
        Long anio = (Long)fechaSplit.get("Year");
        reporte.setTabla(this.obtenReporteAnualTabla(anio, mes, idEstudio, nombreUnico, Temporada, consulta));
        reporte.setPheader(this.obtenerAniosTabla(anio));
        reporte.setRheader(this.obtenerHeaderRubro(5L));
        return reporte;
    }

    public InputStream obtenerStreamReporte(String tipoReporte, String fecha, Long idEstudio, String nombreUnico, String Temporada) throws IllegalArgumentException, IllegalAccessException, ParseException, ExcelMapperException, IOException, ReportCostPerViewException {
        int i;
        ReporteCostPerViewVistaDTO reporte = null;
        ExcelMapper mapper = new ExcelMapper();
        ArrayList<ExcelRule> rules = new ArrayList<ExcelRule>();
        ByteArrayInputStream stream = null;
        byte[] info = null;
        if (tipoReporte.equals("mensual")) {
            reporte = this.obtenerReporteMensualVista(fecha, idEstudio, nombreUnico, Temporada, false);
        }
        if (tipoReporte.equals("anual")) {
            reporte = this.obtenerReporteAnualVista(fecha, idEstudio, nombreUnico, Temporada, false);
        }
        String[][] tabla = reporte.getTabla();
        String[] rheader = reporte.getRheader();
        String[] pheader = reporte.getPheader();
        String[] apheader = new String[rheader.length + 1];
        String[] arheader = new String[rheader.length + 1];
        int j = 0;
        for (i = 0; i < rheader.length; ++i) {
            if (i == 0) {
                apheader[i] = "Estudio";
                continue;
            }
            if ((i - 1) % 3 == 0) {
                apheader[i] = pheader[j];
                ++j;
                continue;
            }
            apheader[i] = "";
        }
        for (i = 0; i < arheader.length; ++i) {
            arheader[i] = i == 0 ? "" : rheader[i - 1];
        }
        mapper.setClassName(ReporteCostPerViewVistaDTO.class.getName());
        mapper.setFirstRow(2);
        mapper.setId("reporteCostPerView");
        mapper.setParent(null);
        mapper.setSkipErrors(true);
        mapper.setStartRowIndex(0L);
        for (i = 0; i < tabla[0].length - 1; ++i) {
            ExcelRule rule = new ExcelRule();
            ArrayList<String> headers = new ArrayList<String>();
            rule.setColumn(ReporteCostoPerViewBO.getExcelColumnName(i + 1));
            headers.add(apheader[i]);
            headers.add(arheader[i]);
            rule.setHeaders(headers);
            if (i > 0) {
                rule.setType(ExcelMapperDataType.numeric);
            }
            rules.add(rule);
        }
        mapper.setRules(rules);
        info = this.excelMapperTransform.transformObjectToExcel(tabla, mapper, String.class);
        stream = new ByteArrayInputStream(info);
        return stream;
    }

    public HashMap<String, HashMap<String, String>> obtenerDataQueryDetalleMensual(String fecha) throws IOException, ParseException, InvalidFormatException {
        String header_1 = "SELECT '|||";
        String header_2 = "SELECT 'IdBroadview|Estudio|Temporada/Episodio";
        String detalleMensual = "SELECT ID_BV||'|'||ESTUDIO||'|'||T_E";
        String amortizaciones = "";
        String visualizaciones = "";
        HashMap fechaSplit = FechaUtilerias.getFechaValores((String)fecha, (String)"MM/yyyy");
        Long mes = (Long)fechaSplit.get("Month");
        Long anio = (Long)fechaSplit.get("Year");
        this.logger.info("{}", (Object)mes);
        this.logger.info("{}", (Object)anio);
        SimpleDateFormat formater = new SimpleDateFormat("MM/yyyy");
        Calendar beginCalendar = Calendar.getInstance();
        Calendar finishCalendar = Calendar.getInstance();
        beginCalendar.setTime(formater.parse("1/" + anio));
        finishCalendar.setTime(formater.parse(mes + "/" + anio));
        Integer index = 1;
        while (beginCalendar.before(finishCalendar) || beginCalendar.equals(finishCalendar)) {
            MesesAnio ames = MesesAnio.parse((String)("" + index));
            header_1 = header_1 + ames.getDesc() + "|||";
            header_2 = header_2 + "|Amortizacion|Visualizaciones|CPV";
            detalleMensual = detalleMensual + "||'|'||AMOR_" + index + "||'|'||VIS_" + index + "||'|'||CPV_" + index;
            amortizaciones = amortizaciones + "AMOR_" + index + "+";
            visualizaciones = visualizaciones + "VIS_" + index + "+";
            beginCalendar.add(2, 1);
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        header_1 = header_1 + "ACUMULADO|||' as X from dual;";
        header_2 = header_2 + "|AmortizacionT|VisualizacionesT|CPVT|' as X from dual;";
        amortizaciones = amortizaciones.substring(0, amortizaciones.length() - 1);
        visualizaciones = visualizaciones.substring(0, visualizaciones.length() - 1);
        detalleMensual = detalleMensual + "|| '|' || (" + amortizaciones + ") || '|' || (" + visualizaciones + ") || '|' || ROUND((" + amortizaciones + ")/(" + visualizaciones + "), 2) FROM (";
        this.logger.info("{}", (Object)header_1);
        this.logger.info("{}", (Object)header_2);
        this.logger.info("{}", (Object)amortizaciones);
        this.logger.info("{}", (Object)visualizaciones);
        this.logger.info("{}", (Object)detalleMensual);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("header_0", header_1);
        headers.put("header_1", header_2);
        HashMap<String, String> bheaders = new HashMap<String, String>();
        bheaders.put("bheader_0", detalleMensual);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("anio", anio.toString());
        parameters.put("mes", mes.toString());
        HashMap<String, HashMap<String, String>> customData = new HashMap<String, HashMap<String, String>>();
        customData.put("HEADERS", headers);
        customData.put("BHEADERS", bheaders);
        customData.put("PARAMETERS", parameters);
        return customData;
    }

    public HashMap<String, HashMap<String, String>> obtenerDataQueryDetalleAnual(String fecha) throws IOException, ParseException, InvalidFormatException {
        String header_1 = "SELECT '|||";
        String header_2 = "SELECT 'IdBroadview|Estudio|Temporada/Episodio";
        String detalleMensual = "SELECT ID_BV||'|'||ESTUDIO||'|'||T_E";
        String amortizaciones = "";
        String visualizaciones = "";
        String pivot_data = "";
        HashMap fechaSplit = FechaUtilerias.getFechaValores((String)fecha, (String)"MM/yyyy");
        Long mes = (Long)fechaSplit.get("Month");
        Long anio = (Long)fechaSplit.get("Year");
        this.logger.info("{}", (Object)mes);
        this.logger.info("{}", (Object)anio);
        SimpleDateFormat formater = new SimpleDateFormat("MM/yyyy");
        Calendar beginCalendar = Calendar.getInstance();
        Calendar finishCalendar = Calendar.getInstance();
        beginCalendar.setTime(formater.parse("1/" + anio));
        finishCalendar.setTime(formater.parse(mes + "/" + anio));
        Integer fanio = anio.intValue();
        Integer index = 1;
        int anios = fanio - 4;
        int i = 0;
        while (anios <= fanio) {
            header_1 = header_1 + anios + "|||";
            header_2 = header_2 + "|Amortizacion|Visualizaciones|CPV";
            detalleMensual = detalleMensual + "||'|'||AMOR_ANIO_" + index + "||'|'||VIS_ANIO_" + index + "||'|'||CPV_ANIO_" + index;
            amortizaciones = amortizaciones + "AMOR_ANIO_" + index + "+";
            visualizaciones = visualizaciones + "VIS_ANIO_" + index + "+";
            pivot_data = pivot_data + anios + " AS ANIO_" + i + ",";
            beginCalendar.add(2, 1);
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
            ++anios;
            ++i;
        }
        header_1 = header_1 + "ACUMULADO|||' as X from dual;";
        header_2 = header_2 + "|AmortizacionT|VisualizacionesT|CPVT|' as X from dual;";
        amortizaciones = amortizaciones.substring(0, amortizaciones.length() - 1);
        visualizaciones = visualizaciones.substring(0, visualizaciones.length() - 1);
        pivot_data = pivot_data.substring(0, pivot_data.length() - 1);
        detalleMensual = detalleMensual + "|| '|' || (" + amortizaciones + ") || '|' || (" + visualizaciones + ") || '|' || ROUND((" + amortizaciones + ")/(" + visualizaciones + "), 2) FROM (";
        this.logger.info("{}", (Object)header_1);
        this.logger.info("{}", (Object)header_2);
        this.logger.info("{}", (Object)amortizaciones);
        this.logger.info("{}", (Object)visualizaciones);
        this.logger.info("{}", (Object)detalleMensual);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("header_0", header_1);
        headers.put("header_1", header_2);
        HashMap<String, String> bheaders = new HashMap<String, String>();
        bheaders.put("bheader_0", detalleMensual);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("anio_final", anio.toString());
        parameters.put("anio_inicial", new Long(fanio - 4).toString());
        parameters.put("mes", mes.toString());
        parameters.put("pivot_data", pivot_data);
        HashMap<String, HashMap<String, String>> customData = new HashMap<String, HashMap<String, String>>();
        customData.put("HEADERS", headers);
        customData.put("BHEADERS", bheaders);
        customData.put("PARAMETERS", parameters);
        return customData;
    }

    public InputStream obtenerStreamZipReporte(String tipoReporte, String fecha) throws InvalidFormatException, IOException, ParseException {
        String finalQueryNameFile = "cpvDetalle";
        String baseQueryNameFile = "";
        HashMap<String, HashMap<String, String>> customData = this.obtenerDataQueryDetalleMensual(fecha);
        if (tipoReporte.equals("mensual")) {
            baseQueryNameFile = "queryCpvDetalleMensual.txt";
            customData = this.obtenerDataQueryDetalleMensual(fecha);
        }
        if (tipoReporte.equals("anual")) {
            baseQueryNameFile = "queryCpvDetalleAnual.txt";
            customData = this.obtenerDataQueryDetalleAnual(fecha);
        }
        if (this.creaQueryDetalleCpv(customData, baseQueryNameFile, finalQueryNameFile).booleanValue()) {
            return this.creaStreamZipFileCpv(finalQueryNameFile);
        }
        return null;
    }

    private Boolean creaQueryDetalleCpv(HashMap<String, HashMap<String, String>> customData, String baseQueryNameFile, String finalQueryNameFile) {
        try {
            InputStream queryStream = this.customResourceLoader.getFile2ItputStream("classpath:templateFees/" + baseQueryNameFile);
            FileWriter fw = new FileWriter(this.uriSQL + finalQueryNameFile + ".sql");
            String lineSeparador = System.getProperty("line.separator");
            fw.write("SET trimspool ON;");
            fw.write(lineSeparador);
            fw.write("SET heading OFF;");
            fw.write(lineSeparador);
            fw.write("SET headsep OFF;");
            fw.write(lineSeparador);
            fw.write("SET linesize 20000;");
            fw.write(lineSeparador);
            fw.write("SET pagesize 0;");
            fw.write(lineSeparador);
            fw.write("SET TERMOUT OFF;");
            fw.write(lineSeparador);
            fw.write("SET NEWPAGE 0;");
            fw.write(lineSeparador);
            fw.write("SET SPACE 0;");
            fw.write(lineSeparador);
            fw.write("SET ECHO OFF;");
            fw.write(lineSeparador);
            fw.write("SET FEEDBACK OFF;");
            fw.write(lineSeparador);
            fw.write("SET MARKUP HTML OFF SPOOL OFF;");
            fw.write(lineSeparador);
            fw.write("SET VERIFY OFF;");
            fw.write(lineSeparador);
            fw.write("SET DEFINE OFF;");
            fw.write(lineSeparador);
            fw.write("SET serveroutput on size 1000000;");
            fw.write(lineSeparador);
            fw.write("spool " + this.uriTXT + finalQueryNameFile + ".txt;");
            fw.write(lineSeparador);
            fw.write("--[BEGIN]");
            fw.write(lineSeparador);
            HashMap<String, String> headers = customData.get("HEADERS");
            for (int i = 0; i < headers.size(); ++i) {
                fw.write(headers.get("header_" + i));
                fw.write(lineSeparador);
            }
            fw.write("--[END_HEADER]");
            fw.write(lineSeparador);
            HashMap<String, String> bheaders = customData.get("BHEADERS");
            for (int i = 0; i < bheaders.size(); ++i) {
                fw.write(bheaders.get("bheader_" + i));
                fw.write(lineSeparador);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(queryStream));
            String line = null;
            HashMap<String, String> parameters = customData.get("PARAMETERS");
            while ((line = in.readLine()) != null) {
                if (line == null) continue;
                for (Map.Entry<String, String> entry : parameters.entrySet()) {
                    line = line.replace("#{" + entry.getKey() + "}", entry.getValue());
                }
                fw.write(line);
                fw.write(lineSeparador);
            }
            if (bheaders.size() > 0) {
                for (int i = 0; i < bheaders.size(); ++i) {
                    fw.write(")");
                }
                fw.write(";");
                fw.write(lineSeparador);
            }
            fw.write("--[END]");
            fw.write(lineSeparador);
            fw.write("spool off;");
            fw.write(lineSeparador);
            fw.write("quit");
            fw.close();
        }
        catch (IOException | InvalidFormatException e) {
            return false;
        }
        return true;
    }

    private InputStream creaStreamZipFileCpv(String finalQueryNameFile) {
        File file = new File(this.uriSQL + finalQueryNameFile + ".sql");
        FileInputStream zipStream = null;
        ResponseGeneraReporteDTO responseDTO = new ResponseGeneraReporteDTO();
        if (file.exists()) {
            try {
                File zipFile;
                responseDTO = this.baseActivosBO.generaReporteWS(finalQueryNameFile);
                if (responseDTO != null && responseDTO.getMensaje().contains("OK") && responseDTO.getRuta() != null && (zipFile = new File(responseDTO.getRuta())) != null && zipFile.exists()) {
                    zipStream = new FileInputStream(zipFile);
                }
            }
            catch (Exception e) {
                this.logger.debug(e.toString());
            }
        }
        return zipStream;
    }

    public void procesarStreamArchivoCarga(File archivo, String nombreArchivo, String fecha, String expediente) throws ParseException, IOException, ReportCostPerViewException {
        this.logger.info("Procesando ...");
        this.logger.info("{}", (Object)archivo);
        this.logger.info("{}", (Object)nombreArchivo);
        HashMap fechaSplit = FechaUtilerias.getFechaValores((String)fecha, (String)"MM/yyyy");
        Long mes = (Long)fechaSplit.get("Month");
        Long anio = (Long)fechaSplit.get("Year");
        ParamCargaTitulosVSDTO request = new ParamCargaTitulosVSDTO();
        ResponseCargaTitulosVSDTO response = null;
        DLARestClient client = null;
        String fileName = StringUtils.leftPad((String)String.valueOf(mes), (int)2, (String)"0") + StringUtils.leftPad((String)String.valueOf(anio), (int)4, (String)"0") + expediente + nombreArchivo;
        String absoluteFileName = this.uriCarga + fileName;
        byte[] file = FileUtils.readFileToByteArray((File)archivo);
        File d = new File(absoluteFileName);
        d.setExecutable(true, false);
        d.setReadable(true, false);
        d.setWritable(true, false);
        FileUtils.writeByteArrayToFile((File)d, (byte[])file);
        this.logger.info("Archivo: [{}]", (Object)absoluteFileName);
        String separador = "/";
        client = this.dlaRestClientFactory.getClient(DLARestServices.WS_CARGA_ARCHIVO_VISUALIZACIONES);
        request.setNombreArchivo(fileName);
        request.setExpediente(expediente);
        request.setMesCarga("01" + separador + StringUtils.leftPad((String)String.valueOf(mes), (int)2, (String)"0") + separador + StringUtils.leftPad((String)String.valueOf(anio), (int)4, (String)"0"));
        this.logger.debug("request : [{}]", (Object)request);
        this.logger.debug("client!!! : [{}]", (Object)client);
        response = client.get(request, ResponseCargaTitulosVSDTO.class);
        this.logger.debug("response : [{}]", (Object)response);
        if (response != null && !response.isResultado()) {
            throw new ReportCostPerViewException("Error servicio carga: " + response.getMensaje());
        }
    }

    public static String getExcelColumnName(int number) {
        StringBuilder sb = new StringBuilder();
        int num = number - 1;
        while (num >= 0) {
            int numChar = num % 26 + 65;
            sb.append((char)numChar);
            num = num / 26 - 1;
        }
        return sb.reverse().toString();
    }

    public VisualizacionesCostPerViewVistaDTO obtenerCargaVisualizacionesMensualVista(String fecha) throws ParseException, IllegalArgumentException, IllegalAccessException, ReportCostPerViewException {
        VisualizacionesCostPerViewVistaDTO reporte = new VisualizacionesCostPerViewVistaDTO();
        VisualizacionesCostPerViewVistaDTO response = new VisualizacionesCostPerViewVistaDTO();
        HashMap fechaSplit = FechaUtilerias.getFechaValores((String)fecha, (String)"MM/yyyy");
        Long mes = (Long)fechaSplit.get("Month");
        Long anio = (Long)fechaSplit.get("Year");
        SimpleDateFormat formatoEntrada = new SimpleDateFormat("MM/yyyy");
        Date date = formatoEntrada.parse(fecha);
        if (FechaUtilerias.monthGreatherThan((Date)date, (Date)new Date())) {
            throw new ReportCostPerViewException("Mes elegido es mayor al mes actual");
        }
        response = this.obtenCargaVisualizacionesPrincipalTabla(fecha);
        reporte.setHeader(this.obtenerHeaderTablaCargaVisualizaciones());
        if (response != null) {
            reporte.setTabla(this.obtenCargaVisualizacionesDetalleTabla(anio, mes));
            reporte.setCorrectos(response.getCorrectos());
            reporte.setErroneos(response.getErroneos());
            reporte.setLeidos(response.getLeidos());
        }
        return reporte;
    }

    public String[][] obtenCargaVisualizacionesDetalleTabla(Long anio, Long mes) throws IllegalArgumentException, IllegalAccessException {
        String[][] tabla = null;
        List datos = this.reporteCostPerViewDAO.obtenerVisualizaciones(mes, anio);
        if (datos != null && !datos.isEmpty()) {
            for (CargaVisualizacionesDetalleDTO item : datos) {
                String[] arow = item.getFieldsAsRow();
                String[] row = new String[]{arow[2], arow[3], arow[4]};
                tabla = tabla == null ? new String[1][row.length] : (String[][])Arrays.copyOf(tabla, tabla.length + 1);
                tabla[tabla.length - 1] = row;
            }
        }
        return tabla;
    }

    public VisualizacionesCostPerViewVistaDTO obtenCargaVisualizacionesPrincipalTabla(String fecha) throws ParseException, IllegalArgumentException, IllegalAccessException, ReportCostPerViewException {
        VisualizacionesCostPerViewVistaDTO reporte = null;
        HashMap fechaSplit = FechaUtilerias.getFechaValores((String)fecha, (String)"MM/yyyy");
        Long mes = (Long)fechaSplit.get("Month");
        Long anio = (Long)fechaSplit.get("Year");
        SimpleDateFormat formatoEntrada = new SimpleDateFormat("MM/yyyy");
        Date date = formatoEntrada.parse(fecha);
        if (FechaUtilerias.monthGreatherThan((Date)date, (Date)new Date())) {
            throw new ReportCostPerViewException("Mes elegido es mayor al mes actual");
        }
        List datos = this.reporteCostPerViewDAO.obtenerVisualizacionesPrincipal(mes, anio);
        if (datos != null && !datos.isEmpty()) {
            reporte = new VisualizacionesCostPerViewVistaDTO();
            LinkedList lista = new LinkedList(datos);
            reporte.setLeidos(((CargaVisualizacionesPrincipalDTO)lista.getFirst()).getTotalRegistros());
            reporte.setCorrectos(((CargaVisualizacionesPrincipalDTO)lista.getFirst()).getTotalCargados());
            reporte.setErroneos(((CargaVisualizacionesPrincipalDTO)lista.getFirst()).getTotalError());
        }
        return reporte;
    }

    public String[] obtenerHeaderTablaCargaVisualizaciones() {
        String[] header = new String[]{"Id Broadview", "Nombre del T\u00edtulo", "Visualizaciones"};
        return header;
    }

    public InputStream obtenerStreamVisualizaciones(String fecha) throws IllegalArgumentException, IllegalAccessException, ParseException, ExcelMapperException, IOException {
        List reporte = null;
        ExcelRule newRule = new ExcelRule();
        ByteArrayInputStream stream = null;
        byte[] info = null;
        ExcelMapper mapper = this.excelMapperContext.getExcelMapper("plantillaVisualizacionesCostPerView");
        newRule.setAttribute("comentarios");
        newRule.setColumn("E");
        newRule.setHeader("Comentarios");
        mapper.getRules().add(newRule);
        HashMap fechaSplit = FechaUtilerias.getFechaValores((String)fecha, (String)"MM/yyyy");
        Long mes = (Long)fechaSplit.get("Month");
        Long anio = (Long)fechaSplit.get("Year");
        reporte = this.reporteCostPerViewDAO.obtenerVisualizacionesDetalle(mes, anio);
        info = this.excelMapperTransform.transformObjectToExcel(reporte, mapper, CargaVisualizacionesDetalleDTO.class);
        stream = new ByteArrayInputStream(info);
        return stream;
    }

    public InputStream obtenerStreamPlantilla() throws IllegalArgumentException, IllegalAccessException, ParseException, ExcelMapperException, IOException, InvalidFormatException {
        ByteArrayInputStream stream = null;
        byte[] info = null;
        info = this.customResourceLoader.getFile2ByteArray("classpath:templateFees/plantillaCargaVS.xlsx");
        stream = new ByteArrayInputStream(info);
        return stream;
    }

    public String logStringArray(String[] array) {
        String log = "";
        if (array != null && array.length != 0) {
            for (String item : array) {
                log = log + "[" + item + "] ";
            }
        }
        return log;
    }
}

