package com.mx.dla.dda.contrato.amortizacion.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.amortizacion.bos.AmortizacionBO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.common.constants.ContratoConstats;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.titulo.dtos.Lista;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;
import com.mx.dla.dda.contrato.titulo.exception.TituloException;

public class AmortizacionAction extends BaseContratoAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = -1880333104009351799L;
	
	@Autowired
	private AmortizacionBO amortizacionBO;
	
	@Autowired
	private GeneralesBO generalesBO;
	
	private Lista lista;
	
	private List<Titulo> titulos;
	
	private Titulo titulo;
	
	private String error;
	
	@Override
	public String execute() throws Exception {
		Long idC = (Long) getSession().get(ContratoConstats.ID_CONTRATO_SESSION);
		ContratoDTO ct = generalesBO.obtenContrato(idC);
		getSession().put(ContratoConstats.CONTRATO_SESSION, ct);
		lista = amortizacionBO.buscarListaActual(ct);
		getSession().put(ContratoConstats.LISTA_SESSION, lista);
		logger.debug("sube objetos a la sesion");
		return SUCCESS;
	}
	
	
	public String busqueda()
	{
		ContratoDTO ct = (ContratoDTO) getSession().get( ContratoConstats.CONTRATO_SESSION);
		Lista li = (Lista) getSession().get( ContratoConstats.LISTA_SESSION);
		try {
			titulos = amortizacionBO.busqueda(ct, li, titulo);
		} catch (TituloException e) {
			setError(e.getMessage());
		}catch (Exception e)
		{
			logger.error("Error :",e);
			setError("Ocurrio un error");
		}
		return SUCCESS;
	}
	
	public String busquedaDetalle()
	{
		try {
			titulos = amortizacionBO.busquedaDetalle( titulo);
		} catch (TituloException e) {
			setError(e.getMessage());
		}catch (Exception e)
		{
			logger.error("Error :",e);
			setError("Ocurrio un error");
		}
		return SUCCESS;
	}

	public String find() {
		return SUCCESS;
	}
	
	public Lista getLista() {
		return lista;
	}
	public void setLista(Lista lista) {
		this.lista = lista;
	}
	
	public Titulo getTitulo() {
		return titulo;
	}
	
	public void setTitulo(Titulo titulo) {
		this.titulo = titulo;
	}
	
	public List<Titulo> getTitulos() {
		return titulos;
	}
	
	public void setTitulos(List<Titulo> titulos) {
		this.titulos = titulos;
	}

	public String getError() {
		return error;
	}
	
	public void setError(String error) {
		this.error = error;
	}
}
