package com.mx.dla.dda.contrato.generales.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.generales.bos.PoblarGeneralesBO;
import com.mx.dla.dda.contrato.generales.dtos.ApartadoDTO;

@Controller
@Scope("request")
public class ExponerApartadosAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private Long idEstudio;
	private Long idApartado;
	private List<ApartadoDTO> apartados;
	
	@Autowired
	private PoblarGeneralesBO poblarGeneralesBO;

	public String execute() {
		//contrato.getIdEstudio(), contrato.getIdApartado()
		setApartados(poblarGeneralesBO.obtenerApartados(idEstudio, idApartado));
		return SUCCESS;
	}

	public void setIdEstudio(Long idEstudio) {
		this.idEstudio = idEstudio;
	}

	public Long getIdEstudio() {
		return idEstudio;
	}

	public void setApartados(List<ApartadoDTO> apartados) {
		this.apartados = apartados;
	}

	public List<ApartadoDTO> getApartados() {
		return apartados;
	}
	
	public void setIdApartado(Long idApartado) {
		this.idApartado = idApartado;
	}
	
	public Long getIdApartado() {
		return idApartado;
	}

}
