$(document).ready(function(){		    
	inicializarElementos();  
			 	 	            	 		
});

function inicializarElementos(){
	
    $("#datepicker").datepicker();   
    
    $("#consultar").click(function ()  
    {    	       	 	       	       	       	    	    	       	       
 	   if( $('#datepicker').val() != "")
 	   {
 		   	   if(validarFecha($('#fecha').val()))
 		   	   {
			       var fecha =  $('#datepicker').val().split("/");
		    	   var transaccion = $('#tipoTransacciones').val();
		    	   
		    	   limpiarTabla();
		    	   var mes = parseInt(fecha[0]);
		    	   var anio = parseInt(fecha[2]);
		    	   	    	  
		    	   cargarInformacionTransacciones(mes, anio, parseInt(transaccion));	    	   
		    	   $('#labelError').hide();	    	   	    	   
 		   	   }
			   else
			   {	    	   	    	  	    	   
		    	   showError("Error en el formato de la fecha o falta fecha.");	    	  
		       }
 	   }
	   else{	    	   	    	   	       
		       $('#labelError').show();	    	  
	   }
    });	
}

function cargarInformacionTransacciones(mes, anio, transaccion){
	
	$.post( contextPath + '/carga/transacciones/getCargaTransacciones', 
			{ mes: mes , annio : anio,  transaccion : transaccion }
		  )
	 .done(function( response ) 
	  {
		 if(response.msgError != null)        		        		
     		showError(response.msgError);     	 
     	 else
     		crearTablaDatos(response.listado);     		     	 
	 });
}

function crearTablaDatos(data){

	  var idTable = "tablaTransacciones";
	  
	  var tablaTransacciones = creaTabla( $( '#divTabla' ), idTable);
		  
	  var encabezados = [ "Regi\u00F3n" , "Empresa",  data[0].mes5, data[0].mes4, data[0].mes3, data[0].mes2, data[0].mes1, data[0].mesActual ];	 
	  
	  agregarEncabezado(tablaTransacciones, encabezados, null, "encabezado");
		  	 
	  var idpadre = "";
	  
	  if(data.length == 1 && data[0].region == null)
		  $("#labMensaje").show();
	  else
	  {
		  $("#labMensaje").hide();
		  for (var i=1; i<data.length; i++)
		  {		                   
			   var idTr = "fila_"+i;		   
			   var html = "";	
			   var atributos = [ ["estatus", "cerrado"]];
			   
			   var valores = [data[i].region, "" , data[i].mes5, data[i].mes4, data[i].mes3, data[i].mes2, data[i].mes1, data[i].mesActual];		   		    
			   
			   if( data[i].padre == null )
			   {			
				   atributos = [ ["estatus", "cerrado"], ["idpadre", idpadre]];
				   var html ="<td>"+ data[i].empresa + "</td>";			   
			   }
			   else if( data[i].padre == "0" )
			   {						   
				   var html ="<td>"+ data[i].empresa + "</td>";			   
			   }
			   else
			   {			   
				   idpadre = idTr;
				   var atributos = [ ["estatus", "cerrado"], ["id", idpadre]];
				   var html ="<td><label>"+
	               				  "<span style='display:none' class='ui-icon ui-icon-minus'></span>"+
	               				  "<span                      class='ui-icon ui-icon-plus'></span>" +
	               				  "</label>" + "<a onclick= \"controlarBloque( \'" + idTable + "\' , \'"+ idpadre +"\')\">" + data[i].empresa + "</a></td>";			   			   
			   }
			   		   
			   agregarFila(tablaTransacciones, valores, atributos, null, html, 1);		  		   
		   }
		  
		   $('#tablaTransacciones tr[idpadre]' ).hide();  
	  }	  
}

function creaTabla(container, id) 
{	
    var table = $("<table/>").addClass('table table-striped table-hover').attr('id',id);       
    table.append($("<thead/>"));
    table.append($("<tbody/>"));    
    return container.append(table);
}

function agregarFila(table, rowData, atributos, clases, html, col) 
{
	  var lastRow = $('<tr/>').appendTo(table.find('tbody:last'));

	  if(atributos != null)
	  {	  
		  $.each(atributos, function(rowIndex, r) 
		  {		  
			    lastRow.attr(atributos[rowIndex][0],atributos[rowIndex][1]);	        	        
	      });
	  }
	  
	  if(clases != null)
	  {
		  $.each(clases, function(rowIndex, r) 
		  {		  
			    lastRow.attr(clases[rowIndex][0],clases[rowIndex][1]);	        	        
		  });
	  }
	  
	  $.each(rowData, function(colIndex, c) { 
		  
		  if(col != null && colIndex == col)
			  lastRow.append( html );
		  else
			  lastRow.append( $('<td/>').append().text(c) );
	  });
	   
	  return lastRow;
}

function agregarEncabezado(table, rowData, atributos, clase) 
{		   	   	  	   
	   var lastRow = $('<tr/>').addClass(clase).appendTo(table.find('thead:last'));	   
	   $.each(rowData, function(index, c) { 
		      lastRow.append($("<th/>").text(c));
	   });	   	   	  
}

function controlarBloque( idtabla, tr )
{			
	if( $('#'+idtabla).find('tr[id=' + tr + ']').attr('estatus') == "abierto" )
	{		
		ocultarBloque( idtabla, tr );
		$('#'+idtabla).find('tr[id=' + tr + ']').attr('estatus', 'cerrado');		
		$('#'+idtabla).find('tr[id=' + tr + '] span.ui-icon-plus').show();
		$('#'+idtabla).find('tr[id=' + tr + '] span.ui-icon-minus').hide();
	}
	else
	{				
		mostrarBloque( idtabla, tr );
		
		$('#'+idtabla).find('tr[id=' + tr + ']').attr('estatus', 'abierto');		
		$('#'+idtabla).find('tr[id=' + tr + '] span.ui-icon-minus').show();
		$('#'+idtabla).find('tr[id=' + tr + '] span.ui-icon-plus').hide();
	}			
}

function mostrarBloque( idtabla, tr ){
	 $( '#' + idtabla + ' tr[idpadre=' + tr + ']' ).show();	
}

function ocultarBloque( idtabla, tr ){				
	$( '#'  + idtabla + ' tr[idpadre=' + tr + ']' ).hide();						
}

function limpiarTabla(){
	$('#divTabla').empty();
	$('#tablaTransacciones').remove();		
}

function validarFecha(fecha){
	var validacion = true;
	try {
        $.datepicker.parseDate('mm/dd/yy', fecha);
    } catch (e) {
    	validacion = false;
    };
    return validacion;
}