function TituloGrid(gridId) {
	this.gridId = gridId;
	this.grid = null ;
	var me  = this;
	this.columnsFijas = [
	                     	{ label: 'idTituloCnt', name: 'idTituloCnt', width: 250, hidden:true,frozen:true }, 
		                    { label: 'T&iacute;tulo', name:'descTitulo',width:200, sortable: false,frozen:true , 
	                     		formatter : function (cellvalue, options, rowObject) {
	                     			
	                     			var r = cellvalue;
	                     			if(rowObject.agrupable == '1' && rowObject.nombreUnico != null )
	                     			{
	                     				r = "<a href='javascript:tituloController.cargaDetalle(\""+rowObject.nombreUnico+"\")'>  <strong>   +"+cellvalue+"</strong>   </a> "
	                     			}
	                     			if(rowObject.agrupable == '0' && rowObject.nombreUnico != null )
	                     			{
	                     				r = "<a href='javascript:tituloController.reloadGrid()'>  <strong>-"+cellvalue+"</strong>   </a> "
	                     			}
	                     			return r;
	                     		}
		                    },
		                    { label: 'Id BroadView', name: 'idBv', width: 100,sortable: false   }, 	                    									
		                    { label: 'Temporada', name: 'temporada', width: 80 ,sortable: false },
		                    { label: 'Episodio', name: 'episodio', width: 80 ,sortable: false },
		                    { label: 'Inicio', name: 'fechaInicio', width: 100,formatter:'date', 
		                    										formatoptions: {  newformat: 'm/d/Y'}   },
		                    { label: 'Fin', name: 'fechaFin', width: 100 ,formatter:'date', 
		                    											formatoptions: {  newformat: 'm/d/Y'} },
		                    { label: 'VU', name: 'mesesvu', width: 50  , align:"right",sortable: false },
		                    		                    
		                    { label: 'Categor&iacute;a'        , name: 'categoriaTit.desc', width: 150 , mname:'categoriaTit',sortable: false },
		                    
		                    { label: 'Costo'    , name: 'costo', width: 120 , align:"right" ,formatter:'currency' ,  summaryType:'sum' , summaryRound:"2", summaryRoundType:"trunc",sortable: false},
		                    		                    		                    
		                    { label: 'Briefcase', name: 'briefcase',align:"center" ,  width: 100, jsonmap:'briefcase'  , hidden:true  },
		                    { label: 'Briefcase', name: 'briefcase2',align:"center",  width: 100 , jsonmap:'briefcase', formatter : me.renderCheckBoxBC, sortable: false  },
		                    { label: 'json'     , name: 'json',hidden : true, formatter : me.storeInfo  },
		                    
		                    { label: 'idLista'       , name: 'idLista'       , width: 250 ,  hidden:true },
		                    { label: 'agrupable'     , name: 'agrupable'     , width: 250 ,  hidden:true },
		                    { label: 'movieSerie'    , name: 'movieSerie'    , width: 200 ,  hidden:true  },
		                    { label: 'bajaPerdida'   , name: 'bajaPerdida'   , width: 250 ,  hidden:true },
		                    { label: 'precioAnual'   , name: 'precioAnual'   , width: 250 ,  hidden:true },
		                    { label: 'Nombre General', name: 'nombreUnico'   , width: 200 ,  hidden:true  },
		                    { label: 'pjeExclusivo'  , name: 'pjeExclusivo'  , width: 250 ,  hidden:true },
		                    { label: 'mesesExclusivo', name: 'mesesExclusivo', width: 200 ,  hidden:true  }
		                ];
	
	
	if($("#tipoAmortizacion").val() == 'EXCLUSIVIDAD')
	{
		clm =  { label: 'Exclusividad % - Meses', name: 'pjemesesExclusivo', width: 200  },
		this.columnsFijas.push(clm);
	}
	
	this.columns = this.columnsFijas.concat([]);
	//this.init();
}

TituloGrid.prototype.getColumns = function() {
	return this.columns;
};

TituloGrid.prototype.reload = function() {
	this.genericLoadData( this.getData );
};


TituloGrid.prototype.reloadDetails = function(nu) {
	this.genericLoadData( this.getDetails, nu );	
};


TituloGrid.prototype.genericLoadData = function( loadData  , nu) {
	var me = this;
	$("#dynTitulosGrid").html("<table id='tituloGird'></table><div id='tituloGirdPager'></div>");
	var items = loadData(nu);
	this.init(items);
}

TituloGrid.prototype.itemsSelected = function() {
	var me = this;
	var ret = [];	
	var rowId =$("#"+me.gridId).jqGrid('getGridParam','selarrrow');  
	rowId.forEach(function (e,i){
		var _t = jQuery("#"+me.gridId).getRowData(e);
		var _a = JSON.parse( _t.json);
		ret.push(_a);
	});	
	
	if( (ret.length != 0 && ret[0].descTitulo.includes("Total:")) || 
		(ret.length != 0 && ret[0].descTitulo.includes("titulos")) )
		ret.shift();   //Se remueve el primer elemento que es la informacion del total
		
	return ret;	
};

TituloGrid.prototype.renderCheckBox = function (cellvalue, options, rowObject){  			
	var r = "<input type='checkbox' disabled='disabled'" ;
	if(cellvalue || cellvalue == "1") { r+= " checked='checked' "; }
    r+=" />";
	return r; 
};

TituloGrid.prototype.renderCheckBoxBC = function (cellvalue, options, rowObject){  		
	console.log(rowObject.briefcase)
	var r = "<input type='checkbox' disabled='disabled'" ;
	if(rowObject.briefcase) { r+= " checked='checked' "; }
    r+=" />";
	return r; 
};


TituloGrid.prototype.storeInfo = function (cellvalue, options, rowObject){  
	var r = JSON.stringify(rowObject);
	return r; 
};

TituloGrid.prototype.getData =function(  ) { 
	var items = {};
	$.ajax({ 
		url : contextPath +'/contrato/license/titulos/busquedaTituloGrid.action',
		type : "post",
		data : {"titulo.idLista" :   $("#idFormaBusqueda [name=idLista]").val()   },
		async : false,
		success : function (ret) { items = ret.titulos; }
	});
	return items;
};

TituloGrid.prototype.getDetails =function( nu ) { 
	var items = {};
	$.ajax({ 
		url : contextPath +'/contrato/license/titulos/busquedaDetalleTituloGrid.action',
		type : "post",
		data : {	"titulo.idLista" :   $("#idFormaBusqueda [name=idLista]").val()  ,
					"titulo.nombreUnico": nu
				},
		async : false,
		success : function (ret) { items = ret.titulos; }
	});
	return items;
};

TituloGrid.prototype.init = function(items) {
	var me = this;
	me.grid = $("#"+me.gridId).jqGrid({
		data: items,
        datatype: "local",
        loadonce : true,
        colModel: me.columns,
		viewrecords: false,
		shrinkToFit:false,
		width: 1000 ,
        height: 250,
        multiselect : true,
        rowNum: 10000,
        onSelectRow : function (id)
        {
        	var _t = jQuery("#"+me.gridId).getRowData(id);
        	if(_t.idTituloCnt == '')
        	{
        		$("#"+me.gridId).jqGrid('setSelection', id, false);
        	}
        },
        loadComplete: function(data) {
        	$( "#"+me.gridId + ' tbody  tr#1 > td').css( { 'font-weight':'bold', 'background-color':'#ffffcc' } );
        	$( "#"+me.gridId + '_frozen tbody  tr#1 > td').css( { 'font-weight':'bold', 'background-color':'#ffffcc' } );
			$( "#"+me.gridId + ' tbody  tr#1 > td').css( { 'font-weight':'bold', 'padding-left':'1px' } );
			$( "#"+me.gridId + '_frozen tbody  tr#1 > td').css( { 'font-weight':'bold', 'padding-left':'1px' } );														
        }
    });
	$("#"+me.gridId).jqGrid('setFrozenColumns');
};
