var feesValidateService = function($filter, $http, $q) {

	return {
				
		mensajeValidacion: function(valida, nombreTabla, mensaje){
			if(!valida)
			   showError("Verificar Registros de la tabla "+nombreTabla + mensaje);
			 return valida;
	    },	    	    
	    
	    convertirNumero: function(numero, tipoCast){
	    	//notacion matematica z: enteros, r: reales
		    if(tipoCast == "z")
		 	   numero = parseInt(numero.replace("$","").replace("%","").replace(",",""));		 		 
		 	else if(tipoCast == "r")
		 	   numero = parseDouble(numero.replace("$","").replace("%","").replace(",",""));
		 	return numero;
	    },	    
	    
	    validarLongitudCeldas: function(tabla, inicio, fin, indices){
	    	  var valida = true;		  
			  for(j=0; j< indices.length; j++)
			  {
				  for(var i=0; i< tabla.datos.length; i++)
				  {
					  if(tabla.datos[i][indices[j]].valor != null)
					  {
						  if(tabla.metadatos[indices[j]].max < tabla.datos[i][indices[j]].valor.length )
						  {
							  tabla.mensajes[i] = "Verificar Registro, longitud de categoria excede 25 caracteres.";
							  valida = false;
						  }					 
						  else
							  tabla.mensajes[i] = "";  
					  }				  
					  if(!valida) break;
				  }  
				  if(!valida) break;
			  }		  
			  tabla.valida = valida;
			  return tabla;
	    },
	    
	    
	    validarCategoriasRepetidas: function(tabla, indice){
	    	  var valida = true;		  
			  for(var i=0; i< tabla.datos.length-1; i++)
			  {
				  for(var j=i+1; j< tabla.datos.length; j++)
				  {
					  if(tabla.datos[i][indice].valor == tabla.datos[j][indice].valor )
						  valida = false;
					  if(!valida) break;
				  }
				  if(!valida) break;
			  }
			  tabla.valida = valida;
			  return tabla;
	    },
	
	    validarCeldasVacias: function(tabla, indiceMax, mensaje){
	    	  
	    	  var valida = true;		  
			  for(var i=0; i< tabla.datos.length; i++)
			  {
				  for(var j=0; j< tabla.datos[0].length; j++)
				  {
					  if(j < indiceMax)
					  {
				
						  if(tabla.datos[i][j].valor == null || tabla.datos[i][j].valor === "")
						  {						 
							  if(mensaje)
							     tabla.mensajes[i] = "Verificar Registro, existen campos vac\u00EDos.";
							  if(valida)
								 valida = false;
						  }  
					  }						  
				  }
				  if(valida && mensaje)
					 tabla.mensajes[i] = "";
			  }		  
			  tabla.valida = valida;		  
			  return tabla;
	    },
	    
	    validarRangosTablas: function(tabla, columnaOrigen, columnaDestino, filaInicio){
	    	  var valida = true;	
	    	  
	    	  console.log("validarRangosTablas"); 

	    	  alert(tabla); 
	    	  console.log(columnaOrigen);
	    	  console.log(columnaDestino);
	    	  console.log(filaInicio);
	  
			  for(var i=filaInicio; i< tabla.datos.length; i++)
			  {			 
				 if(this.convertirNumero(tabla.datos[i][columnaOrigen].valor, "z") > this.convertirNumero(tabla.datos[i][columnaDestino].valor, "z"))
				 {						 
					 tabla.mensajes[i] = "Desde no pueder ser mayor a hasta.";
					 if(valida)
					    valida = false;
				 }				
				 else if( (i <= tabla.datos.length-2) && (this.convertirNumero(tabla.datos[(i+1)][columnaOrigen].valor, "z") - this.convertirNumero(tabla.datos[i][columnaDestino].valor, "z") ) != 1)
				 {						 
					 tabla.mensajes[i] = "La diferencia entre rangos debe ser de 1.XXX";
					 if(valida)
					    valida = false;
				 }
				 if(valida)
					 tabla.mensajes[i] = "";
			  }		  
			  tabla.valida = valida;		  
			  return tabla;
	    },
	
	    validarValoresMonedaTablas: function(tabla, filaInicio, filaFin, columna, numFormatos){
	    	  var valida    = true;		  
	    	  var numVacios = 0;
			      	  			  
			  for(var i=filaInicio; i<=filaFin; i++)
			  {					 
				  valida = true;
				  if(tabla.datos[i][columna].valor == null && tabla.datos[i][columna+1].valor == null && valida)					 
					 valida= false;						 					 
				  else if(tabla.datos[i][columna].valor == null && tabla.datos[i][columna+1].valor == "" && valida)					
					 valida= false;						 					 
				  else if(tabla.datos[i][columna].valor == "" && tabla.datos[i][columna+1].valor == null && valida)					 
					 valida= false;						 
					 
				  if(!valida)					 
					numVacios++;					 	 
			  }	 						  	  
			  
			  if( numFormatos > numVacios )
				  valida = true;
			  else
				  valida = false;
			  tabla.valida = valida;		  
			  return tabla;	    	
	    },
	    
	    validarTablasPorcentaje: function(tabla, columna){
	    	  var valida = true;		  
			  for(var i=0; i< tabla.datos.length; i++)
			  {
				  if(tabla.datos[i][columna].valor == null || tabla.datos[i][columna].valor == "" && valida)
				  {
					 valida= false;
					 break;
				  }					
				  if(!valida) break;				 				  	 			
			  }	  
			  tabla.valida = valida;		  
			  return tabla;	    	
	    },
	    
	    validarTablasRevenuePorcentaje: function(tabla, columna){
	    	  var valida = true;		  
			  for(var i=0; i< tabla.datos.length; i++)
			  {
				  if( parseFloat(tabla.datos[i][columna].valor) > 100)
				  {
					 valida= false;
					 break;
				  }					
				  if(!valida) break;				 				  	 			
			  }	  
			  tabla.valida = valida;		  
			  return tabla;	    	
	    }
		
    };	
};

registraService("feesValidateService", feesValidateService);