var module = angular.module(contextPath, ['ngSanitize', 'angular-md5','dirPagination',
                                          'infinite-scroll','treeGrid', 'ui.bootstrap',
                                          'ui','dndLists']) ;

function registraController (  controllerName , controller , serviceName , service   )
{
	if((typeof serviceName != 'undefined'  && serviceName != null ))
	{
		module.factory(serviceName, service);
	}
	module.controller(controllerName , controller );  
}

function registraService (  serviceName , service   )
{
	module.factory(serviceName, service);	
}

module.filter('percentage', function() {
	  return function(input) {
		  return input + '%';	    
	  }
});


module.filter('numDigMoneda', function() {
	  return function(unformatedCurrency, n, x) 
	  {		  
		  var re = '\\d(?=(\\d{' + (x || 3) + '})+' + (n > 0 ? '\\.' : '$') + ')';
		  var formated = unformatedCurrency.replace(/ /g, "").replace(/,/g, "").replace("$", "");
		  return Number(formated).toFixed(Math.max(0, ~~n)).replace(new RegExp(re, 'g'), '$&,');
		  
	  }
});

module.filter('numDigNormal', function() {
	  return function(unformatedCurrency) 
	  {		  		  
		  return unformatedCurrency.replace(/ /g, "").replace(/,/g, "").replace("$", "");		  		  
	  }
});

module.filter('removeSpaces', function() {
	  return function(string) {
	        if (!angular.isString(string)) {
	            return string;
	        }
	        return string.replace(/[\s]/g, '');
	    }
});

module.directive('fileModel', ['$parse', function ($parse) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var model = $parse(attrs.fileModel);
            var modelSetter = model.assign;
            
            element.bind('change', function(){
                scope.$apply(function(){
                    modelSetter(scope, element[0].files[0]);
                });
            });
        }
    };
}]);

	
module.directive('fileDownload',function(){
    return{
        restrict:'A',
        scope:{
            fileDownload:'=',
            fileName:'=',
        },

        link:function(scope,elem,atrs){


            scope.$watch('fileDownload',function(newValue, oldValue){

                if(newValue!=undefined && newValue!=null){
                    console.debug('Downloading a new file'); 
                    var isFirefox = typeof InstallTrigger !== 'undefined';
                    var isSafari = Object.prototype.toString.call(window.HTMLElement).indexOf('Constructor') > 0;
                    var isIE = /*@cc_on!@*/false || !!document.documentMode;
                    var isEdge = !isIE && !!window.StyleMedia;
                    var isChrome = !!window.chrome && !!window.chrome.webstore;
                    var isOpera = (!!window.opr && !!opr.addons) || !!window.opera || navigator.userAgent.indexOf(' OPR/') >= 0;
                    var isBlink = (isChrome || isOpera) && !!window.CSS;

                    if(isFirefox || isIE || isChrome){
                        if(isChrome){
                            console.log('Manage Google Chrome download');
                            var url = window.URL || window.webkitURL;
                            var fileURL = url.createObjectURL(scope.fileDownload);
                            var downloadLink = angular.element('<a></a>');//create a new  <a> tag element
                            downloadLink.attr('href',fileURL);
                            downloadLink.attr('download',scope.fileName);
                            downloadLink.attr('target','_self');
                            downloadLink[0].click();//call click function
                            url.revokeObjectURL(fileURL);//revoke the object from URL
                        }
                        if(isIE){
                            console.log('Manage IE download>10');
                            window.navigator.msSaveOrOpenBlob(scope.fileDownload,scope.fileName); 
                        }
                        if(isFirefox){
                            console.log('Manage Mozilla Firefox download');
                            var url = window.URL || window.webkitURL;
                            var fileURL = url.createObjectURL(scope.fileDownload);
                            var a=elem[0];//recover the <a> tag from directive
                            a.href=fileURL;
                            a.download=scope.fileName;
                            a.target='_self';
                            a.click();//we call click function
                        }


                    }else{
                        alert('SORRY YOUR BROWSER IS NOT COMPATIBLE');
                    }
                }
            });

        }
    }
})