package com.mx.dla.dda.reporte.pago.daos;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.reporte.pago.dtos.DetalleContratoDTO;
import com.mx.dla.dda.reporte.pago.dtos.ReportePagoBaseDTO;
import com.mx.dla.dda.reporte.pago.dtos.ReportePagoDTO;
import com.mx.dla.dda.reporte.pago.dtos.ReporteRowDTO;

public interface ReportePagoDAO {
	
	public List<ReportePagoBaseDTO> obtenerReportePagoTitulos(@Param("idContrato") Long idContrato, @Param("fechaI") Date fechaI, @Param("fechaF") Date fechaF);
	
	public List<ReportePagoDTO> obtenerMapeoReportePagoTitulos(@Param("idContrato") Long idContrato, @Param("fechaI") Date fechaI, @Param("fechaF") Date fechaF, @Param("idEstudio") Long idEstudio);
	
	public List<DetalleContratoDTO> obtenerDetalleContratoPorEstudio(@Param("idEstudio") Long idEstudio);
	
	public List<DetalleContratoDTO> obtenerIdsEstudios(@Param("campos") List<String> campos, @Param("valores") List<Integer> valores);
	
	public List<Long> obtenerIdContratos();
	
	public List<ReporteRowDTO> obtenerReporteRows(@Param("mapa") Map<String, String> mapa);

}
